/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.java.Cluster;
import com.couchbase.transactions.AttemptContext;
import com.couchbase.transactions.AttemptContextReactive;
import com.couchbase.transactions.TransactionResult;
import com.couchbase.transactions.TransactionsReactive;
import com.couchbase.transactions.atr.ATRIds;
import com.couchbase.transactions.cleanup.TransactionsCleanup;
import com.couchbase.transactions.config.PerTransactionConfig;
import com.couchbase.transactions.config.PerTransactionConfigBuilder;
import com.couchbase.transactions.config.TransactionConfig;
import com.couchbase.transactions.config.TransactionConfigBuilder;
import com.couchbase.transactions.deferred.TransactionSerializedContext;
import com.couchbase.transactions.error.TransactionFailed;
import com.couchbase.transactions.log.SimpleEventBusLogger;
import com.couchbase.transactions.log.TransactionsStarted;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import reactor.core.publisher.Mono;

public class Transactions
implements AutoCloseable {
    TransactionsReactive reactive;
    static AtomicInteger instancesCreated = new AtomicInteger(0);
    static AtomicInteger instancesCreatedDoingBackgroundCleanup = new AtomicInteger(0);
    private AtomicBoolean closed = new AtomicBoolean(false);

    public static Transactions create(Cluster cluster) {
        return Transactions.create(cluster, TransactionConfigBuilder.create().build());
    }

    public static Transactions create(Cluster cluster, TransactionConfig config) {
        return new Transactions(cluster, config);
    }

    public static Transactions create(Cluster cluster, TransactionConfigBuilder config) {
        return Transactions.create(cluster, config.build());
    }

    private Transactions(Cluster cluster, TransactionConfig config) {
        instancesCreated.incrementAndGet();
        if (config.runLostAttemptsCleanupThread()) {
            instancesCreatedDoingBackgroundCleanup.incrementAndGet();
        }
        if (instancesCreated.get() > 1 || instancesCreatedDoingBackgroundCleanup.get() > 1) {
            SimpleEventBusLogger LOGGER = new SimpleEventBusLogger(cluster.environment().eventBus());
            if (instancesCreatedDoingBackgroundCleanup.get() > 1) {
                LOGGER.error(String.format("Only one Transactions object should be created per application, but have found %d doing background cleanup of transactions.  This will degrade app performance and should be fixed immediately.", instancesCreated.get()));
            } else if (instancesCreated.get() > 1) {
                LOGGER.warn(String.format("Only one Transactions object should be created per application, but have found %d", instancesCreated.get()));
            }
        }
        Objects.requireNonNull(cluster);
        Objects.requireNonNull(config);
        this.reactive = TransactionsReactive.create(cluster, config);
        cluster.environment().eventBus().publish((Event)new TransactionsStarted(config));
    }

    TransactionsCleanup cleanup() {
        return this.reactive.cleanup();
    }

    int cleanupQueueLength() {
        return this.cleanup().cleanupQueueLength();
    }

    static List<String> allAtrs(int numAtrs) {
        return ATRIds.allAtrs(numAtrs);
    }

    public TransactionConfig config() {
        return this.reactive.config();
    }

    public TransactionResult run(Consumer<AttemptContext> transactionLogic, PerTransactionConfig perConfig) throws TransactionFailed {
        return (TransactionResult)this.reactive().runBlocking(transactionLogic, perConfig).block();
    }

    public TransactionResult run(Consumer<AttemptContext> transactionLogic) throws TransactionFailed {
        return (TransactionResult)this.reactive().runBlocking(transactionLogic, PerTransactionConfigBuilder.create().build()).block();
    }

    public TransactionsReactive reactive() {
        if (this.closed.get()) {
            throw new IllegalStateException("Trying to access reactive() on a closed Transactions object!");
        }
        return this.reactive;
    }

    public Mono<TransactionResult> reactive(Function<AttemptContextReactive, Mono<Void>> transactionLogic, PerTransactionConfig perConfig) {
        return this.reactive().run(transactionLogic, perConfig);
    }

    public Mono<TransactionResult> reactive(Function<AttemptContextReactive, Mono<Void>> transactionLogic) {
        return this.reactive().run(transactionLogic, PerTransactionConfigBuilder.create().build());
    }

    @Stability.Volatile
    public TransactionResult commit(TransactionSerializedContext serialized, PerTransactionConfig perConfig) {
        return (TransactionResult)this.reactive().commit(serialized, perConfig).block();
    }

    @Stability.Volatile
    public TransactionResult commit(TransactionSerializedContext serialized) {
        return (TransactionResult)this.reactive().commit(serialized, PerTransactionConfigBuilder.create().build()).block();
    }

    @Stability.Volatile
    public TransactionResult rollback(TransactionSerializedContext serialized, PerTransactionConfig perConfig) {
        return (TransactionResult)this.reactive().rollback(serialized, perConfig).block();
    }

    @Stability.Volatile
    public TransactionResult rollback(TransactionSerializedContext serialized) {
        return (TransactionResult)this.reactive().rollback(serialized, PerTransactionConfigBuilder.create().build()).block();
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.cleanup().stopBackgroundProcesses();
            }
            finally {
                if (this.config().runLostAttemptsCleanupThread()) {
                    instancesCreatedDoingBackgroundCleanup.decrementAndGet();
                }
                instancesCreated.decrementAndGet();
            }
        }
    }
}

