/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions;

import com.couchbase.client.core.msg.kv.MutationToken;
import com.couchbase.client.java.ReactiveCollection;
import com.couchbase.transactions.AttemptContextReactive;
import com.couchbase.transactions.support.AttemptStates;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TransactionAttempt {
    private final Optional<ReactiveCollection> atrCollection;
    private final Optional<String> atrId;
    private final AttemptStates finalState;
    private final String attemptId;
    private final List<String> stagedInsertIds;
    private final List<String> stagedReplaceIds;
    private final List<String> stagedRemoveIds;
    private final Optional<Throwable> terminatedByException;
    private final Duration timeTaken;
    private final Map<String, MutationToken> finalMutationTokens;

    static TransactionAttempt createFromContext(AttemptContextReactive ctx, Optional<Throwable> terminatedByException) {
        Objects.requireNonNull(ctx);
        Objects.requireNonNull(terminatedByException);
        return new TransactionAttempt(ctx.atrCollection(), ctx.atrId(), ctx.state(), ctx.attemptId(), ctx.stagedInsertIds(), ctx.stagedReplaceIds(), ctx.stagedRemoveIds(), terminatedByException, Duration.of(System.nanoTime(), ChronoUnit.NANOS).minus(ctx.startTimeClient()), ctx.finalMutationTokens());
    }

    TransactionAttempt(Optional<ReactiveCollection> atrCollection, Optional<String> atrId, AttemptStates finalState, String attemptId, List<String> stagedInsertIds, List<String> stagedReplaceIds, List<String> stagedRemoveIds, Optional<Throwable> terminatedByException, Duration timeTaken, Map<String, MutationToken> finalMutationTokens) {
        Objects.requireNonNull(atrCollection);
        Objects.requireNonNull(atrId);
        Objects.requireNonNull(finalState);
        Objects.requireNonNull(attemptId);
        Objects.requireNonNull(stagedInsertIds);
        Objects.requireNonNull(stagedReplaceIds);
        Objects.requireNonNull(stagedRemoveIds);
        Objects.requireNonNull(terminatedByException);
        Objects.requireNonNull(timeTaken);
        Objects.requireNonNull(finalMutationTokens);
        this.atrCollection = atrCollection;
        this.atrId = atrId;
        this.finalState = finalState;
        this.attemptId = attemptId;
        this.stagedInsertIds = Collections.unmodifiableList(new ArrayList<String>(stagedInsertIds));
        this.stagedReplaceIds = Collections.unmodifiableList(new ArrayList<String>(stagedReplaceIds));
        this.stagedRemoveIds = Collections.unmodifiableList(new ArrayList<String>(stagedRemoveIds));
        this.terminatedByException = terminatedByException;
        this.timeTaken = timeTaken;
        this.finalMutationTokens = finalMutationTokens;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TransactionAttempt{");
        sb.append("id=").append(this.attemptId.substring(0, 5));
        sb.append(",state=").append((Object)this.finalState);
        if (this.atrCollection.isPresent()) {
            sb.append(",atrColl=").append(this.atrCollection.get());
        } else {
            sb.append(",atr=<none>");
        }
        sb.append('/').append(this.atrId.orElse("<none>"));
        sb.append('}');
        return sb.toString();
    }

    public Duration timeTaken() {
        return this.timeTaken;
    }

    public Optional<ReactiveCollection> atrCollection() {
        return this.atrCollection;
    }

    public Optional<String> atrId() {
        return this.atrId;
    }

    public AttemptStates finalState() {
        return this.finalState;
    }

    public String attemptId() {
        return this.attemptId;
    }

    public List<String> stagedInsertIds() {
        return this.stagedInsertIds;
    }

    public List<String> stagedReplaceIds() {
        return this.stagedReplaceIds;
    }

    public List<String> stagedRemoveIds() {
        return this.stagedRemoveIds;
    }

    public Optional<Throwable> terminatedByException() {
        return this.terminatedByException;
    }

    public List<MutationToken> mutationTokens() {
        return new ArrayList<MutationToken>(this.finalMutationTokens.values());
    }
}

