/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.error.AmbiguousTimeoutException;
import com.couchbase.client.core.error.CasMismatchException;
import com.couchbase.client.core.error.DocumentExistsException;
import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.core.error.DurabilityAmbiguousException;
import com.couchbase.client.core.error.RequestCanceledException;
import com.couchbase.client.core.error.ValueTooLargeException;
import com.couchbase.client.core.error.context.ErrorContext;
import com.couchbase.client.core.error.context.ReducedKeyValueErrorContext;
import com.couchbase.client.core.error.subdoc.PathNotFoundException;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.kv.MutationToken;
import com.couchbase.client.core.retry.reactor.DefaultRetry;
import com.couchbase.client.core.retry.reactor.Jitter;
import com.couchbase.client.core.retry.reactor.Retry;
import com.couchbase.client.core.retry.reactor.RetryContext;
import com.couchbase.client.java.ReactiveCollection;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.kv.LookupInOptions;
import com.couchbase.client.java.kv.LookupInSpec;
import com.couchbase.client.java.kv.MutateInMacro;
import com.couchbase.client.java.kv.MutateInOptions;
import com.couchbase.client.java.kv.MutateInResult;
import com.couchbase.client.java.kv.MutateInSpec;
import com.couchbase.client.java.kv.RemoveOptions;
import com.couchbase.client.java.kv.StoreSemantics;
import com.couchbase.transactions.TransactionContext;
import com.couchbase.transactions.TransactionGetResult;
import com.couchbase.transactions.TransactionInsertOptions;
import com.couchbase.transactions.TransactionJsonDocumentStatus;
import com.couchbase.transactions.TransactionReplaceOptions;
import com.couchbase.transactions.TransactionsReactive;
import com.couchbase.transactions.atr.ATRIds;
import com.couchbase.transactions.components.ATREntry;
import com.couchbase.transactions.components.ATRUtil;
import com.couchbase.transactions.components.ActiveTransactionRecord;
import com.couchbase.transactions.components.DocumentGetter;
import com.couchbase.transactions.components.DocumentMetadata;
import com.couchbase.transactions.config.TransactionConfig;
import com.couchbase.transactions.deferred.TransactionSerializedContext;
import com.couchbase.transactions.error.attempts.ActiveTransactionRecordFull;
import com.couchbase.transactions.error.attempts.ActiveTransactionRecordNotFound;
import com.couchbase.transactions.error.attempts.AttemptException;
import com.couchbase.transactions.error.attempts.AttemptExceptionNoRetry;
import com.couchbase.transactions.error.attempts.DocumentAlreadyInTransaction;
import com.couchbase.transactions.error.internal.AbortedAsRequested;
import com.couchbase.transactions.error.internal.AbortedAsRequestedNoRollback;
import com.couchbase.transactions.error.internal.AbortedAsRequestedNoRollbackNoCleanup;
import com.couchbase.transactions.error.internal.AttemptExpired;
import com.couchbase.transactions.log.IllegalDocumentState;
import com.couchbase.transactions.log.TransactionLogger;
import com.couchbase.transactions.support.AttemptStates;
import com.couchbase.transactions.support.OptionsWrapperUtil;
import com.couchbase.transactions.support.SpanWrapper;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class AttemptContextReactive {
    private final TransactionConfig config;
    private final ConcurrentLinkedQueue<StagedMutation> stagedMutations = new ConcurrentLinkedQueue();
    private final String attemptId;
    private final TransactionContext overall;
    private final Duration startTimeClient;
    private Duration startTimeServer;
    private Optional<String> atrId = Optional.empty();
    private Optional<ReactiveCollection> atrCollection = Optional.empty();
    private boolean isDone = false;
    final TransactionLogger LOGGER;
    private AttemptStates state = AttemptStates.NOT_STARTED;
    private final TransactionsReactive parent;
    private final SpanWrapper attemptSpan;
    private boolean expiryOvertimeMode = false;
    public static String HOOK_ROLLBACK = "rollback";
    public static String HOOK_GET = "get";
    public static String HOOK_INSERT = "insert";
    public static String HOOK_REPLACE = "replace";
    public static String HOOK_REMOVE = "remove";
    public static String HOOK_BEFORE_COMMIT = "commit";
    public static String HOOK_ABORT_GET_ATR = "abortGetAtr";
    public static String HOOK_ROLLBACK_DOC = "rollbackDoc";
    public static String HOOK_DELETE_INSERTED = "deleteInserted";
    public static String HOOK_CREATE_STAGED_INSERT = "createdStagedInsert";
    public static String HOOK_REMOVE_DOC = "removeDoc";
    public static String HOOK_COMMIT_DOC = "commitDoc";
    public static String HOOK_ATR_COMMIT = "atrCommit";
    public static String HOOK_ATR_ABORT = "atrAbort";
    public static String HOOK_ATR_ROLLBACK_COMPLETE = "atrRollbackComplete";
    public static String HOOK_ATR_PENDING = "atrPending";
    public static String HOOK_ATR_COMPLETE = "atrComplete";
    private final Map<String, MutationToken> finalMutationTokens = new HashMap<String, MutationToken>();

    public AttemptContextReactive(TransactionContext overall, TransactionConfig config, String attemptId, TransactionsReactive parent, Optional<SpanWrapper> parentSpan) {
        Objects.requireNonNull(overall);
        Objects.requireNonNull(config);
        Objects.requireNonNull(attemptId);
        Objects.requireNonNull(parent);
        this.LOGGER = overall.LOGGER;
        this.overall = overall;
        this.config = config;
        this.attemptId = attemptId;
        this.startTimeClient = Duration.of(System.nanoTime(), ChronoUnit.MILLIS);
        this.parent = parent;
        this.attemptSpan = SpanWrapper.create(config, "transaction_attempt", parentSpan).withTag("couchbase.transaction_id", overall.transactionId()).withTag("couchbase.attempt_id", attemptId).start();
    }

    private JsonObject dehydrate() {
        JsonObject ob = JsonObject.create();
        ob.put("transactionId", this.transactionId());
        ob.put("attemptId", this.attemptId);
        ob.put("atrId", this.atrId.get());
        ob.put("atrBucket", this.atrCollection.get().bucketName());
        ob.put("atrScope", this.atrCollection.get().scopeName());
        ob.put("atrCollection", this.atrCollection.get().name());
        long transactionElapsedTimeMillis = (System.nanoTime() - this.overall.startTimeClient().toNanos()) / 1000000L;
        ob.put("transactionElapsedTimeMillis", transactionElapsedTimeMillis);
        ob.put("startTimeServerMillis", this.startTimeServer.toMillis());
        JsonArray mutations = JsonArray.create();
        this.stagedMutations.forEach(sm -> {
            JsonObject m = JsonObject.create();
            m.put("type", sm.type.toString());
            switch (sm.type) {
                case REMOVE: {
                    break;
                }
                default: {
                    m.put("content", Base64.getEncoder().encodeToString(sm.content));
                }
            }
            sm.doc.serialize(m);
            mutations.add(m);
        });
        ob.put("mutations", mutations);
        return ob;
    }

    public AttemptContextReactive(JsonObject pill, TransactionContext overall, TransactionConfig config, TransactionsReactive parent, Optional<SpanWrapper> parentSpan) {
        this.LOGGER = overall.LOGGER;
        this.overall = overall;
        this.config = config;
        this.attemptId = pill.getString("attemptId");
        this.startTimeClient = Duration.of(System.nanoTime(), ChronoUnit.MILLIS);
        this.atrId = Optional.of(pill.getString("atrId"));
        String atrBucket = pill.getString("atrBucket");
        this.atrCollection = Optional.of(parent.cleanup().clusterData().getBucketDefaultCollection(atrBucket).block());
        this.parent = parent;
        JsonArray mutations = pill.getArray("mutations");
        mutations.iterator().forEachRemaining(v -> {
            JsonObject jo = (JsonObject)v;
            TransactionGetResult doc = TransactionGetResult.createFrom(jo, parent.cleanup().clusterData());
            StagedMutationType type = StagedMutationType.REMOVE;
            switch (jo.getString("type")) {
                case "INSERT": {
                    type = StagedMutationType.INSERT;
                    break;
                }
                case "REPLACE": {
                    type = StagedMutationType.REPLACE;
                }
            }
            switch (type) {
                case REMOVE: {
                    StagedMutation sm = new StagedMutation(doc, null, type, null);
                    this.stagedMutations.add(sm);
                    break;
                }
                default: {
                    byte[] bytes = Base64.getDecoder().decode(jo.getString("content"));
                    StagedMutation sm = new StagedMutation(doc, bytes, type, null);
                    this.stagedMutations.add(sm);
                }
            }
        });
        this.attemptSpan = SpanWrapper.create(config, "transaction_attempt", parentSpan).withTag("couchbase.transaction_id", overall.transactionId()).withTag("couchbase.attempt_id", this.attemptId).start();
    }

    SpanWrapper span() {
        return this.attemptSpan;
    }

    Duration startTimeClient() {
        return this.startTimeClient;
    }

    public String attemptId() {
        return this.attemptId;
    }

    public String transactionId() {
        return this.overall.transactionId();
    }

    TransactionContext overall() {
        return this.overall;
    }

    private List<StagedMutation> stagedReplaces() {
        return this.stagedMutations.stream().filter(v -> v.type == StagedMutationType.REPLACE).collect(Collectors.toList());
    }

    private List<StagedMutation> stagedRemoves() {
        return this.stagedMutations.stream().filter(v -> v.type == StagedMutationType.REMOVE).collect(Collectors.toList());
    }

    private List<StagedMutation> stagedInserts() {
        return this.stagedMutations.stream().filter(v -> v.type == StagedMutationType.INSERT).collect(Collectors.toList());
    }

    private Optional<StagedMutation> checkForOwnWrite(ReactiveCollection collection, String id) {
        Optional<StagedMutation> ownReplace = this.stagedReplaces().stream().filter(v -> v.doc.collection().bucketName().equals(collection.bucketName()) && v.doc.collection().scopeName().equals(collection.scopeName()) && v.doc.collection().name().equals(collection.name()) && v.doc.id().equals(id)).findFirst();
        if (ownReplace.isPresent()) {
            return ownReplace;
        }
        Optional<StagedMutation> ownInserted = this.stagedInserts().stream().filter(v -> v.doc.collection().bucketName().equals(collection.bucketName()) && v.doc.collection().scopeName().equals(collection.scopeName()) && v.doc.collection().name().equals(collection.name()) && v.doc.id().equals(id)).findFirst();
        if (ownInserted.isPresent()) {
            return ownInserted;
        }
        return Optional.empty();
    }

    private void checkExpiryPreCommit(String stage) {
        if (this.hasExpiredClientSide(stage)) {
            this.LOGGER.info(this.attemptId, "has expired in stage %s, entering expiry-overtime mode - will make one attempt to rollback", stage);
            this.expiryOvertimeMode = true;
            AttemptExpired err = new AttemptExpired(this, "Attempt has expired in stage " + stage, false);
            throw err;
        }
    }

    public Mono<Optional<TransactionGetResult>> getOptional(ReactiveCollection collection, String id) {
        return Mono.defer(() -> {
            SpanWrapper span = SpanWrapper.create(this.config, collection, "transaction_get", id, this.attemptSpan);
            Mono out = Mono.defer(() -> {
                if (this.isDone) {
                    return Mono.error((Throwable)new IllegalStateException("Cannot perform operations after transaction has been committed or rolled back"));
                }
                this.checkExpiryPreCommit(HOOK_GET);
                Optional<StagedMutation> ownWrite = this.checkForOwnWrite(collection, id);
                if (ownWrite.isPresent()) {
                    this.LOGGER.info(this.attemptId, "found own-write of mutated doc %s", RedactableArgument.redactUser((Object)id));
                    return Mono.just(Optional.of(TransactionGetResult.createFrom(ownWrite.get().doc, ownWrite.get().content, TransactionJsonDocumentStatus.OWN_WRITE)));
                }
                Optional<TransactionGetResult> ownRemove = this.stagedRemoves().stream().filter(v -> v.doc.collection().bucketName().equals(collection.bucketName()) && v.doc.collection().scopeName().equals(collection.scopeName()) && v.doc.collection().name().equals(collection.name()) && v.doc.id().equals(id)).findFirst().map(v -> v.doc);
                if (ownRemove.isPresent()) {
                    this.LOGGER.info(this.attemptId, "found own-write of removed doc %s", RedactableArgument.redactUser((Object)id));
                    return Mono.just(Optional.empty());
                }
                return this.beforeDocGet(this, id).then(DocumentGetter.getAsync(collection, this.config, id, this.attemptId, span, this.getTranscoder()).doOnError(err -> this.LOGGER.warn(this.attemptId, "got error while getting doc %s: %s", RedactableArgument.redactUser((Object)id), err)).doOnSubscribe(x -> {
                    this.LOGGER.info(this.attemptId, "getting doc %s", RedactableArgument.redactUser((Object)id));
                    span.start();
                }).flatMap(v -> {
                    long elapsed = span.finish();
                    if (v.isPresent()) {
                        this.LOGGER.info(this.attemptId, "completed get of %s in %dms", v.get(), elapsed);
                    } else {
                        this.LOGGER.info(this.attemptId, "completed get of %s, could not find, in %dms", RedactableArgument.redactUser((Object)id), elapsed);
                    }
                    return this.afterGetComplete(this, id).map(x -> v);
                }));
            });
            return out;
        });
    }

    public Mono<TransactionGetResult> get(ReactiveCollection collection, String id) {
        return this.getOptional(collection, id).flatMap(doc -> {
            if (doc.isPresent()) {
                return Mono.just(doc.get());
            }
            return Mono.error((Throwable)new DocumentNotFoundException((ErrorContext)ReducedKeyValueErrorContext.create((String)id)));
        });
    }

    boolean isExpiryOvertimeMode() {
        return this.expiryOvertimeMode;
    }

    boolean hasExpiredClientSide(String place) {
        boolean over = this.overall.hasExpiredClientSide(this.config);
        boolean hook = this.hasExpiredClientSideHook(this, place);
        if (over) {
            this.LOGGER.info(this.attemptId, "expired in %s", place);
        }
        if (hook) {
            this.LOGGER.info(this.attemptId, "fake expiry in %s", place);
        }
        return over || hook;
    }

    Map<String, MutationToken> finalMutationTokens() {
        return this.finalMutationTokens;
    }

    public Optional<String> atrId() {
        return this.atrId;
    }

    public Optional<ReactiveCollection> atrCollection() {
        return this.atrCollection;
    }

    List<String> stagedReplaceIds() {
        return this.stagedReplaces().stream().map(v -> v.doc.id()).collect(Collectors.toList());
    }

    List<String> stagedInsertIds() {
        return this.stagedInserts().stream().map(v -> v.doc.id()).collect(Collectors.toList());
    }

    List<String> stagedRemoveIds() {
        return this.stagedRemoves().stream().map(v -> v.doc.id()).collect(Collectors.toList());
    }

    private int allStagedCount() {
        return this.stagedMutations.size();
    }

    public Mono<TransactionGetResult> insert(ReactiveCollection collection, String id, Object content) {
        return this.insert(collection, id, content, TransactionInsertOptions.DEFAULT);
    }

    public Mono<TransactionGetResult> insert(ReactiveCollection collection, String id, Object content, TransactionInsertOptions options) {
        TransactionInsertOptions.BuiltOptions built = options.build();
        SpanWrapper span = SpanWrapper.create(this.config, collection, HOOK_INSERT, id, this.attemptSpan);
        return Mono.defer(() -> {
            if (this.isDone) {
                return Mono.error((Throwable)new IllegalStateException("Cannot perform operations after transaction has been committed or rolled back"));
            }
            this.checkExpiryPreCommit(HOOK_INSERT);
            this.initAtrIfNeeded(collection, id);
            if (this.allStagedCount() == 0) {
                return this.atrPending(collection, span);
            }
            return Mono.empty();
        }).then(this.createStagedInsert(collection, id, content, span, built)).doFinally(v -> span.finish()).doOnSubscribe(s -> span.start());
    }

    protected String randomAtrIdForVbucket(AttemptContextReactive self, Integer vbucketIdForDoc, int numAtrs) {
        return ATRIds.randomAtrIdForVbucket(vbucketIdForDoc, numAtrs);
    }

    private void initAtrIfNeeded(ReactiveCollection collection, String id) {
        if (!this.atrId.isPresent()) {
            long vbucketIdForDoc = ATRIds.vbucketForKey(id, 1024);
            String atr = this.randomAtrIdForVbucket(this, (int)vbucketIdForDoc, this.config.numAtrs());
            this.atrId = Optional.of(atr);
            this.atrCollection = Optional.of(collection);
            this.state = AttemptStates.PENDING;
            this.LOGGER.info(this.attemptId, "First mutated doc in txn is '%s' on vbucket %d, so using atr %s", RedactableArgument.redactUser((Object)id), vbucketIdForDoc, atr);
        }
    }

    public Mono<TransactionGetResult> replace(TransactionGetResult doc, Object content) {
        return this.replace(doc, content, TransactionReplaceOptions.DEFAULT);
    }

    public Mono<TransactionGetResult> replace(TransactionGetResult doc, Object content, TransactionReplaceOptions options) {
        return Mono.defer(() -> {
            SpanWrapper span = SpanWrapper.create(this.config, doc, HOOK_REPLACE, this.attemptSpan);
            return Mono.defer(() -> {
                this.LOGGER.info(this.attemptId, "replace doc %s", doc);
                if (this.isDone) {
                    return Mono.error((Throwable)new IllegalStateException("Cannot perform operations after transaction has been committed or rolled back"));
                }
                this.checkExpiryPreCommit(HOOK_REPLACE);
                return this.checkAndHandleBlockingTxn(doc, span).then(Mono.defer(() -> {
                    this.initAtrIfNeeded(doc.collection(), doc.id());
                    if (this.allStagedCount() == 0) {
                        return this.atrPending(doc.collection(), span);
                    }
                    return Mono.empty();
                })).then(this.createStagedReplace(doc, content, options.build(), span));
            }).doOnSubscribe(s -> span.start()).doFinally(s -> span.finish());
        });
    }

    private Mono<ReactiveCollection> getBucketDefaultCollection(String name) {
        return this.parent.cleanup().clusterData().getBucketDefaultCollection(name);
    }

    private Mono<Void> checkATREntryForBlockingDoc(TransactionGetResult doc, SpanWrapper pspan) {
        return Mono.defer(() -> {
            SpanWrapper span = SpanWrapper.create(this.config, doc, "transaction_check_atr_blocking", this.attemptSpan);
            return this.getBucketDefaultCollection(doc.links().atrBucketName().get()).flatMap(collection -> this.beforeCheckATREntryForBlockingDoc(this, doc.links().atrId().get()).then(ActiveTransactionRecord.findEntryForTransaction(collection, doc.links().atrId().get(), doc.links().stagedAttemptId().get(), this.config.keyValueTimeout(), this.config, span).flatMap(atrEntry -> {
                if (atrEntry.isPresent()) {
                    this.LOGGER.info(this.attemptId, "fetched ATR entry for blocking txn, still blocked: %s", atrEntry.get());
                    return Mono.error((Throwable)DocumentAlreadyInTransaction.create(this, doc));
                }
                this.LOGGER.info(this.attemptId, "blocking txn %s's entry has been removed indicating the txn expired, so proceeding to overwrite", doc.links().stagedAttemptId().get());
                return Mono.empty();
            }).then().doOnError(err -> this.LOGGER.warn(this.attemptId, "got error in checkATREntryForBlockingDoc: %s", err.getMessage())).doOnSubscribe(s -> span.start()).doFinally(s -> span.finish())));
        });
    }

    private String getAtrDebug(ReactiveCollection collection, Optional<String> atrId) {
        return ATRUtil.getAtrDebug(collection, atrId);
    }

    private String getAtrDebug(Optional<ReactiveCollection> collection, Optional<String> atrId) {
        return ATRUtil.getAtrDebug(collection, atrId);
    }

    private RemoveOptions wrap(RemoveOptions opts, SpanWrapper pspan) {
        return OptionsWrapperUtil.wrap(opts, pspan, this.config, this.overall.perTransactionConfig());
    }

    private MutateInOptions wrap(MutateInOptions opts, SpanWrapper pspan) {
        return OptionsWrapperUtil.wrap(opts, pspan, this.config, this.overall.perTransactionConfig());
    }

    private MutateInOptions wrap(SpanWrapper pspan) {
        return OptionsWrapperUtil.wrap(pspan, this.config, this.overall.perTransactionConfig());
    }

    private Mono<MutateInResult> atrPending(ReactiveCollection collection, SpanWrapper pspan) {
        SpanWrapper span = SpanWrapper.createATROp(this.config, this.atrCollection, this.atrId, HOOK_ATR_PENDING, this.attemptSpan);
        String prefix = "attempts." + this.attemptId;
        if (!this.atrId.isPresent()) {
            return Mono.error((Throwable)new IllegalStateException("atrId not present"));
        }
        return this.beforeAtrPending(this).then(collection.mutateIn(this.atrId.get(), Arrays.asList(MutateInSpec.insert((String)(prefix + "." + "st"), (Object)AttemptStates.PENDING.name()).xattr().createPath(), MutateInSpec.insert((String)(prefix + "." + "tst"), (Object)MutateInMacro.CAS), MutateInSpec.insert((String)(prefix + "." + "exp"), (Object)this.config.transactionExpirationTime().toMillis()).xattr()), this.wrap(((MutateInOptions)MutateInOptions.mutateInOptions().clientContext(OptionsWrapperUtil.createClientContext("atrPending"))).storeSemantics(StoreSemantics.UPSERT), pspan))).flatMap(v -> {
            long elapsed = span.finish();
            this.LOGGER.info(this.attemptId, "set ATR %s to Pending in %dms, got CAS (start time) %s", this.getAtrDebug(collection, this.atrId), elapsed, this.dbg((MutateInResult)v));
            this.startTimeServer = Duration.ofNanos(v.cas());
            return this.afterAtrPending(this).map(x -> v);
        }).doOnSubscribe(v -> {
            span.start();
            this.LOGGER.info(this.attemptId, "about to set ATR %s to Pending", this.getAtrDebug(collection, this.atrId));
            this.checkExpiryDuringCommitOrRollback(HOOK_ATR_PENDING);
        }).onErrorResume(err -> {
            this.LOGGER.info(this.attemptId, "error %s while setting ATR %s to Pending", err, this.getAtrDebug(collection, this.atrId));
            if (err instanceof ValueTooLargeException) {
                return Mono.error((Throwable)new ActiveTransactionRecordFull(this, (Throwable)err));
            }
            return Mono.error((Throwable)err);
        });
    }

    private Transcoder getTranscoder() {
        return this.parent.cleanup().clusterData().cluster().environment().transcoder();
    }

    private Mono<TransactionGetResult> createStagedReplace(TransactionGetResult doc, Object content, TransactionReplaceOptions.BuiltOptions options, SpanWrapper pspan) {
        return Mono.defer(() -> {
            SpanWrapper span = SpanWrapper.create(this.config, doc, "transaction_staged_replace", this.attemptSpan);
            Transcoder.EncodedValue encoded = this.getTranscoder().encode(content);
            List<MutateInSpec> ops = this.createMutationOps("replace", doc);
            ops.add((MutateInSpec)MutateInSpec.upsert((String)"txn.op.stgd", (Object)encoded.encoded()).xattr());
            return this.beforeStagedReplace(this, doc.id()).then(doc.collection().mutateIn(doc.id(), ops, this.wrap(((MutateInOptions)MutateInOptions.mutateInOptions().clientContext(OptionsWrapperUtil.createClientContext("createStagedReplace"))).cas(doc.cas()), pspan))).doOnSubscribe(v -> {
                this.LOGGER.info(this.attemptId, "about to replace doc %s with cas %d", RedactableArgument.redactUser((Object)doc.id()), doc.cas());
                span.start();
            }).flatMap(result -> this.afterStagedReplaceCompleteBeforeCASSaved(this, doc.id()).map(x -> result)).flatMap(updatedDoc -> {
                long elapsed = span.finish();
                doc.cas(updatedDoc.cas());
                this.LOGGER.info(this.attemptId, "replaced doc %s got %s, in %dms", RedactableArgument.redactUser((Object)doc.id()), this.dbg((MutateInResult)updatedDoc), elapsed);
                Optional<StagedMutation> overwritingInsert = this.findStagedInsert(doc);
                Optional<StagedMutation> overwritingReplace = this.findStagedReplace(doc);
                overwritingReplace.ifPresent(stagedMutation -> {
                    this.LOGGER.info(this.attemptId, "doc %s is being replaced after being replaced in the same txn", RedactableArgument.redactUser((Object)doc.id()));
                    this.stagedMutations.remove(stagedMutation);
                });
                if (overwritingInsert.isPresent()) {
                    this.LOGGER.info(this.attemptId, "doc %s is being replaced after being inserted in the same txn", RedactableArgument.redactUser((Object)doc.id()));
                    this.stagedMutations.remove(overwritingInsert.get());
                    this.stagedMutations.add(new StagedMutation(doc, encoded.encoded(), StagedMutationType.INSERT, (MutateInResult)updatedDoc));
                } else {
                    this.stagedMutations.add(new StagedMutation(doc, encoded.encoded(), StagedMutationType.REPLACE, (MutateInResult)updatedDoc));
                }
                return this.afterStagedReplaceComplete(this, doc.id()).map(x -> updatedDoc);
            }).map(updatedDoc -> doc);
        });
    }

    private List<MutateInSpec> createMutationOps(String op, TransactionGetResult doc) {
        ArrayList<MutateInSpec> ops = new ArrayList<MutateInSpec>();
        ops.add((MutateInSpec)MutateInSpec.upsert((String)"txn.id.txn", (Object)this.transactionId()).xattr().createPath());
        ops.add((MutateInSpec)MutateInSpec.upsert((String)"txn.id.atmpt", (Object)this.attemptId).xattr().createPath());
        ops.add((MutateInSpec)MutateInSpec.upsert((String)"txn.atr.id", (Object)this.atrId.get()).xattr().createPath());
        ops.add((MutateInSpec)MutateInSpec.upsert((String)"txn.atr.bkt", (Object)this.atrCollection.get().bucketName()).xattr());
        ops.add((MutateInSpec)MutateInSpec.upsert((String)"txn.atr.coll", (Object)(this.atrCollection.get().scopeName() + "." + this.atrCollection.get().name())).xattr());
        ops.add((MutateInSpec)MutateInSpec.upsert((String)"txn.op.type", (Object)op).xattr().createPath());
        doc.documentMetadata().flatMap(DocumentMetadata::cas).ifPresent(v -> ops.add((MutateInSpec)MutateInSpec.upsert((String)"txn.restore.CAS", (Object)v).xattr().createPath()));
        doc.documentMetadata().flatMap(DocumentMetadata::exptime).ifPresent(v -> ops.add((MutateInSpec)MutateInSpec.upsert((String)"txn.restore.exptime", (Object)v).xattr().createPath()));
        doc.documentMetadata().flatMap(DocumentMetadata::revid).ifPresent(v -> ops.add((MutateInSpec)MutateInSpec.upsert((String)"txn.restore.revid", (Object)v).xattr().createPath()));
        return ops;
    }

    private Mono<Void> createStagedRemove(TransactionGetResult doc, SpanWrapper pspan) {
        return Mono.defer(() -> {
            SpanWrapper span = SpanWrapper.create(this.config, doc, "transaction_staged_remove", this.attemptSpan);
            List<MutateInSpec> ops = this.createMutationOps("remove", doc);
            ops.add((MutateInSpec)MutateInSpec.upsert((String)"txn.op.stgd", (Object)"<<REMOVE>>").xattr());
            return this.beforeStagedRemove(this, doc.id()).then(doc.collection().mutateIn(doc.id(), ops, this.wrap(((MutateInOptions)MutateInOptions.mutateInOptions().clientContext(OptionsWrapperUtil.createClientContext("createdStagedRemove"))).cas(doc.cas()), pspan))).doOnSubscribe(x -> {
                this.LOGGER.info(this.attemptId, "about to remove doc %s with cas %d", RedactableArgument.redactUser((Object)doc.id()), doc.cas());
                span.start();
            }).flatMap(updatedDoc -> this.afterStagedRemoveComplete(this, doc.id()).thenReturn(updatedDoc)).doOnNext(updatedDoc -> {
                long elapsed = span.finish();
                this.LOGGER.info(this.attemptId, "staged remove of doc %s got %s, in %dms", RedactableArgument.redactUser((Object)doc.id()), this.dbg((MutateInResult)updatedDoc), elapsed);
                doc.cas(updatedDoc.cas());
                Optional<StagedMutation> overwritingInsert = this.findStagedInsert(doc);
                if (overwritingInsert.isPresent()) {
                    throw new IllegalStateException("doc " + RedactableArgument.redactUser((Object)doc.id()) + " is being removed after being inserted in the same txn: this is an application error");
                }
                this.stagedMutations.add(new StagedMutation(doc, null, StagedMutationType.REMOVE, (MutateInResult)updatedDoc));
            }).then();
        });
    }

    private Optional<StagedMutation> findStagedInsert(TransactionGetResult doc) {
        ReactiveCollection collection = doc.collection();
        Optional<StagedMutation> overwritingInsert = this.stagedInserts().stream().filter(v -> v.doc.collection().bucketName().equals(collection.bucketName()) && v.doc.collection().scopeName().equals(collection.scopeName()) && v.doc.collection().name().equals(collection.name()) && v.doc.id().equals(doc.id())).findFirst();
        return overwritingInsert;
    }

    private Optional<StagedMutation> findStagedReplace(TransactionGetResult doc) {
        ReactiveCollection collection = doc.collection();
        return this.stagedReplaces().stream().filter(v -> v.doc.collection().bucketName().equals(collection.bucketName()) && v.doc.collection().scopeName().equals(collection.scopeName()) && v.doc.collection().name().equals(collection.name()) && v.doc.id().equals(doc.id())).findFirst();
    }

    private Mono<TransactionGetResult> handleDocExistsDuringStagedInsert(ReactiveCollection collection, String id, Object content, SpanWrapper pspan, TransactionInsertOptions.BuiltOptions options) {
        String bp = "DocExists on " + RedactableArgument.redactUser((Object)id) + ": ";
        return this.beforeGetDocInExistsDuringStagedInsert(this, id).then(DocumentGetter.justGetDoc(collection, this.config, id, pspan, this.getTranscoder())).doOnSubscribe(x -> this.LOGGER.info(this.attemptId, "%s getting doc", bp)).doOnError(err -> this.LOGGER.warn(this.attemptId, "%s got error while getting doc: %s", bp, err.getMessage())).flatMap(v -> {
            if (v.isPresent()) {
                if (!((TransactionGetResult)v.get()).links().isDocumentInTransaction()) {
                    this.LOGGER.info(this.attemptId, "%s doc %s exists but is not in txn, raising DocumentAlreadyExistsException", bp, RedactableArgument.redactUser((Object)id));
                    return Mono.error((Throwable)new DocumentExistsException((ErrorContext)ReducedKeyValueErrorContext.create((String)id)));
                }
                this.LOGGER.info(this.attemptId, "%s doc %s exists and is in txn", bp, RedactableArgument.redactUser((Object)id));
                return this.checkAndHandleBlockingTxn((TransactionGetResult)v.get(), pspan);
            }
            this.LOGGER.info(this.attemptId, "%s completed get of %s, could not find, throwing to retry txn which should succeed now", bp, RedactableArgument.redactUser((Object)id));
            return Mono.error((Throwable)new DocumentExistsException((ErrorContext)ReducedKeyValueErrorContext.create((String)id)));
        }).then(this.beforeRemovingDocDuringStagedInsert(this, id).then(collection.remove(id).doOnSubscribe(v -> this.LOGGER.info(this.attemptId, "removing blocking staged insert %s before trying to insert it again", RedactableArgument.redactUser((Object)id))).then(this.createStagedInsert(collection, id, content, pspan, options).doOnSubscribe(v -> this.LOGGER.info(this.attemptId, "retrying staged insert on %s", RedactableArgument.redactUser((Object)id))))));
    }

    private Mono<TransactionGetResult> createStagedInsert(ReactiveCollection collection, String id, Object content, SpanWrapper pspan, TransactionInsertOptions.BuiltOptions options) {
        return Mono.defer(() -> {
            SpanWrapper span = SpanWrapper.create(this.config, HOOK_CREATE_STAGED_INSERT, this.attemptSpan).withTag("couchbase.bucket_name", collection.bucketName()).withTag("couchbase.collection_name", collection.name()).withTag("couchbase.document_key", RedactableArgument.redactUser((Object)id).toString());
            Transcoder.EncodedValue encoded = this.getTranscoder().encode(content);
            return this.beforeStagedInsert(this, id).doOnSubscribe(x -> {
                this.LOGGER.info(this.attemptId, "about to insert staged doc %s", RedactableArgument.redactUser((Object)id));
                this.checkExpiryDuringCommitOrRollback(HOOK_CREATE_STAGED_INSERT);
                span.start();
            }).then(collection.mutateIn(id, Arrays.asList(MutateInSpec.upsert((String)"txn.id.txn", (Object)this.transactionId()).xattr().createPath(), MutateInSpec.upsert((String)"txn.id.atmpt", (Object)this.attemptId).xattr().createPath(), MutateInSpec.upsert((String)"txn.atr.id", (Object)this.atrId.get()).xattr().createPath(), MutateInSpec.upsert((String)"txn.op.stgd", (Object)encoded.encoded()).xattr().createPath(), MutateInSpec.upsert((String)"txn.atr.bkt", (Object)this.atrCollection.get().bucketName()).xattr(), MutateInSpec.upsert((String)"txn.atr.coll", (Object)(this.atrCollection.get().scopeName() + "." + this.atrCollection.get().name())).xattr().createPath(), MutateInSpec.upsert((String)"txn.op.type", (Object)"insert").xattr()), this.wrap(((MutateInOptions)MutateInOptions.mutateInOptions().clientContext(OptionsWrapperUtil.createClientContext("createStagedInsert"))).storeSemantics(StoreSemantics.INSERT), pspan))).doOnNext(updatedDoc -> {
                long elapsed = span.finish();
                this.LOGGER.info(this.attemptId, "inserted doc %s got %s, in %dms", RedactableArgument.redactUser((Object)id), this.dbg((MutateInResult)updatedDoc), elapsed);
            }).flatMap(updatedDoc -> this.afterStagedInsertComplete(this, id).thenReturn(updatedDoc)).map(updatedDoc -> {
                TransactionGetResult out = TransactionGetResult.createFromInsert(collection, id, encoded.encoded(), this.transactionId(), this.attemptId, this.atrId.get(), this.atrCollection.get().bucketName(), this.atrCollection.get().scopeName(), this.atrCollection.get().name(), updatedDoc, this.getTranscoder());
                this.stagedMutations.add(new StagedMutation(out, encoded.encoded(), StagedMutationType.INSERT, (MutateInResult)updatedDoc));
                return out;
            }).retryWhen(this.retryAmbiguousErrors(HOOK_CREATE_STAGED_INSERT)).onErrorResume(err -> {
                this.LOGGER.info(this.attemptId, "got err %s while staging insert of %s", err.toString(), RedactableArgument.redactUser((Object)id));
                if (err instanceof DocumentExistsException) {
                    return this.handleDocExistsDuringStagedInsert(collection, id, content, pspan, options);
                }
                return Mono.error((Throwable)err);
            });
        });
    }

    public Mono<Void> remove(TransactionGetResult doc) {
        return Mono.defer(() -> {
            SpanWrapper span = SpanWrapper.create(this.config, doc, HOOK_REMOVE, this.attemptSpan);
            if (this.isDone) {
                return Mono.error((Throwable)new IllegalStateException("Cannot perform operations after transaction has been committed or rolled back"));
            }
            this.checkExpiryPreCommit(HOOK_REMOVE);
            return this.checkAndHandleBlockingTxn(doc, span).then(Mono.defer(() -> {
                this.initAtrIfNeeded(doc.collection(), doc.id());
                if (this.allStagedCount() == 0) {
                    return this.atrPending(doc.collection(), span);
                }
                return Mono.empty();
            })).then(this.createStagedRemove(doc, span)).doOnSubscribe(v -> {
                span.start();
                this.LOGGER.info(this.attemptId, "remove doc %s", RedactableArgument.redactUser((Object)doc.id()));
            }).doFinally(v -> span.finish());
        });
    }

    private Mono<Void> checkAndHandleBlockingTxn(TransactionGetResult doc, SpanWrapper pspan) {
        if (doc.links().hasStagedWrite()) {
            if (doc.links().stagedTransactionId().get().equals(this.transactionId())) {
                this.LOGGER.info(this.attemptId, "doc %s has been written by this transaction, ok to continue", RedactableArgument.redactUser((Object)doc.id()));
                return Mono.empty();
            }
            long elapsedSinceStartOfTxnMsecs = (System.nanoTime() - this.overall.startTimeClient().toNanos()) / 1000000L;
            if (elapsedSinceStartOfTxnMsecs < 1000L) {
                this.LOGGER.info(this.attemptId, "doc %s is in another txn %s, just retrying as only %dms since start", RedactableArgument.redactUser((Object)doc.id()), doc.links().stagedAttemptId().get(), elapsedSinceStartOfTxnMsecs);
                return Mono.error((Throwable)DocumentAlreadyInTransaction.create(this, doc));
            }
            if (doc.links().atrId().isPresent() && doc.links().atrBucketName().isPresent()) {
                this.LOGGER.info(this.attemptId, "doc %s is in another txn %s, after %dms since start so checking ATR entry %s/%s/%s to see if blocked", RedactableArgument.redactUser((Object)doc.id()), doc.links().stagedAttemptId().get(), elapsedSinceStartOfTxnMsecs, doc.links().atrBucketName().orElse(""), doc.links().atrCollectionName().orElse(""), doc.links().atrId().orElse(""));
                return this.checkATREntryForBlockingDoc(doc, pspan);
            }
            this.LOGGER.info(this.attemptId, "doc %s is in another txn %s, after %dms since start but cannot check ATR entry - probably a bug, so proceeding to overwrite", RedactableArgument.redactUser((Object)doc.id()), doc.links().stagedAttemptId().get(), elapsedSinceStartOfTxnMsecs);
            return Mono.empty();
        }
        return Mono.empty();
    }

    private List<JsonObject> listStagedToDocRecords(List<StagedMutation> docs) {
        return this.listToDocRecords(docs.stream().map(v -> v.doc).collect(Collectors.toList()));
    }

    private List<JsonObject> listToDocRecords(List<TransactionGetResult> docs) {
        return docs.stream().map(v -> JsonObject.create().put("id", v.id()).put("bkt", v.collection().bucketName()).put("scp", v.collection().scopeName()).put("col", v.collection().name())).collect(Collectors.toList());
    }

    private List<MutateInSpec> addDocsToBuilder() {
        String prefix = "attempts." + this.attemptId;
        return Arrays.asList(MutateInSpec.upsert((String)(prefix + "." + "ins"), this.listStagedToDocRecords(this.stagedInserts())).xattr(), MutateInSpec.upsert((String)(prefix + "." + "rep"), this.listStagedToDocRecords(this.stagedReplaces())).xattr(), MutateInSpec.upsert((String)(prefix + "." + "rem"), this.listStagedToDocRecords(this.stagedRemoves())).xattr());
    }

    @Stability.Volatile
    public Mono<Void> defer() {
        return Mono.fromRunnable(() -> {
            String json = this.dehydrate().toString();
            this.LOGGER.info(this.attemptId, "deferring commit, serialized is %d chars", json.length());
            this.overall.serialized(TransactionSerializedContext.createFrom(json));
        }).then();
    }

    @Stability.Volatile
    Optional<TransactionSerializedContext> serialized() {
        return this.overall.serialized();
    }

    public Mono<Void> commit() {
        return Mono.defer(() -> {
            SpanWrapper span = SpanWrapper.create(this.config, "transaction_commit", this.attemptSpan);
            return Mono.defer(() -> {
                this.LOGGER.info(this.attemptId, "commit %s", this);
                this.checkExpiryPreCommit(HOOK_BEFORE_COMMIT);
                if (!this.atrCollection.isPresent() || !this.atrId.isPresent() || this.isDone) {
                    return Mono.create(s -> {
                        if (!this.isDone) {
                            this.LOGGER.info(this.attemptId, "calling commit on attempt that's got no mutations, skipping");
                            this.isDone = true;
                            this.state = AttemptStates.COMPLETED;
                            s.success();
                        } else {
                            AttemptException toThrow = new AttemptException(this, "calling commit on attempt that's already complete");
                            toThrow.shouldRollback(false);
                            s.error((Throwable)toThrow);
                        }
                    });
                }
                String prefix = "attempts." + this.attemptId;
                ArrayList<MutateInSpec> specs = new ArrayList<MutateInSpec>();
                specs.add((MutateInSpec)MutateInSpec.upsert((String)(prefix + "." + "st"), (Object)AttemptStates.COMMITTED.name()).xattr());
                specs.add((MutateInSpec)MutateInSpec.upsert((String)(prefix + "." + "tsc"), (Object)MutateInMacro.CAS));
                specs.addAll(this.addDocsToBuilder());
                AtomicReference<Long> overallStartTime = new AtomicReference<Long>(0L);
                Mono<Void> atrCommit = this.atrCommit(specs, overallStartTime, span);
                return atrCommit.then(this.commitDocs(span)).then(this.atrComplete(prefix, overallStartTime, span)).doOnSuccess(ignore -> this.LOGGER.info(this.attemptId, "overall commit completed")).then();
            }).doOnSubscribe(v -> span.start()).doFinally(v -> span.finish());
        });
    }

    private Retry<Object> retryDuringCommitOrRollback(String stage) {
        List<Class> nonRetriableExceptions = Arrays.asList(AttemptExpired.class, AbortedAsRequested.class, AbortedAsRequestedNoRollback.class, AbortedAsRequestedNoRollbackNoCleanup.class, ActiveTransactionRecordFull.class);
        Predicate<RetryContext> predicate = context -> {
            Throwable exception = context.exception();
            if (this.expiryOvertimeMode) {
                if (exception != null) {
                    this.LOGGER.info(this.attemptId, "in expiry-overtime mode, so not retrying error %s in stage %s: %s", exception.getClass().getSimpleName(), stage, exception.getMessage());
                }
                return false;
            }
            if (exception == null) {
                return true;
            }
            for (Class clazz : nonRetriableExceptions) {
                if (!clazz.isInstance(exception)) continue;
                return false;
            }
            return true;
        };
        return DefaultRetry.create(predicate).exponentialBackoff(Duration.of(10L, ChronoUnit.MILLIS), Duration.of(250L, ChronoUnit.MILLIS)).doOnRetry(v -> this.overall.LOGGER.info(this.attemptId, "commit/rollback must complete, retrying on error in stage %s: '%s'", stage, v.exception())).jitter(Jitter.random());
    }

    private Retry<?> retryAmbiguousErrors(String stage) {
        List<Class> retriableExceptions = Arrays.asList(AmbiguousTimeoutException.class, DurabilityAmbiguousException.class, RequestCanceledException.class);
        Predicate<RetryContext> predicate = context -> {
            Throwable exception = context.exception();
            if (this.expiryOvertimeMode) {
                if (exception != null) {
                    this.LOGGER.info(this.attemptId, "in expiry-overtime mode, so not retrying error %s in stage %s: %s", exception.getClass().getSimpleName(), stage, exception.getMessage());
                }
                return false;
            }
            if (exception == null) {
                return true;
            }
            for (Class clazz : retriableExceptions) {
                if (!clazz.isInstance(exception)) continue;
                return true;
            }
            return false;
        };
        return DefaultRetry.create(predicate).exponentialBackoff(Duration.of(10L, ChronoUnit.MILLIS), Duration.of(250L, ChronoUnit.MILLIS)).doOnRetry(v -> this.overall.LOGGER.info(this.attemptId, "retrying ambiguous error %s in stage %s, operation may have succeeded or not, expiry-overtime=%s, retrying: '%s'", v.exception().getClass().getSimpleName(), stage, this.expiryOvertimeMode, v.exception()));
    }

    private void checkExpiryDuringCommitOrRollback(String stage) {
        if (!this.expiryOvertimeMode) {
            if (this.hasExpiredClientSide(stage)) {
                this.LOGGER.info(this.attemptId, "has expired in stage %s, entering expiry-overtime mode (one attempt to complete commit)", stage);
                this.expiryOvertimeMode = true;
            }
        } else {
            this.LOGGER.info(this.attemptId, "ignoring expiry in stage %s, as in expiry-overtime mode", stage);
        }
    }

    private Mono<Void> atrComplete(String prefix, AtomicReference<Long> overallStartTime, SpanWrapper pspan) {
        SpanWrapper span = SpanWrapper.createATROp(this.config, this.atrCollection, this.atrId, HOOK_ATR_COMPLETE, this.attemptSpan);
        return this.beforeAtrComplete(this).doOnSubscribe(s -> {
            this.LOGGER.info(this.attemptId, "about to set ATR %s to Completed", this.getAtrDebug(this.atrCollection, this.atrId));
            this.checkExpiryDuringCommitOrRollback(HOOK_ATR_COMPLETE);
            span.start();
        }).then(this.atrCollection.get().mutateIn(this.atrId.get(), Arrays.asList(MutateInSpec.upsert((String)(prefix + "." + "st"), (Object)AttemptStates.COMPLETED.name()).xattr(), MutateInSpec.upsert((String)(prefix + "." + "tsco"), (Object)MutateInMacro.CAS)), (MutateInOptions)this.wrap(pspan).clientContext(OptionsWrapperUtil.createClientContext("atrComplete")))).flatMap(v -> this.afterAtrComplete(this)).doOnNext(v -> {
            this.state = AttemptStates.COMPLETED;
            long now = System.nanoTime();
            long elapsed = span.finish();
            this.LOGGER.info(this.attemptId, "set ATR %s to Completed in %dms, overall commit completed in %dms", this.getAtrDebug(this.atrCollection, this.atrId), elapsed, (now - (Long)overallStartTime.get()) / 1000000L);
        }).then().onErrorResume(err -> {
            this.LOGGER.info(this.attemptId, "error %s while setting ATR %s to Completed", err, this.getAtrDebug(this.atrCollection, this.atrId));
            if (this.expiryOvertimeMode) {
                return this.mapErrorInOvertimeToExpired(HOOK_ATR_COMPLETE, (Throwable)err);
            }
            if (err instanceof ValueTooLargeException) {
                return Mono.error((Throwable)new ActiveTransactionRecordFull(this, (Throwable)err));
            }
            return Mono.error((Throwable)err);
        }).retryWhen(this.retryDuringCommitOrRollback("atrComplete"));
    }

    private Mono<Void> mapErrorInOvertimeToExpired(String stage, Throwable err) {
        this.LOGGER.info(this.attemptId, "in expiry-overtime mode so changing error %s to AttemptExpired in stage %s", err, stage);
        if (!this.expiryOvertimeMode) {
            this.LOGGER.warn(this.attemptId, "not in expiry-overtime mode handling error %s in stage %s, possibly a bug", err, stage);
        }
        AttemptExpired out = new AttemptExpired(this, true);
        out.shouldRollback(false);
        return Mono.error((Throwable)out);
    }

    private Mono<Void> removeDoc(SpanWrapper pspan, TransactionGetResult doc) {
        return this.beforeDocRemoved(this, doc.id()).doOnSubscribe(s -> {
            this.LOGGER.info(this.attemptId, "about to remove doc %s", RedactableArgument.redactUser((Object)doc.id()));
            this.checkExpiryDuringCommitOrRollback(HOOK_REMOVE_DOC);
        }).then(doc.collection().remove(doc.id(), this.wrap(RemoveOptions.removeOptions(), pspan))).flatMap(mutationResult -> this.afterDocRemovedPreRetry(this, doc.id()).thenReturn(mutationResult)).doOnNext(mutationResult -> {
            this.LOGGER.info(this.attemptId, "commit - removed doc %s, mt = %s", RedactableArgument.redactUser((Object)doc.id()), mutationResult.mutationToken());
            mutationResult.mutationToken().ifPresent(mt -> this.finalMutationTokens.put(doc.id(), (MutationToken)mt));
        }).then().onErrorResume(err -> {
            if (this.expiryOvertimeMode) {
                return this.mapErrorInOvertimeToExpired(HOOK_REMOVE_DOC, (Throwable)err);
            }
            if (err instanceof DocumentNotFoundException) {
                this.LOGGER.info(this.attemptId, "got DocumentNotFoundException while removing doc %s, it must have already been committed, continuing", RedactableArgument.redactUser((Object)doc.id()));
                return Mono.empty();
            }
            return Mono.error((Throwable)err);
        }).retryWhen(this.retryDuringCommitOrRollback("removeDoc")).then(this.afterDocRemovedPostRetry(this, doc.id())).then();
    }

    private Mono<Void> commitDocs(SpanWrapper pspan) {
        SpanWrapper span = SpanWrapper.create(this.config, "transaction_commit_docs", this.attemptSpan);
        return Flux.fromIterable(this.stagedMutations).concatMap(staged -> {
            TransactionGetResult doc = staged.doc;
            return this.commitDocWrapper(pspan, (StagedMutation)staged, doc, false);
        }).doOnSubscribe(x -> span.start()).then(Mono.defer(() -> {
            long elapsed = span.finish();
            this.LOGGER.info(this.attemptId, "commit - all %d docs committed in %dms", this.stagedMutations.size(), elapsed);
            return this.afterDocsCommitted(this);
        })).then();
    }

    private static String msgDocChangedUnexpectedly(String id, String dbg) {
        return "Tried committing document " + RedactableArgument.redactUser((Object)id) + ", but found that it has been modified by another party in-between staging and committing.  The application must ensure that non-transactional writes cannot happen at the same time as transactional writes on a document.  The change will be committed with CAS=0, which will overwrite the other change.  This document may need manual review to verify that no changes have been lost.  Last document state=" + dbg;
    }

    private static String msgDocRemovedUnexpectedly(String id, String dbg) {
        return "Tried committing document " + RedactableArgument.redactUser((Object)id) + ", but found that it has been removed by another party in-between replacing and committing.  The application must ensure that non-transactional writes cannot happen at the same time as transactional writes on a document.  The document will be left removed, and the transaction's changes will not be written to this document.  Last document state=" + dbg;
    }

    private Mono<Void> commitDocWrapper(SpanWrapper pspan, StagedMutation staged, TransactionGetResult doc, boolean casZero) {
        return Mono.defer(() -> {
            if (staged.type == StagedMutationType.REMOVE) {
                return this.removeDoc(pspan, doc);
            }
            return this.commitDoc(pspan, staged, doc, casZero, false);
        });
    }

    private String dbg(MutateInResult result) {
        if (result == null) {
            return "<unavailable>";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("cas=");
        sb.append(result.cas());
        result.mutationToken().ifPresent(mt -> {
            sb.append(",seqno=");
            sb.append(mt.sequenceNumber());
            sb.append(",vbucket=");
            sb.append(mt.partitionID());
        });
        return sb.toString();
    }

    private Mono<Void> commitDoc(SpanWrapper pspan, StagedMutation staged, TransactionGetResult doc, boolean casZero, boolean ambiguityResolutionMode) {
        return this.beforeDocCommitted(this, doc.id()).doOnSubscribe(s -> {
            this.LOGGER.info(this.attemptId, "commit - committing doc %s with cas %d, ambiguity-resolution=%s", RedactableArgument.redactUser((Object)doc.id()), casZero ? 0L : doc.cas(), ambiguityResolutionMode);
            this.checkExpiryDuringCommitOrRollback(HOOK_COMMIT_DOC);
        }).then(doc.collection().mutateIn(doc.id(), Arrays.asList(MutateInSpec.upsert((String)"txn", null).xattr(), MutateInSpec.remove((String)"txn").xattr(), MutateInSpec.replace((String)"", (Object)staged.content)), this.wrap(((MutateInOptions)MutateInOptions.mutateInOptions().clientContext(OptionsWrapperUtil.createClientContext("commitDoc"))).cas(casZero ? 0L : doc.cas()), pspan))).flatMap(v -> this.afterDocCommittedBeforeSavingCAS(this, doc.id()).thenReturn(v)).flatMap(updatedDoc -> {
            this.LOGGER.info(this.attemptId, "commit - committed doc %s got %s", RedactableArgument.redactUser((Object)doc.id()), this.dbg((MutateInResult)updatedDoc));
            doc.cas(updatedDoc.cas());
            updatedDoc.mutationToken().ifPresent(mt -> this.finalMutationTokens.put(doc.id(), (MutationToken)mt));
            return this.afterDocCommitted(this, doc.id());
        }).onErrorResume(err -> {
            boolean isAmbiguous;
            boolean bl = isAmbiguous = err instanceof AmbiguousTimeoutException || err instanceof RequestCanceledException || err instanceof DurabilityAmbiguousException;
            if (this.expiryOvertimeMode) {
                return this.mapErrorInOvertimeToExpired(HOOK_COMMIT_DOC, (Throwable)err).thenReturn((Object)0);
            }
            if (isAmbiguous) {
                this.LOGGER.warn(this.attemptId, "%s while committing doc %s: as op is ambiguously successful, retrying op in ambiguity-resolution mode", err.getClass().getSimpleName(), doc.id());
                return this.commitDoc(pspan, staged, doc, false, true).thenReturn((Object)0);
            }
            if (err instanceof CasMismatchException) {
                if (ambiguityResolutionMode) {
                    this.LOGGER.info(this.attemptId, "%s while committing doc %s: in ambiguity-resolution mode, so regarding previous attempt as successful and continuing", err.getClass().getSimpleName(), doc.id());
                    return Mono.empty();
                }
                String msg = AttemptContextReactive.msgDocChangedUnexpectedly(doc.id(), this.dbg(staged.mr));
                this.LOGGER.warn(this.attemptId, msg);
                this.LOGGER.eventBus().publish((Event)new IllegalDocumentState(Event.Severity.WARN, msg, doc.id()));
                return this.commitDoc(pspan, staged, doc, true, ambiguityResolutionMode).thenReturn((Object)0);
            }
            if (err instanceof DocumentNotFoundException) {
                String msg = AttemptContextReactive.msgDocRemovedUnexpectedly(doc.id(), this.dbg(staged.mr));
                this.LOGGER.warn(this.attemptId, msg);
                this.LOGGER.eventBus().publish((Event)new IllegalDocumentState(Event.Severity.WARN, msg, doc.id()));
                return Mono.empty();
            }
            return Mono.error((Throwable)err);
        }).retryWhen(this.retryDuringCommitOrRollback("commitDoc")).then();
    }

    private Mono<Void> atrCommit(List<MutateInSpec> specs, AtomicReference<Long> overallStartTime, SpanWrapper pspan) {
        SpanWrapper span = SpanWrapper.createATROp(this.config, this.atrCollection, this.atrId, HOOK_ATR_COMMIT, this.attemptSpan);
        return this.beforeAtrCommit(this).doOnSubscribe(x -> {
            span.start();
            this.LOGGER.info(this.attemptId, "about to set ATR %s to Committed, expiryOvertimeMode=%s", this.getAtrDebug(this.atrCollection, this.atrId), this.expiryOvertimeMode);
            overallStartTime.set(System.nanoTime());
            this.checkExpiryDuringCommitOrRollback(HOOK_ATR_COMMIT);
        }).then(this.atrCollection.get().mutateIn(this.atrId.get(), specs, (MutateInOptions)this.wrap(pspan).clientContext(OptionsWrapperUtil.createClientContext("atrCommit")))).flatMap(v -> this.afterAtrCommit(this)).doOnNext(v -> {
            this.LOGGER.info(this.attemptId, "commit - marking as done");
            this.isDone = true;
            this.state = AttemptStates.COMMITTED;
            this.LOGGER.info(this.attemptId, "set ATR %s to Committed in %dms", this.getAtrDebug(this.atrCollection, this.atrId), (System.nanoTime() - (Long)overallStartTime.get()) / 1000000L);
        }).onErrorResume(err -> {
            this.LOGGER.info(this.attemptId, "error %s while setting ATR %s to Committed", err, this.getAtrDebug(this.atrCollection, this.atrId));
            if (this.expiryOvertimeMode) {
                return this.mapErrorInOvertimeToExpired(HOOK_ATR_COMMIT, (Throwable)err).thenReturn((Object)0);
            }
            if (err instanceof ValueTooLargeException) {
                return Mono.error((Throwable)new ActiveTransactionRecordFull(this, (Throwable)err));
            }
            return Mono.error((Throwable)err);
        }).retryWhen(this.retryDuringCommitOrRollback("atrCommit")).then().doFinally(v -> span.finish());
    }

    Mono<Void> abort() {
        SpanWrapper span = SpanWrapper.create(this.config, "transaction_abort", this.attemptSpan);
        return Mono.defer(() -> {
            this.LOGGER.info(this.attemptId, "aborting %s, expiryOvertimeMode=%s", this, this.expiryOvertimeMode);
            if (!this.atrCollection.isPresent() || !this.atrId.isPresent() || this.isDone) {
                return Mono.create(s -> {
                    if (!this.isDone) {
                        this.LOGGER.info(this.attemptId, "Calling abort when it's had no mutations, so nothing to do");
                        this.state = AttemptStates.ROLLED_BACK;
                        this.isDone = true;
                    } else {
                        this.LOGGER.info(this.attemptId, "Ignoring abort it's already reached commit or rollback point");
                    }
                    s.success();
                });
            }
            String prefix = "attempts." + this.attemptId;
            Mono getAtr = this.beforeGetAtrForAbort(this).then(this.atrCollection.get().lookupIn(this.atrId.get(), Arrays.asList(LookupInSpec.get((String)"attempts").xattr()), (LookupInOptions)((LookupInOptions)LookupInOptions.lookupInOptions().clientContext(OptionsWrapperUtil.createClientContext("abort"))).timeout(this.config.keyValueTimeout()))).onErrorResume(err -> {
                if (err instanceof DocumentNotFoundException) {
                    this.LOGGER.info(this.attemptId, "could not find ATR entry %s", this.getAtrDebug(this.atrCollection, this.atrId));
                    return Mono.error((Throwable)new ActiveTransactionRecordNotFound(this.atrId.get(), "Could not find Active Transaction Record for " + this.atrCollection.get().name() + "/" + this.atrId.get() + " during rollback"));
                }
                return Mono.error((Throwable)err);
            }).doOnNext(atr -> {
                JsonObject atrContent = ((JsonObject)atr.contentAs(0, JsonObject.class)).getObject(this.attemptId);
                if (atrContent != null) {
                    ATREntry atrEntry = ActiveTransactionRecord.createFrom(this.atrCollection.get().bucketName(), this.atrId.get(), atrContent, this.attemptId, atr.cas());
                    this.LOGGER.info(this.attemptId, "got ATR %s %s", this.getAtrDebug(this.atrCollection, this.atrId), atrEntry);
                    if (atrEntry.state() != AttemptStates.PENDING) {
                        this.LOGGER.info(this.attemptId, "aborting as status in ATR is %s", new Object[]{atrEntry.state()});
                        throw new AttemptExceptionNoRetry(this);
                    }
                } else {
                    this.LOGGER.info(this.attemptId, "could not find ATR entry in %s", this.getAtrDebug(this.atrCollection, this.atrId));
                }
            }).then();
            return getAtr.onErrorResume(err -> {
                this.checkExpiryDuringCommitOrRollback(HOOK_ABORT_GET_ATR);
                return this.handleErrorDuringAbortOrRollback((Throwable)err, "abortGetAtr (retry as needed)");
            }).retryWhen(this.retryDuringCommitOrRollback(HOOK_ABORT_GET_ATR)).then(this.atrAbort(prefix, span));
        }).doOnSubscribe(v -> span.start()).doFinally(v -> span.finish());
    }

    public Mono<Void> rollback() {
        return this.rollbackInternal();
    }

    Mono<Void> rollbackInternal() {
        SpanWrapper span = SpanWrapper.create(this.config, "transaction_rollback", this.attemptSpan);
        return Mono.defer(() -> {
            this.LOGGER.info(this.attemptId, "rollback %s expiryOvertimeMode=%s", this, this.expiryOvertimeMode);
            if (!this.expiryOvertimeMode && this.hasExpiredClientSide(HOOK_ROLLBACK)) {
                this.LOGGER.info(this.attemptId, "has expired before rollback, entering expiry-overtime mode");
                this.expiryOvertimeMode = true;
            }
            if (!this.atrCollection.isPresent() || !this.atrId.isPresent() || this.isDone) {
                return Mono.create(s -> {
                    if (!this.isDone) {
                        this.LOGGER.info(this.attemptId, "Calling rollback when it's had no mutations, so nothing to do");
                        this.state = AttemptStates.ROLLED_BACK;
                        this.isDone = true;
                        s.success();
                    } else {
                        AttemptException toThrow = new AttemptException(this, "calling rollback on attempt that's already complete");
                        toThrow.shouldRollback(false);
                        s.error((Throwable)toThrow);
                    }
                });
            }
            String prefix = "attempts." + this.attemptId;
            return this.abort().then(this.rollbackDocs(span)).then(this.atrRollbackComplete(prefix, span)).onErrorResume(err -> {
                if (err instanceof ActiveTransactionRecordNotFound) {
                    this.LOGGER.info(this.attemptId, "ActiveTransactionRecordNotFound indicates that nothing needs to be done for this rollback: treating as successful rollback");
                    return Mono.empty();
                }
                return Mono.error((Throwable)err);
            });
        }).doOnSubscribe(v -> span.start()).doFinally(v -> span.finish());
    }

    private Mono<Void> atrRollbackComplete(String prefix, SpanWrapper pspan) {
        SpanWrapper span = SpanWrapper.createATROp(this.config, this.atrCollection, this.atrId, HOOK_ATR_ROLLBACK_COMPLETE, this.attemptSpan);
        return this.beforeAtrRolledBack(this).then(this.atrCollection.get().mutateIn(this.atrId.get(), Arrays.asList(MutateInSpec.upsert((String)(prefix + "." + "st"), (Object)AttemptStates.ROLLED_BACK.name()).xattr(), MutateInSpec.upsert((String)(prefix + "." + "tsrc"), (Object)MutateInMacro.CAS)), (MutateInOptions)this.wrap(pspan).clientContext(OptionsWrapperUtil.createClientContext("atrRollbackComplete")))).doOnSubscribe(s -> {
            span.start();
            this.LOGGER.info(this.attemptId, "marking ATR %s as rollback complete", this.getAtrDebug(this.atrCollection, this.atrId));
            this.checkExpiryDuringCommitOrRollback(HOOK_ATR_ROLLBACK_COMPLETE);
        }).flatMap(v -> this.afterAtrRolledBack(this)).then().onErrorResume(err -> this.handleErrorDuringAbortOrRollback((Throwable)err, HOOK_ATR_ROLLBACK_COMPLETE)).retryWhen(this.retryDuringCommitOrRollback(HOOK_ATR_ROLLBACK_COMPLETE)).then(Mono.fromRunnable(() -> {
            this.state = AttemptStates.ROLLED_BACK;
            this.isDone = true;
            this.LOGGER.info(this.attemptId, "rollback - atr rolled back");
        })).then().doFinally(v -> span.finish());
    }

    private Mono<Void> rollbackDocs(SpanWrapper pspan) {
        SpanWrapper span = SpanWrapper.create(this.config, "transaction_rollback_docs", this.attemptSpan);
        return Flux.fromIterable(this.stagedMutations).concatMap(staged -> {
            TransactionGetResult doc = staged.doc;
            switch (staged.type) {
                case INSERT: {
                    return this.deleteSingleInserted(pspan, doc);
                }
            }
            return this.rollbackDoc(pspan, doc);
        }).doOnNext(v -> this.LOGGER.info(this.attemptId, "rollback - docs rolled back")).then().doOnSubscribe(v -> span.start()).doFinally(v -> span.finish());
    }

    private Mono<Void> rollbackDoc(SpanWrapper pspan, TransactionGetResult doc) {
        return this.beforeDocRolledBack(this, doc.id()).then(doc.collection().mutateIn(doc.id(), Arrays.asList(MutateInSpec.remove((String)"txn").xattr()), this.wrap(((MutateInOptions)MutateInOptions.mutateInOptions().clientContext(OptionsWrapperUtil.createClientContext("rollbackDoc"))).cas(0L), pspan))).doOnSubscribe(s -> {
            this.LOGGER.info(this.attemptId, "rolling back doc %s with cas %d by removing staged mutation", RedactableArgument.redactUser((Object)doc.id()), doc.cas());
            this.checkExpiryDuringCommitOrRollback(HOOK_ROLLBACK_DOC);
        }).flatMap(updatedDoc -> this.afterRollbackReplaceOrRemove(this, doc.id()).thenReturn(updatedDoc)).doOnNext(updatedDoc -> {
            this.LOGGER.info(this.attemptId, "rolled back doc %s, storing new cas %d, mt %s", RedactableArgument.redactUser((Object)doc.id()), updatedDoc.cas(), updatedDoc.mutationToken());
            doc.cas(updatedDoc.cas());
            updatedDoc.mutationToken().ifPresent(mt -> this.finalMutationTokens.put(doc.id(), (MutationToken)mt));
        }).then().onErrorResume(err -> {
            if (this.expiryOvertimeMode) {
                return this.mapErrorInOvertimeToExpired(HOOK_ROLLBACK_DOC, (Throwable)err);
            }
            if (err instanceof PathNotFoundException) {
                this.LOGGER.info(this.attemptId, "got PATH_NOT_FOUND while cleaning up staged doc %s, it must have already been rolled back, continuing", RedactableArgument.redactUser((Object)doc.id()));
                return Mono.empty();
            }
            return Mono.error((Throwable)err);
        }).retryWhen(this.retryDuringCommitOrRollback("rollbackDoc"));
    }

    private Publisher<Void> deleteSingleInserted(SpanWrapper pspan, TransactionGetResult doc) {
        return this.beforeRollbackDeleteInserted(this, doc.id()).then(doc.collection().remove(doc.id(), this.wrap(RemoveOptions.removeOptions(), pspan))).doOnSubscribe(s -> {
            this.LOGGER.info(this.attemptId, "deleting inserted doc %s", RedactableArgument.redactUser((Object)doc.id()));
            this.checkExpiryDuringCommitOrRollback(HOOK_DELETE_INSERTED);
        }).flatMap(updatedDoc -> this.afterRollbackDeleteInserted(this, doc.id()).thenReturn(updatedDoc)).doOnNext(updatedDoc -> {
            this.LOGGER.info(this.attemptId, "deleted inserted doc %s, mt %s", RedactableArgument.redactUser((Object)doc.id()), updatedDoc.mutationToken());
            updatedDoc.mutationToken().ifPresent(mt -> this.finalMutationTokens.put(doc.id(), (MutationToken)mt));
        }).then().onErrorResume(err -> {
            if (this.expiryOvertimeMode) {
                return this.mapErrorInOvertimeToExpired(HOOK_REMOVE_DOC, (Throwable)err);
            }
            if (err instanceof DocumentNotFoundException) {
                this.LOGGER.info(this.attemptId, "got DocumentNotFoundException while removing staged insert doc %s, it must have already been rolled back, continuing", RedactableArgument.redactUser((Object)doc.id()));
                return Mono.empty();
            }
            return Mono.error((Throwable)err);
        }).retryWhen(this.retryDuringCommitOrRollback(HOOK_DELETE_INSERTED));
    }

    private Mono<Void> atrAbort(String prefix, SpanWrapper pspan) {
        SpanWrapper span = SpanWrapper.createATROp(this.config, this.atrCollection, this.atrId, HOOK_ATR_ABORT, this.attemptSpan);
        ArrayList<Object> spec = new ArrayList<Object>();
        spec.add(MutateInSpec.upsert((String)(prefix + "." + "st"), (Object)AttemptStates.ABORTED.name()).xattr());
        spec.add(MutateInSpec.upsert((String)(prefix + "." + "tsrs"), (Object)MutateInMacro.CAS));
        spec.addAll(this.addDocsToBuilder());
        return this.beforeAtrAborted(this).then(this.atrCollection.get().mutateIn(this.atrId.get(), spec, (MutateInOptions)this.wrap(pspan).clientContext(OptionsWrapperUtil.createClientContext("atrAbortRetryUntilExpiry")))).doOnSubscribe(v -> {
            span.start();
            this.LOGGER.info(this.attemptId, "aborting ATR %s", this.getAtrDebug(this.atrCollection, this.atrId));
            this.checkExpiryDuringCommitOrRollback(HOOK_ATR_ABORT);
        }).then().onErrorResume(err -> this.handleErrorDuringAbortOrRollback((Throwable)err, HOOK_ATR_ABORT)).retryWhen(this.retryDuringCommitOrRollback(HOOK_ATR_ABORT)).then(Mono.defer(() -> {
            this.state = AttemptStates.ABORTED;
            this.isDone = true;
            this.LOGGER.info(this.attemptId, "aborted ATR %s", this.getAtrDebug(this.atrCollection, this.atrId));
            return this.afterAtrAborted(this);
        })).then().doFinally(v -> span.finish());
    }

    private Mono<Void> handleErrorDuringAbortOrRollback(Throwable err, String stage) {
        this.LOGGER.info(this.attemptId, "%s: error %s while doing something with ATR %s", stage, err, this.getAtrDebug(this.atrCollection, this.atrId));
        if (this.expiryOvertimeMode) {
            return this.mapErrorInOvertimeToExpired(stage, err);
        }
        if (err instanceof ActiveTransactionRecordNotFound) {
            this.LOGGER.info(this.attemptId, "ActiveTransactionRecordNotFound indicates that nothing needs to be done, continuing");
            return Mono.empty();
        }
        if (err instanceof ValueTooLargeException) {
            return Mono.error((Throwable)new ActiveTransactionRecordFull(this, err));
        }
        if (err instanceof PathNotFoundException) {
            this.LOGGER.info(this.attemptId, "%s: ATR entry for %s does not exist, assuming we're rolling back as it could not be created and continuing", stage, this.getAtrDebug(this.atrCollection, this.atrId));
            return Mono.empty();
        }
        if (err instanceof DocumentNotFoundException) {
            this.LOGGER.info(this.attemptId, "%s: ATR for %s does not exist, assuming we're rolling back as it could not be created and continuing", stage, this.getAtrDebug(this.atrCollection, this.atrId));
            return Mono.empty();
        }
        return Mono.error((Throwable)err);
    }

    boolean isDone() {
        return this.isDone;
    }

    AttemptStates state() {
        return this.state;
    }

    protected Mono<Integer> beforeAtrCommit(AttemptContextReactive self) {
        return Mono.just((Object)0);
    }

    protected Mono<Integer> afterAtrCommit(AttemptContextReactive self) {
        return Mono.just((Object)0);
    }

    protected Mono<Integer> beforeDocCommitted(AttemptContextReactive self, String id) {
        return Mono.just((Object)0);
    }

    protected Mono<Integer> beforeDocRolledBack(AttemptContextReactive self, String id) {
        return Mono.just((Object)0);
    }

    protected Mono<Integer> afterDocCommittedBeforeSavingCAS(AttemptContextReactive self, String id) {
        return Mono.just((Object)0);
    }

    protected Mono<Integer> afterDocCommitted(AttemptContextReactive self, String id) {
        return Mono.just((Object)0);
    }

    protected Mono<Integer> afterDocsCommitted(AttemptContextReactive self) {
        return Mono.just((Object)0);
    }

    protected Mono<Integer> beforeDocRemoved(AttemptContextReactive self, String id) {
        return Mono.just((Object)0);
    }

    protected Mono<Integer> afterDocRemovedPreRetry(AttemptContextReactive self, String id) {
        return Mono.just((Object)0);
    }

    protected Mono<Integer> afterDocRemovedPostRetry(AttemptContextReactive self, String id) {
        return Mono.just((Object)0);
    }

    protected Mono<Integer> afterDocsRemoved(AttemptContextReactive self) {
        return Mono.just((Object)0);
    }

    protected Mono<Integer> beforeAtrPending(AttemptContextReactive self) {
        return Mono.just((Object)0);
    }

    protected Mono<Integer> afterAtrPending(AttemptContextReactive self) {
        return Mono.just((Object)0);
    }

    protected Mono<Integer> afterAtrComplete(AttemptContextReactive self) {
        return Mono.just((Object)0);
    }

    protected Mono<Integer> beforeAtrComplete(AttemptContextReactive self) {
        return Mono.just((Object)0);
    }

    protected Mono<Integer> beforeAtrRolledBack(AttemptContextReactive self) {
        return Mono.just((Object)0);
    }

    protected Mono<Integer> afterGetComplete(AttemptContextReactive self, String id) {
        return Mono.just((Object)0);
    }

    protected Mono<Integer> afterStagedReplaceCompleteBeforeCASSaved(AttemptContextReactive self, String id) {
        return Mono.just((Object)0);
    }

    protected Mono<Integer> beforeRollbackDeleteInserted(AttemptContextReactive self, String id) {
        return Mono.just((Object)0);
    }

    protected Mono<Integer> afterStagedReplaceComplete(AttemptContextReactive self, String id) {
        return Mono.just((Object)0);
    }

    protected Mono<Integer> afterStagedRemoveComplete(AttemptContextReactive self, String id) {
        return Mono.just((Object)0);
    }

    protected Mono<Integer> beforeStagedInsert(AttemptContextReactive self, String id) {
        return Mono.just((Object)0);
    }

    protected Mono<Integer> beforeStagedRemove(AttemptContextReactive self, String id) {
        return Mono.just((Object)0);
    }

    protected Mono<Integer> beforeStagedReplace(AttemptContextReactive self, String id) {
        return Mono.just((Object)0);
    }

    protected Mono<Integer> afterStagedInsertComplete(AttemptContextReactive self, String id) {
        return Mono.just((Object)0);
    }

    protected Mono<Integer> beforeGetAtrForAbort(AttemptContextReactive self) {
        return Mono.just((Object)0);
    }

    protected Mono<Integer> beforeAtrAborted(AttemptContextReactive self) {
        return Mono.just((Object)0);
    }

    protected Mono<Integer> afterAtrAborted(AttemptContextReactive self) {
        return Mono.just((Object)0);
    }

    protected Mono<Integer> afterAtrRolledBack(AttemptContextReactive self) {
        return Mono.just((Object)0);
    }

    protected Mono<Integer> afterRollbackReplaceOrRemove(AttemptContextReactive self, String id) {
        return Mono.just((Object)0);
    }

    protected Mono<Integer> afterRollbackDeleteInserted(AttemptContextReactive self, String id) {
        return Mono.just((Object)0);
    }

    protected Mono<Integer> beforeRemovingDocDuringStagedInsert(AttemptContextReactive self, String id) {
        return Mono.just((Object)0);
    }

    protected Mono<Integer> beforeCheckATREntryForBlockingDoc(AttemptContextReactive self, String id) {
        return Mono.just((Object)0);
    }

    protected Mono<Integer> beforeDocGet(AttemptContextReactive self, String id) {
        return Mono.just((Object)0);
    }

    protected Mono<Integer> beforeGetDocInExistsDuringStagedInsert(AttemptContextReactive self, String id) {
        return Mono.just((Object)0);
    }

    protected Boolean hasExpiredClientSideHook(AttemptContextReactive self, String place) {
        return false;
    }

    public TransactionLogger logger() {
        return this.LOGGER;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AttemptContextReactive{");
        sb.append("id=").append(this.attemptId.substring(0, 5));
        sb.append(",state=").append((Object)this.state);
        sb.append(",isDone=").append(this.isDone);
        sb.append(",atr=").append(this.atrCollection.map(v -> v.name()).orElse("<empty>")).append('/').append(this.atrId.orElse("<empty>"));
        sb.append(",staged=").append(this.stagedMutations.stream().map(StagedMutation::toString).collect(Collectors.toList()));
        sb.append('}');
        return sb.toString();
    }

    static class StagedMutation {
        public final TransactionGetResult doc;
        public final byte[] content;
        public final StagedMutationType type;
        public final MutateInResult mr;

        public StagedMutation(TransactionGetResult doc, byte[] content, StagedMutationType type, MutateInResult mr) {
            this.doc = doc;
            this.content = content;
            this.type = type;
            this.mr = mr;
        }

        public String toString() {
            return this.type.toString() + " " + RedactableArgument.redactUser((Object)this.doc.id());
        }
    }

    static enum StagedMutationType {
        INSERT,
        REMOVE,
        REPLACE;

    }
}

