/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.user;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonCreator;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonProperty;
import com.couchbase.client.core.util.CbStrings;
import com.couchbase.client.java.manager.user.Role;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@Stability.Volatile
public class RoleAndDescription {
    private final Role role;
    private final String displayName;
    private final String description;

    public RoleAndDescription(Role role, String displayName, String description) {
        this.role = Objects.requireNonNull(role);
        this.displayName = CbStrings.nullToEmpty((String)displayName);
        this.description = CbStrings.nullToEmpty((String)description);
    }

    @JsonCreator
    private RoleAndDescription(@JsonProperty(value="role") String name, @JsonProperty(value="bucket_name") String bucket, @JsonProperty(value="name") String displayName, @JsonProperty(value="desc") String description) {
        this(new Role(name, bucket), displayName, description);
    }

    public Role role() {
        return this.role;
    }

    public String displayName() {
        return this.displayName;
    }

    public String description() {
        return this.description;
    }

    public String toString() {
        return this.role.toString() + "(" + this.displayName() + ": " + this.description() + ")";
    }
}

