/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.collection;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.java.AsyncUtils;
import com.couchbase.client.java.manager.collection.AsyncCollectionManager;
import com.couchbase.client.java.manager.collection.CollectionSpec;
import com.couchbase.client.java.manager.collection.CreateCollectionOptions;
import com.couchbase.client.java.manager.collection.CreateScopeOptions;
import com.couchbase.client.java.manager.collection.DropCollectionOptions;
import com.couchbase.client.java.manager.collection.DropScopeOptions;
import com.couchbase.client.java.manager.collection.GetAllScopesOptions;
import com.couchbase.client.java.manager.collection.GetScopeOptions;
import com.couchbase.client.java.manager.collection.ScopeSpec;
import java.util.List;

@Stability.Volatile
public class CollectionManager {
    private final AsyncCollectionManager asyncCollectionManager;

    public CollectionManager(AsyncCollectionManager asyncCollectionManager) {
        this.asyncCollectionManager = asyncCollectionManager;
    }

    public void createCollection(CollectionSpec collectionSpec) {
        this.createCollection(collectionSpec, CreateCollectionOptions.createCollectionOptions());
    }

    public void createCollection(CollectionSpec collectionSpec, CreateCollectionOptions options) {
        AsyncUtils.block(this.asyncCollectionManager.createCollection(collectionSpec, options));
    }

    public void dropCollection(CollectionSpec collectionSpec) {
        this.dropCollection(collectionSpec, DropCollectionOptions.dropCollectionOptions());
    }

    public void dropCollection(CollectionSpec collectionSpec, DropCollectionOptions options) {
        AsyncUtils.block(this.asyncCollectionManager.dropCollection(collectionSpec, options));
    }

    public void createScope(String scopeName) {
        this.createScope(scopeName, CreateScopeOptions.createScopeOptions());
    }

    public void createScope(String scopeName, CreateScopeOptions options) {
        AsyncUtils.block(this.asyncCollectionManager.createScope(scopeName, options));
    }

    public void dropScope(String scopeName) {
        this.dropScope(scopeName, DropScopeOptions.dropScopeOptions());
    }

    public void dropScope(String scopeName, DropScopeOptions options) {
        AsyncUtils.block(this.asyncCollectionManager.dropScope(scopeName, options));
    }

    public ScopeSpec getScope(String scopeName) {
        return this.getScope(scopeName, GetScopeOptions.getScopeOptions());
    }

    public ScopeSpec getScope(String scopeName, GetScopeOptions options) {
        return AsyncUtils.block(this.asyncCollectionManager.getScope(scopeName, options));
    }

    public List<ScopeSpec> getAllScopes() {
        return this.getAllScopes(GetAllScopesOptions.getAllScopesOptions());
    }

    public List<ScopeSpec> getAllScopes(GetAllScopesOptions options) {
        return AsyncUtils.block(this.asyncCollectionManager.getAllScopes(options));
    }
}

