/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.kv;

import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.msg.kv.MutationToken;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class MutationState
implements Iterable<MutationToken> {
    private final List<MutationToken> tokens = new ArrayList<MutationToken>();

    private MutationState() {
    }

    public static MutationState from(MutationToken ... mutationTokens) {
        return new MutationState().add(mutationTokens);
    }

    public MutationState add(MutationToken ... mutationTokens) {
        if (mutationTokens == null || mutationTokens.length == 0) {
            throw InvalidArgumentException.fromMessage((String)"At least one MutationToken must be provided.");
        }
        for (MutationToken t : mutationTokens) {
            this.addToken(t);
        }
        return this;
    }

    public MutationState add(MutationState mutationState) {
        for (MutationToken token : mutationState) {
            this.addToken(token);
        }
        return this;
    }

    private void addToken(MutationToken token) {
        if (token != null) {
            ListIterator<MutationToken> tokenIterator = this.tokens.listIterator();
            while (tokenIterator.hasNext()) {
                MutationToken t = tokenIterator.next();
                if (t.partitionID() != token.partitionID() || !t.bucketName().equals(token.bucketName())) continue;
                if (token.sequenceNumber() > t.sequenceNumber()) {
                    tokenIterator.set(token);
                }
                return;
            }
            this.tokens.add(token);
        }
    }

    @Override
    public Iterator<MutationToken> iterator() {
        return this.tokens.iterator();
    }

    public JsonObject export() {
        JsonObject result = JsonObject.create();
        for (MutationToken token : this.tokens) {
            JsonObject bucket = result.getObject(token.bucketName());
            if (bucket == null) {
                bucket = JsonObject.create();
                result.put(token.bucketName(), bucket);
            }
            bucket.put(String.valueOf(token.partitionID()), JsonArray.from(token.sequenceNumber(), String.valueOf(token.partitionUUID())));
        }
        return result;
    }

    public JsonObject exportForSearch() {
        JsonObject result = JsonObject.create();
        for (MutationToken token : this.tokens) {
            String tokenKey = token.partitionID() + "/" + token.partitionUUID();
            Long seqno = result.getLong(tokenKey);
            if (seqno != null && seqno >= token.sequenceNumber()) continue;
            result.put(tokenKey, token.sequenceNumber());
        }
        return result;
    }

    public static MutationState from(String source) {
        return MutationState.from(JsonObject.fromJson(source));
    }

    public static MutationState from(JsonObject source) {
        try {
            MutationState state = new MutationState();
            for (String bucketName : source.getNames()) {
                JsonObject bucket = source.getObject(bucketName);
                for (String vbid : bucket.getNames()) {
                    JsonArray values = bucket.getArray(vbid);
                    state.addToken(new MutationToken(Short.parseShort(vbid), Long.parseLong(values.getString(1)), values.getLong(0).longValue(), bucketName));
                }
            }
            return state;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not import MutationState from JSON.", ex);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutationState state = (MutationState)o;
        return this.tokens.containsAll(state.tokens) && state.tokens.containsAll(this.tokens);
    }

    public int hashCode() {
        return this.tokens.hashCode();
    }

    public String toString() {
        return "MutationState{tokens=" + this.tokens + '}';
    }
}

