/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.diagnostics;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.util.Validators;
import java.time.Duration;
import java.util.Optional;
import java.util.Set;

public class PingOptions {
    private Optional<String> reportId = Optional.empty();
    private Set<ServiceType> serviceTypes;
    private Optional<Duration> timeout = Optional.empty();
    private Optional<RetryStrategy> retryStrategy = Optional.empty();

    public static PingOptions pingOptions() {
        return new PingOptions();
    }

    private PingOptions() {
    }

    public PingOptions reportId(String reportId) {
        this.reportId = Optional.of(reportId);
        return this;
    }

    public PingOptions serviceTypes(Set<ServiceType> serviceTypes) {
        Validators.notNullOrEmpty(serviceTypes, (String)"Service Types");
        this.serviceTypes = serviceTypes;
        return this;
    }

    public PingOptions timeout(Duration timeout) {
        this.timeout = Optional.ofNullable(timeout);
        return this;
    }

    public PingOptions retryStrategy(RetryStrategy retryStrategy) {
        this.retryStrategy = Optional.ofNullable(retryStrategy);
        return this;
    }

    @Stability.Internal
    public Built build() {
        return new Built();
    }

    @Stability.Internal
    public class Built {
        Built() {
        }

        public Optional<String> reportId() {
            return PingOptions.this.reportId;
        }

        public Optional<Duration> timeout() {
            return PingOptions.this.timeout;
        }

        public Set<ServiceType> serviceTypes() {
            return PingOptions.this.serviceTypes;
        }

        public Optional<RetryStrategy> retryStrategy() {
            return PingOptions.this.retryStrategy;
        }
    }
}

