/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.java.AsyncScope;
import com.couchbase.client.java.ReactiveCollection;
import com.couchbase.client.java.env.ClusterEnvironment;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ReactiveScope {
    private final AsyncScope asyncScope;
    private final Map<String, ReactiveCollection> collectionCache = new ConcurrentHashMap<String, ReactiveCollection>();

    ReactiveScope(AsyncScope asyncScope) {
        this.asyncScope = asyncScope;
    }

    public String name() {
        return this.asyncScope.name();
    }

    public String bucketName() {
        return this.asyncScope.bucketName();
    }

    public AsyncScope async() {
        return this.asyncScope;
    }

    @Stability.Volatile
    public Core core() {
        return this.asyncScope.core();
    }

    public ClusterEnvironment environment() {
        return this.asyncScope.environment();
    }

    ReactiveCollection defaultCollection() {
        return this.collectionCache.computeIfAbsent("_default", n -> new ReactiveCollection(this.asyncScope.defaultCollection()));
    }

    @Stability.Volatile
    public ReactiveCollection collection(String collectionName) {
        return this.collectionCache.computeIfAbsent(collectionName, n -> new ReactiveCollection(this.asyncScope.collection((String)n)));
    }
}

