/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.content.aws;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.TreeMap;
import org.flasck.jvm.ziniki.ContentObject;
import org.ziniki.content.aws.AWSContentStorage;
import org.ziniki.paas.interfaces.PAASContext;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.ObjectMarshalling;
import org.ziniki.ziwsh.intf.Wireable;
import org.zinutils.exceptions.InvalidUsageException;

public class S3ContentObject
implements ContentObject,
Wireable {
    private final AWSContentStorage cs;
    private final String s3key;

    public S3ContentObject(AWSContentStorage cs, String s3key) {
        try {
            if (s3key == null) {
                throw new InvalidUsageException("key must not be NULL");
            }
        }
        catch (Exception ex) {
            AWSContentStorage.logger.info("key is null", (Throwable)ex);
        }
        this.cs = cs;
        this.s3key = s3key;
    }

    public String key() {
        return this.s3key;
    }

    public String url() {
        return this.cs.publicUrl(this.s3key);
    }

    public String writeUrl() {
        return this.cs.publicWriteTo(this.s3key);
    }

    public String asString() {
        return this.cs.downloadFromPublicAsString(this.s3key);
    }

    public byte[] asByteArray() {
        return this.cs.downloadFromPublicAsBytes(this.s3key);
    }

    public InputStream asStream() {
        return this.cs.downloadFromPublicAsStream(this.s3key);
    }

    public Map<String, Object> fields() throws IOException {
        TreeMap<String, Object> ret = new TreeMap<String, Object>();
        ret.put("_wireable", "contentObject");
        ret.put("key", this.s3key);
        ret.put("publicGet", this.cs.publicUrl(this.s3key));
        ret.put("publicPut", this.cs.publicWriteTo(this.s3key));
        return ret;
    }

    public static S3ContentObject fromWire(EvalContext cx, ObjectMarshalling om, Map<String, Object> args) {
        AWSContentStorage cs = (AWSContentStorage)((PAASContext)cx).getContentStore();
        AWSContentStorage.logger.info("S3CO from wire " + args);
        return new S3ContentObject(cs, (String)args.get("key"));
    }

    public String toString() {
        return "S3CO[" + this.s3key + "]";
    }
}

