/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.content.aws;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.ziniki.ContentObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.content.aws.DoUpload;
import org.ziniki.content.aws.S3ContentObject;
import org.ziniki.paas.interfaces.ContentStorage;
import org.ziniki.paas.interfaces.UploadContent;
import org.ziniki.paas.range.SequenceNo;
import org.ziniki.tdastore.ZiidRangeProvider;
import org.ziniki.ziwsh.intf.Param;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;
import software.amazon.awssdk.services.s3.presigner.model.GetObjectPresignRequest;
import software.amazon.awssdk.services.s3.presigner.model.PutObjectPresignRequest;

public class AWSContentStorage
implements ContentStorage {
    public static final Logger logger = LoggerFactory.getLogger((String)"awscontentstore");
    private final S3Client s3;
    private final S3Presigner pre;
    private final String publicBucket;
    private final SequenceNo sequenceNo;

    public AWSContentStorage(@Param(value="publicBucket") String publicBucketName, @Param(value="ziidRangeProvider") ZiidRangeProvider ziidProvider) {
        DefaultCredentialsProvider provider;
        this.publicBucket = publicBucketName;
        this.sequenceNo = new SequenceNo(ziidProvider);
        String profile = System.getProperty("aws.profile");
        logger.info("creating content store for bucket " + publicBucketName + " with profile " + profile);
        if (profile != null) {
            Path p = new File(System.getProperty("user.home") + "/.aws/credentials").toPath();
            provider = ProfileCredentialsProvider.builder().profileFile(ProfileFile.builder().content(p).type(ProfileFile.Type.CREDENTIALS).build()).profileName(profile).build();
        } else {
            provider = DefaultCredentialsProvider.create();
        }
        this.s3 = (S3Client)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().credentialsProvider((AwsCredentialsProvider)provider)).region(Region.US_EAST_1)).build();
        this.pre = S3Presigner.builder().credentialsProvider((AwsCredentialsProvider)provider).region(Region.US_EAST_1).build();
    }

    public List<ContentObject> prefixed(String prefix) {
        ListObjectsV2Request req = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.publicBucket).prefix(prefix).build();
        ListObjectsV2Response list = this.s3.listObjectsV2(req);
        ArrayList<ContentObject> ret = new ArrayList<ContentObject>();
        for (S3Object o : list.contents()) {
            ret.add(new S3ContentObject(this, o.key()));
        }
        return ret;
    }

    public ContentObject get(String key) {
        return new S3ContentObject(this, key);
    }

    public ContentObject newObject(FLEvalContext cx, String name, String contentType) {
        String next = this.sequenceNo.next("content", "store");
        return new S3ContentObject(this, "created/" + next + "/" + name);
    }

    public ContentObject objectPath(FLEvalContext cx, String path, String contentType) {
        return new S3ContentObject(this, path);
    }

    public ContentObject upload(String key, File f, String ct) {
        PutObjectRequest request = (PutObjectRequest)PutObjectRequest.builder().bucket(this.publicBucket).key(key).contentType(ct).build();
        this.s3.putObject(request, f.toPath());
        return new S3ContentObject(this, key);
    }

    public ContentObject upload(String key, InputStream is, String ct, long length, boolean closeInput) throws IOException {
        PutObjectRequest request = (PutObjectRequest)PutObjectRequest.builder().bucket(this.publicBucket).key(key).contentType(ct).build();
        RequestBody body = RequestBody.fromInputStream((InputStream)is, (long)length);
        this.s3.putObject(request, body);
        if (closeInput) {
            is.close();
        }
        return new S3ContentObject(this, key);
    }

    ContentObject upload(String key, byte[] byteArray, String ct) {
        PutObjectRequest request = (PutObjectRequest)PutObjectRequest.builder().bucket(this.publicBucket).key(key).contentType(ct).build();
        RequestBody body = RequestBody.fromBytes((byte[])byteArray);
        this.s3.putObject(request, body);
        return new S3ContentObject(this, key);
    }

    public UploadContent upload(String key, String contentType) throws IOException {
        return new DoUpload(this, key, contentType);
    }

    String publicUrl(String s3key) {
        GetObjectRequest r = (GetObjectRequest)GetObjectRequest.builder().bucket(this.publicBucket).key(s3key).build();
        GetObjectPresignRequest pr = GetObjectPresignRequest.builder().signatureDuration(Duration.ofMinutes(60L)).getObjectRequest(r).build();
        return this.pre.presignGetObject(pr).url().toString();
    }

    String publicWriteTo(String s3key) {
        PutObjectRequest r = (PutObjectRequest)PutObjectRequest.builder().bucket(this.publicBucket).key(s3key).build();
        PutObjectPresignRequest pr = PutObjectPresignRequest.builder().signatureDuration(Duration.ofMinutes(60L)).putObjectRequest(r).build();
        return this.pre.presignPutObject(pr).url().toString();
    }

    public String downloadFromPublicAsString(String s3key) {
        try {
            GetObjectRequest gor = (GetObjectRequest)GetObjectRequest.builder().bucket(this.publicBucket).key(s3key).build();
            byte[] reader = ((ResponseBytes)this.s3.getObject(gor, ResponseTransformer.toBytes())).asByteArray();
            return new String(reader, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            logger.error("No UTF-8", (Throwable)ex);
            return "";
        }
    }

    public byte[] downloadFromPublicAsBytes(String s3key) {
        GetObjectRequest gor = (GetObjectRequest)GetObjectRequest.builder().bucket(this.publicBucket).key(s3key).build();
        return ((ResponseBytes)this.s3.getObject(gor, ResponseTransformer.toBytes())).asByteArray();
    }

    public InputStream downloadFromPublicAsStream(String s3key) {
        GetObjectRequest gor = (GetObjectRequest)GetObjectRequest.builder().bucket(this.publicBucket).key(s3key).build();
        return ((ResponseBytes)this.s3.getObject(gor, ResponseTransformer.toBytes())).asInputStream();
    }
}

