/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.log;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.transactions.cleanup.ATRStats;
import com.couchbase.transactions.cleanup.TransactionsCleanup;
import com.couchbase.transactions.components.ATREntry;
import com.couchbase.transactions.log.TransactionCleanupStartRunEvent;
import com.couchbase.transactions.log.TransactionEvent;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;

@Stability.Volatile
public class TransactionCleanupEndRunEvent
extends TransactionEvent {
    private final TransactionCleanupStartRunEvent start;
    private final Duration timeOfLastRun;
    private int numAtrsChecked;
    private int numEntries;
    private long numAtrsPresent;
    private long numAtrsMissing;
    private long numAtrsErrored;
    private final Map<String, ATRStats> atrStats;
    private Optional<ATREntry> oldest = Optional.empty();
    private int numEntriesExpired;
    private int numEntriesAttemptsFailed;
    private int largestNumEntries;

    @Stability.Volatile
    public TransactionCleanupEndRunEvent(TransactionCleanupStartRunEvent start, Map<String, ATRStats> atrStats, Duration timeOfLastRun) {
        super(Event.Severity.INFO, TransactionsCleanup.CATEGORY_STATS);
        this.start = start;
        this.atrStats = atrStats;
        Collection<ATRStats> atrs = atrStats.values();
        this.numAtrsChecked = atrs.size();
        atrs.forEach(stats -> {
            if (stats.errored.isPresent()) {
                ++this.numAtrsErrored;
            }
            this.numEntries += stats.numEntries;
            if (stats.numEntries > this.largestNumEntries) {
                this.largestNumEntries = stats.numEntries;
            }
            if (stats.exists) {
                ++this.numAtrsPresent;
            } else {
                ++this.numAtrsMissing;
            }
            this.numEntriesExpired += stats.expired.size();
            this.numEntriesAttemptsFailed += stats.expiredEntryCleanupFailedAttempts.get();
            if (stats.oldest().isPresent() && (!this.oldest.isPresent() || stats.oldest().get().ageMsecs() > this.oldest.get().ageMsecs())) {
                this.oldest = stats.oldest();
            }
        });
        this.timeOfLastRun = timeOfLastRun;
    }

    @Stability.Volatile
    public TransactionCleanupStartRunEvent start() {
        return this.start;
    }

    @Stability.Volatile
    public Duration timeOfLastRun() {
        return this.timeOfLastRun;
    }

    public int numAtrsChecked() {
        return this.numAtrsChecked;
    }

    public int numEntries() {
        return this.numEntries;
    }

    public long numAtrsPresent() {
        return this.numAtrsPresent;
    }

    public long numAtrsMissing() {
        return this.numAtrsMissing;
    }

    public long numAtrsErrored() {
        return this.numAtrsErrored;
    }

    public Map<String, ATRStats> atrStats() {
        return this.atrStats;
    }

    public Optional<ATREntry> oldest() {
        return this.oldest;
    }

    public int numEntriesExpired() {
        return this.numEntriesExpired;
    }

    public int largestNumEntries() {
        return this.largestNumEntries;
    }

    public String description() {
        StringBuilder sb = new StringBuilder(300);
        sb.append("start={");
        sb.append(this.start.description());
        sb.append("},end={taken=");
        sb.append(this.timeOfLastRun.toMillis());
        sb.append("millis,ATRs={read=");
        sb.append(this.numAtrsChecked);
        sb.append(",errored=");
        sb.append(this.numAtrsErrored);
        sb.append(",present=");
        sb.append(this.numAtrsPresent);
        sb.append("},entries={expired=");
        sb.append(this.numEntriesExpired);
        sb.append(",failed=");
        sb.append(this.numEntriesAttemptsFailed);
        sb.append(",total=");
        sb.append(this.numEntries);
        sb.append("},maxEntries=");
        sb.append(this.largestNumEntries);
        if (this.oldest.isPresent()) {
            sb.append(",oldest=");
            ATREntry o = this.oldest.get();
            sb.append(o.ageMsecs());
            sb.append("millis,id=");
            sb.append(o.atrId());
            sb.append("/");
            sb.append(o.attemptId().substring(0, 5));
            sb.append('}');
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean success() {
        return true;
    }
}

