/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.log;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.transactions.cleanup.TransactionsCleanup;
import com.couchbase.transactions.components.ATREntry;
import com.couchbase.transactions.log.LogDefer;
import com.couchbase.transactions.log.TransactionEvent;
import java.util.List;

@Stability.Volatile
public class TransactionCleanupAttempt
extends TransactionEvent {
    private final boolean success;
    private final boolean isRegular;
    private final List<LogDefer> logs;
    private final String attemptId;
    private final String atrId;
    private final String atrBucket;
    private final ATREntry atrEntry;

    public TransactionCleanupAttempt(Event.Severity severity, boolean success, boolean isRegular, List<LogDefer> logs, String attemptId, String atrId, String atrBucket, ATREntry atrEntry) {
        super(severity, TransactionsCleanup.CATEGORY);
        this.success = success;
        this.isRegular = isRegular;
        this.logs = logs;
        this.attemptId = attemptId;
        this.atrId = atrId;
        this.atrBucket = atrBucket;
        this.atrEntry = atrEntry;
    }

    @Override
    public List<LogDefer> logs() {
        return this.logs;
    }

    @Override
    public boolean success() {
        return this.success;
    }

    public String attemptId() {
        return this.attemptId;
    }

    public String atrId() {
        return this.atrId;
    }

    public String atrBucket() {
        return this.atrBucket;
    }

    public String description() {
        StringBuilder sb = new StringBuilder();
        sb.append("Transaction cleanup attempt");
        sb.append(", isRegular=");
        sb.append(this.isRegular);
        sb.append(", success=");
        sb.append(this.success);
        sb.append(", ATR entry=");
        sb.append(this.atrEntry);
        return sb.toString();
    }
}

