/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.log;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.cnc.EventBus;
import com.couchbase.transactions.log.TransactionLogEvent;

@Stability.Internal
public class SimpleEventBusLogger {
    private final EventBus eventBus;
    private final String category;

    public SimpleEventBusLogger(EventBus eventBus) {
        this(eventBus, TransactionLogEvent.DEFAULT_CATEGORY);
    }

    public SimpleEventBusLogger(EventBus eventBus, String category) {
        this.eventBus = eventBus;
        this.category = category;
    }

    public void verbose(String s) {
        this.eventBus.publish((Event)new TransactionLogEvent(Event.Severity.VERBOSE, this.category, s));
    }

    public void debug(String s) {
        this.eventBus.publish((Event)new TransactionLogEvent(Event.Severity.DEBUG, this.category, s));
    }

    public void info(String s) {
        this.eventBus.publish((Event)new TransactionLogEvent(Event.Severity.INFO, this.category, s));
    }

    public void warn(String s) {
        this.eventBus.publish((Event)new TransactionLogEvent(Event.Severity.WARN, this.category, s));
    }

    public void error(String s) {
        this.eventBus.publish((Event)new TransactionLogEvent(Event.Severity.ERROR, this.category, s));
    }
}

