/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.log;

import com.couchbase.client.core.cnc.Event;
import com.couchbase.transactions.support.QuickFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;

public class LogDefer {
    static final SimpleDateFormat SDF = new SimpleDateFormat("HH:mm:ss.SSS");
    private final long timestamp;
    private final long threadId;
    private final String threadName;
    private final String transactionId;
    private final String secondaryId;
    private final String fmt;
    private final Object[] values;
    private final Event.Severity level;
    private final QuickFormat format;
    public static final int CHARS_TO_LOG = 5;

    public LogDefer(long timestamp, long threadId, String threadName, String transactionId, String secondaryId, String fmt, Object[] values, Event.Severity level, QuickFormat format) {
        Objects.requireNonNull(threadName);
        Objects.requireNonNull(transactionId);
        Objects.requireNonNull(fmt);
        Objects.requireNonNull(level);
        Objects.requireNonNull(format);
        this.timestamp = timestamp;
        this.threadId = threadId;
        this.threadName = threadName;
        this.transactionId = transactionId;
        this.secondaryId = secondaryId;
        this.fmt = fmt;
        this.values = values;
        this.level = level;
        this.format = format;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SDF.format(new Date(this.timestamp)));
        sb.append(' ');
        sb.append(Thread.currentThread().getId());
        sb.append('/');
        sb.append(Thread.currentThread().getName());
        sb.append('/');
        if (this.transactionId.length() > 5) {
            sb.append(this.transactionId.substring(0, 5));
        } else {
            sb.append(this.transactionId);
        }
        if (this.secondaryId != null) {
            sb.append('/');
            if (this.secondaryId.length() > 5) {
                sb.append(this.secondaryId.substring(0, 5));
            } else {
                sb.append(this.secondaryId);
            }
        }
        sb.append(' ');
        if (this.values != null) {
            String value = String.format(this.fmt, this.values);
            sb.append(value);
        } else {
            sb.append(this.fmt);
        }
        return sb.toString();
    }

    public Event.Severity level() {
        return this.level;
    }
}

