/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.components;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.java.json.JsonObject;
import java.util.Objects;
import java.util.Optional;

@Stability.Internal
public class TransactionLinks {
    private final Optional<String> atrId;
    private final Optional<String> atrBucketName;
    private final Optional<String> atrScopeName;
    private final Optional<String> atrCollectionName;
    private final Optional<String> stagedTransactionId;
    private final Optional<String> stagedAttemptId;
    private final Optional<String> stagedContent;
    private final Optional<String> casPreTxn;
    private final Optional<String> revidPreTxn;
    private final Optional<Long> exptimePreTxn;
    private final Optional<String> op;

    public TransactionLinks(Optional<String> stagedContent, Optional<String> atrId, Optional<String> atrBucketName, Optional<String> atrScopeName, Optional<String> atrCollectionName, Optional<String> stagedTransactionId, Optional<String> stagedAttemptId, Optional<String> casPreTxn, Optional<String> revidPreTxn, Optional<Long> exptimePreTxn, Optional<String> op) {
        Objects.requireNonNull(stagedContent);
        Objects.requireNonNull(atrId);
        Objects.requireNonNull(stagedTransactionId);
        Objects.requireNonNull(stagedAttemptId);
        Objects.requireNonNull(atrBucketName);
        Objects.requireNonNull(atrScopeName);
        Objects.requireNonNull(atrCollectionName);
        Objects.requireNonNull(op);
        this.stagedContent = stagedContent;
        this.atrId = atrId;
        this.stagedTransactionId = stagedTransactionId;
        this.stagedAttemptId = stagedAttemptId;
        this.atrBucketName = atrBucketName;
        this.atrScopeName = atrScopeName;
        this.atrCollectionName = atrCollectionName;
        this.casPreTxn = casPreTxn;
        this.revidPreTxn = revidPreTxn;
        this.exptimePreTxn = exptimePreTxn;
        this.op = op;
    }

    public boolean isDocumentInTransaction() {
        return this.atrId.isPresent();
    }

    public boolean isDocumentBeingRemoved() {
        return this.stagedContent.isPresent() && this.stagedContent.get().equals("<<REMOVE>>");
    }

    public boolean hasStagedWrite() {
        return this.stagedAttemptId.isPresent();
    }

    public Optional<String> atrId() {
        return this.atrId;
    }

    public Optional<String> stagedTransactionId() {
        return this.stagedTransactionId;
    }

    public Optional<String> stagedAttemptId() {
        return this.stagedAttemptId;
    }

    @Stability.Internal
    public Optional<String> stagedContent() {
        return this.stagedContent;
    }

    public Optional<String> atrBucketName() {
        return this.atrBucketName;
    }

    public Optional<String> atrScopeName() {
        return this.atrScopeName;
    }

    public Optional<String> atrCollectionName() {
        return this.atrCollectionName;
    }

    public Optional<String> casPreTxn() {
        return this.casPreTxn;
    }

    public Optional<String> revidPreTxn() {
        return this.revidPreTxn;
    }

    public Optional<Long> exptimePreTxn() {
        return this.exptimePreTxn;
    }

    public Optional<String> op() {
        return this.op;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TransactionLinks{");
        sb.append("atr=").append(this.atrId.orElse("none"));
        sb.append(",atrBkt=").append(this.atrBucketName.orElse("none"));
        sb.append(",atrColl=").append(this.atrCollectionName.orElse("none"));
        sb.append(",txnId=").append(this.stagedTransactionId.orElse("none"));
        sb.append(",attemptId=").append(this.stagedAttemptId.orElse("none"));
        if (this.stagedContent.isPresent()) {
            if (this.stagedContent.get().length() <= 20) {
                sb.append(",content=").append(this.stagedContent.get());
            } else {
                sb.append(",content=").append(this.stagedContent.get().length()).append("chars");
            }
        }
        sb.append(",op=").append(this.op.orElse("none"));
        sb.append(",restore={");
        sb.append(this.casPreTxn.orElse("none"));
        sb.append(',');
        sb.append(this.revidPreTxn.orElse("none"));
        sb.append(',');
        sb.append(this.exptimePreTxn.orElse(-1L));
        sb.append("}}");
        return sb.toString();
    }

    public JsonObject stagedContentAsJson() {
        if (!this.stagedContent.isPresent()) {
            throw new IllegalStateException();
        }
        return JsonObject.fromJson((String)this.stagedContent.get());
    }
}

