/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.components;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.java.ReactiveCollection;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.kv.LookupInOptions;
import com.couchbase.client.java.kv.LookupInResult;
import com.couchbase.client.java.kv.LookupInSpec;
import com.couchbase.client.java.kv.MutateInOptions;
import com.couchbase.client.java.kv.MutateInSpec;
import com.couchbase.transactions.TransactionAttempt;
import com.couchbase.transactions.components.ATR;
import com.couchbase.transactions.components.ATREntry;
import com.couchbase.transactions.components.DocRecord;
import com.couchbase.transactions.config.TransactionConfig;
import com.couchbase.transactions.support.AttemptStates;
import com.couchbase.transactions.support.OptionsWrapperUtil;
import com.couchbase.transactions.support.SpanWrapper;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

@Stability.Internal
public class ActiveTransactionRecord {
    public static final String REMOVE = "<<REMOVE>>";

    private ActiveTransactionRecord() {
    }

    public static Optional<ATREntry> findEntryForTransaction(TransactionAttempt attempt, Duration timeout, TransactionConfig config, SpanWrapper span) {
        if (!attempt.atrCollection().isPresent() || !attempt.atrId().isPresent()) {
            throw new IllegalStateException();
        }
        return (Optional)ActiveTransactionRecord.findEntryForTransaction(attempt.atrCollection().get(), attempt.atrId().get(), attempt.attemptId(), timeout, config, span).block();
    }

    public static Mono<Optional<ATREntry>> findEntryForTransaction(ReactiveCollection atrCollection, String atrId, String attemptId, Duration timeout, TransactionConfig config, SpanWrapper span) {
        return atrCollection.lookupIn(atrId, Arrays.asList(LookupInSpec.get((String)"attempts").xattr()), (LookupInOptions)((LookupInOptions)LookupInOptions.lookupInOptions().clientContext(OptionsWrapperUtil.createClientContext("ATR::findEntryForTransaction"))).timeout(config.keyValueTimeout())).map(d -> ActiveTransactionRecord.findEntryForTransaction(atrCollection, atrId, (JsonObject)d.contentAs(0, JsonObject.class), attemptId, d.cas()));
    }

    public static Optional<ATREntry> findEntryForTransaction(ReactiveCollection atrCollection, String atrId, JsonObject doc, String attemptId, long cas) {
        JsonObject entry = doc.getObject(attemptId);
        if (entry == null) {
            return Optional.empty();
        }
        return Optional.of(ActiveTransactionRecord.createFrom(atrCollection.bucketName(), atrId, entry, attemptId, cas));
    }

    public static ATREntry createFrom(String atrBucket, String atrId, JsonObject entry, String attemptId, long cas) {
        Objects.requireNonNull(entry);
        Objects.requireNonNull(attemptId);
        AttemptStates state = AttemptStates.valueOf(entry.getString("st"));
        return new ATREntry(atrBucket, atrId, attemptId, state, ActiveTransactionRecord.parseMutationCASField(entry.getString("tst")), ActiveTransactionRecord.parseMutationCASField(entry.getString("tsc")), ActiveTransactionRecord.parseMutationCASField(entry.getString("tsco")), ActiveTransactionRecord.parseMutationCASField(entry.getString("tsrs")), ActiveTransactionRecord.parseMutationCASField(entry.getString("tsrc")), Optional.ofNullable(entry.getInt("exp")), ActiveTransactionRecord.processDocumentIdArray(entry.getArray("ins")), ActiveTransactionRecord.processDocumentIdArray(entry.getArray("rep")), ActiveTransactionRecord.processDocumentIdArray(entry.getArray("rem")), cas);
    }

    public static Optional<List<DocRecord>> processDocumentIdArray(JsonArray array) {
        if (array == null) {
            return Optional.empty();
        }
        return Optional.of(array.toList().stream().map(v -> DocRecord.createFrom((HashMap)v)).collect(Collectors.toList()));
    }

    public static long parseMutationCAS(String in) {
        int offsetIndex = 2;
        long result = 0L;
        for (int octetIndex = 7; octetIndex >= 0; --octetIndex) {
            char char1 = in.charAt(offsetIndex + octetIndex * 2);
            char char2 = in.charAt(offsetIndex + octetIndex * 2 + 1);
            long octet1 = 0L;
            long octet2 = 0L;
            if (char1 >= 'a' && char1 <= 'f') {
                octet1 = char1 - 97 + 10;
            } else if (char1 >= 'A' && char1 <= 'F') {
                octet1 = char1 - 65 + 10;
            } else if (char1 >= '0' && char1 <= '9') {
                octet1 = char1 - 48;
            } else {
                throw new IllegalStateException("Could not parse CAS " + in);
            }
            if (char2 >= 'a' && char2 <= 'f') {
                octet2 = char2 - 97 + 10;
            } else if (char2 >= 'A' && char2 <= 'F') {
                octet2 = char2 - 65 + 10;
            } else if (char2 >= '0' && char2 <= '9') {
                octet2 = char2 - 48;
            } else {
                throw new IllegalStateException("Could not parse CAS " + in);
            }
            result |= octet1 << octetIndex * 8 + 4;
            result |= octet2 << octetIndex * 8;
        }
        return result / 1000000L;
    }

    public static Optional<Long> parseMutationCASField(String str) {
        if (str == null) {
            return Optional.empty();
        }
        return Optional.of(ActiveTransactionRecord.parseMutationCAS(str));
    }

    public static Mono<Optional<ATR>> getAndTouchAtr(ReactiveCollection atrCollection, String atrId, Duration timeout, SpanWrapper pspan, TransactionConfig config) {
        return atrCollection.mutateIn(atrId, Arrays.asList(MutateInSpec.upsert((String)"dummy", null).xattr()), (MutateInOptions)((MutateInOptions)MutateInOptions.mutateInOptions().clientContext(OptionsWrapperUtil.createClientContext("ATR::getAndTouchAtr"))).timeout(timeout)).flatMap(doc -> atrCollection.lookupIn(atrId, Arrays.asList(LookupInSpec.get((String)"attempts").xattr()), (LookupInOptions)((LookupInOptions)LookupInOptions.lookupInOptions().clientContext(OptionsWrapperUtil.createClientContext("ATR::getAndTouchAtr"))).timeout(timeout))).map(d -> {
            JsonObject attempts = (JsonObject)d.contentAs(0, JsonObject.class);
            return Optional.of(ActiveTransactionRecord.mapToAtr(atrCollection, atrId, d, attempts));
        }).onErrorResume(err -> {
            if (err instanceof DocumentNotFoundException) {
                return Mono.just(Optional.empty());
            }
            return Mono.error((Throwable)err);
        });
    }

    public static ATR mapToAtr(ReactiveCollection atrCollection, String atrId, LookupInResult doc, JsonObject attempts) {
        List<ATREntry> entries = attempts.toMap().entrySet().stream().map(entry -> {
            HashMap val = (HashMap)entry.getValue();
            ATREntry e = new ATREntry(atrCollection.bucketName(), atrId, (String)entry.getKey(), AttemptStates.valueOf((String)val.get("st")), ActiveTransactionRecord.parseMutationCASField((String)val.get("tst")), ActiveTransactionRecord.parseMutationCASField((String)val.get("tsc")), ActiveTransactionRecord.parseMutationCASField((String)val.get("tsco")), ActiveTransactionRecord.parseMutationCASField((String)val.get("tsrs")), ActiveTransactionRecord.parseMutationCASField((String)val.get("tsrc")), Optional.ofNullable((Integer)val.get("exp")), ActiveTransactionRecord.processDocumentIdArray(val.get("ins")), ActiveTransactionRecord.processDocumentIdArray(val.get("rep")), ActiveTransactionRecord.processDocumentIdArray(val.get("rem")), doc.cas());
            return e;
        }).collect(Collectors.toList());
        ATR atr = new ATR(atrId, atrCollection, doc.cas(), entries);
        return atr;
    }

    public static Mono<Optional<ATR>> getAtr(ReactiveCollection collection, String atrId, Duration timeout, TransactionConfig config, SpanWrapper pspan) {
        return collection.lookupIn(atrId, Arrays.asList(LookupInSpec.get((String)"attempts").xattr()), (LookupInOptions)((LookupInOptions)LookupInOptions.lookupInOptions().clientContext(OptionsWrapperUtil.createClientContext("ATR::getAtr"))).timeout(timeout)).map(d -> {
            JsonObject attempts = (JsonObject)d.contentAs(0, JsonObject.class);
            return Optional.of(ActiveTransactionRecord.mapToAtr(collection, atrId, d, attempts));
        }).onErrorResume(err -> {
            if (err instanceof DocumentNotFoundException) {
                return Mono.just(Optional.empty());
            }
            return Mono.error((Throwable)err);
        });
    }

    private static Optional<List<DocRecord>> processDocumentIdArray(Object o) {
        if (o == null) {
            return Optional.empty();
        }
        ArrayList vals = (ArrayList)o;
        Optional<List<DocRecord>> out = Optional.of(vals.stream().map(v -> DocRecord.createFrom(v)).collect(Collectors.toList()));
        return out;
    }
}

