/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.components;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.transactions.components.DocRecord;
import com.couchbase.transactions.support.AttemptStates;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Stability.Internal
public class ATREntry {
    private final String atrBucket;
    private final String atrId;
    private final String attemptId;
    private final AttemptStates state;
    private final Optional<Long> timestampStartMsecs;
    private final Optional<Long> timestampCommitMsecs;
    private final Optional<Long> timestampCompleteMsecs;
    private final Optional<Long> timestampRollBackMsecs;
    private final Optional<Long> timestampRolledBackMsecs;
    private final Optional<Integer> expiresAfterMsecs;
    private final long cas;
    private final Optional<List<DocRecord>> insertedIds;
    private final Optional<List<DocRecord>> replacedIds;
    private final Optional<List<DocRecord>> removedIds;

    public ATREntry(String atrBucket, String atrId, String attemptId, AttemptStates state, Optional<Long> timestampStartMsecs, Optional<Long> timestampCommitMsecs, Optional<Long> timestampCompleteMsecs, Optional<Long> timestampRollBackMsecs, Optional<Long> timestampRolledBackMsecs, Optional<Integer> expiresAfterMsecs, Optional<List<DocRecord>> insertedIds, Optional<List<DocRecord>> replacedIds, Optional<List<DocRecord>> removedIds, long cas) {
        Objects.requireNonNull(atrBucket);
        Objects.requireNonNull(atrId);
        Objects.requireNonNull(attemptId);
        Objects.requireNonNull(state);
        Objects.requireNonNull(timestampStartMsecs);
        Objects.requireNonNull(timestampCommitMsecs);
        Objects.requireNonNull(timestampCompleteMsecs);
        Objects.requireNonNull(timestampRollBackMsecs);
        Objects.requireNonNull(timestampRolledBackMsecs);
        Objects.requireNonNull(insertedIds);
        Objects.requireNonNull(replacedIds);
        Objects.requireNonNull(removedIds);
        Objects.requireNonNull(expiresAfterMsecs);
        this.atrId = atrId;
        this.atrBucket = atrBucket;
        this.attemptId = attemptId;
        this.state = state;
        this.timestampStartMsecs = timestampStartMsecs;
        this.timestampCommitMsecs = timestampCommitMsecs;
        this.timestampCompleteMsecs = timestampCompleteMsecs;
        this.timestampRollBackMsecs = timestampRollBackMsecs;
        this.timestampRolledBackMsecs = timestampRolledBackMsecs;
        this.expiresAfterMsecs = expiresAfterMsecs;
        this.cas = cas;
        this.insertedIds = insertedIds;
        this.replacedIds = replacedIds;
        this.removedIds = removedIds;
    }

    public boolean hasExpired() {
        return this.hasExpired(0L, Duration.ofMinutes(0L));
    }

    public boolean hasExpired(long safetyMarginMillis, Duration defaultExpirationTime) {
        long casInMsecs = this.cas / 1000000L;
        int expiresAfterMsecs = this.expiresAfterMsecs().orElse((int)defaultExpirationTime.toMillis());
        return this.hasExpired(casInMsecs, (long)expiresAfterMsecs + safetyMarginMillis);
    }

    public boolean hasExpired(long cas, long txnExpiresAfterMsecs) {
        if (this.timestampStartMsecs.isPresent()) {
            return cas - this.timestampStartMsecs.get() > txnExpiresAfterMsecs;
        }
        return false;
    }

    public long ageMsecs() {
        return this.cas / 1000000L - this.timestampStartMsecs().orElse(0L);
    }

    public String atrId() {
        return this.atrId;
    }

    public String attemptId() {
        return this.attemptId;
    }

    public AttemptStates state() {
        return this.state;
    }

    public Optional<Long> timestampStartMsecs() {
        return this.timestampStartMsecs;
    }

    public Optional<Long> timestampCommitMsecs() {
        return this.timestampCommitMsecs;
    }

    public Optional<Long> timestampCompleteMsecs() {
        return this.timestampCompleteMsecs;
    }

    public Optional<Long> timestampRollBackMsecs() {
        return this.timestampRollBackMsecs;
    }

    public Optional<Long> timestampRolledBackMsecs() {
        return this.timestampRolledBackMsecs;
    }

    public long cas() {
        return this.cas;
    }

    public Optional<List<DocRecord>> insertedIds() {
        return this.insertedIds;
    }

    public Optional<List<DocRecord>> replacedIds() {
        return this.replacedIds;
    }

    public Optional<List<DocRecord>> removedIds() {
        return this.removedIds;
    }

    public Optional<Integer> expiresAfterMsecs() {
        return this.expiresAfterMsecs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ATREntry{");
        sb.append("atr=").append(this.atrBucket).append('/').append(this.atrId);
        sb.append(",attemptId=").append(this.attemptId);
        sb.append(",state=").append((Object)this.state);
        sb.append(",expires=").append(this.expiresAfterMsecs).append("ms");
        sb.append(",[age=").append(this.ageMsecs()).append("ms");
        long casInMsecs = this.cas / 1000000L;
        sb.append(",cas=").append(this.cas);
        sb.append("ns/");
        sb.append(casInMsecs);
        sb.append("ms]<-Only Accurate If ATR Updated,inserted=").append(this.insertedIds);
        sb.append(",replaced=").append(this.replacedIds);
        sb.append(",removed=").append(this.removedIds);
        sb.append(",start=").append(this.timestampStartMsecs).append("ms");
        sb.append('}');
        return sb.toString();
    }
}

