/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.cleanup;

import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.ReactiveBucket;
import com.couchbase.client.java.ReactiveCollection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public class ClusterData {
    private Cluster cluster;
    private Map<String, ReactiveBucket> cachedBuckets = new ConcurrentHashMap<String, ReactiveBucket>();

    public ClusterData(Cluster cluster) {
        this.cluster = cluster;
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public List<BucketConfig> buckets() {
        return this.cluster.core().clusterConfig().bucketConfigs().entrySet().stream().map(v -> (BucketConfig)v.getValue()).collect(Collectors.toList());
    }

    public List<String> bucketNames() {
        return this.buckets().stream().map(v -> v.name()).collect(Collectors.toList());
    }

    public ReactiveBucket getBucketFromName(String name) {
        if (this.cachedBuckets.containsKey(name)) {
            return this.cachedBuckets.get(name);
        }
        ReactiveBucket bucket = this.cluster.reactive().bucket(name);
        this.cachedBuckets.put(name, bucket);
        return bucket;
    }

    public Mono<ReactiveCollection> getBucketDefaultCollection(String name) {
        return Mono.just((Object)this.getBucketFromName(name).defaultCollection());
    }
}

