/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.cleanup;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.CasMismatchException;
import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.core.error.subdoc.PathNotFoundException;
import com.couchbase.client.core.retry.reactor.Retry;
import com.couchbase.client.java.ReactiveCollection;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.kv.LookupInOptions;
import com.couchbase.client.java.kv.LookupInResult;
import com.couchbase.client.java.kv.LookupInSpec;
import com.couchbase.client.java.kv.MutateInMacro;
import com.couchbase.client.java.kv.MutateInOptions;
import com.couchbase.client.java.kv.MutateInSpec;
import com.couchbase.client.java.kv.StoreSemantics;
import com.couchbase.client.java.kv.Upsert;
import com.couchbase.transactions.cleanup.ClientRecordDetails;
import com.couchbase.transactions.cleanup.ClusterData;
import com.couchbase.transactions.cleanup.TransactionsCleanup;
import com.couchbase.transactions.components.ActiveTransactionRecord;
import com.couchbase.transactions.config.TransactionConfig;
import com.couchbase.transactions.log.SimpleEventBusLogger;
import com.couchbase.transactions.support.OptionsWrapperUtil;
import com.couchbase.transactions.support.SpanWrapper;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Stability.Internal
public class ClientRecord {
    public static String CLIENT_RECORD_DOC_ID = "_txn:client-record";
    private final ClusterData clusterData;
    private final SimpleEventBusLogger LOGGER;
    private final TransactionConfig config;
    private static final String FIELD_HEARTBEAT = "heartbeat_ms";
    private static final String FIELD_EXPIRES = "expires_ms";
    private static final String FIELD_NUM_ATRS = "num_atrs";
    public static final String FIELD_RECORDS = "records";
    public static final String FIELD_CLIENTS = "clients";
    public static final String FIELD_OVERRIDE = "override";
    public static final String FIELD_OVERRIDE_ENABLED = "enabled";
    public static final String FIELD_OVERRIDE_EXPIRES = "expires";
    private static int SAFETY_MARGIN_EXPIRY_MSECS = 2000;

    public ClientRecord(ClusterData clusterData, TransactionConfig config) {
        this.LOGGER = new SimpleEventBusLogger(clusterData.cluster().environment().eventBus(), TransactionsCleanup.CATEGORY_CLIENT_RECORD);
        this.clusterData = clusterData;
        this.config = config;
    }

    public Flux<Void> removeClientFromAllBuckets(String clientUuid) {
        return Flux.fromIterable(this.clusterData.bucketNames()).subscribeOn(Schedulers.elastic()).flatMap(bucketName -> this.clusterData.getBucketDefaultCollection((String)bucketName).flatMap(collection -> this.beforeRemoveClient(this).then(collection.mutateIn(CLIENT_RECORD_DOC_ID, Arrays.asList(MutateInSpec.remove((String)("records.clients." + clientUuid)).xattr()), (MutateInOptions)MutateInOptions.mutateInOptions().clientContext(OptionsWrapperUtil.createClientContext("ClientRecord::removeClientFromAllBuckets"))))).onErrorResume(err -> {
            if (err instanceof DocumentNotFoundException) {
                this.LOGGER.debug(String.format("%s/%s remove skipped as client record does not exist", bucketName, clientUuid));
                return Mono.empty();
            }
            if (err instanceof PathNotFoundException) {
                this.LOGGER.debug(String.format("%s/%s remove skipped as client record entry does not exist", bucketName, clientUuid));
                return Mono.empty();
            }
            return Mono.error((Throwable)err);
        }).retryWhen((Function)Retry.any().exponentialBackoff(Duration.of(10L, ChronoUnit.MILLIS), Duration.of(250L, ChronoUnit.MILLIS)).doOnRetry(v -> this.LOGGER.info(String.format("%s/%s retrying removing client from record on error '%s'", bucketName, clientUuid, v.exception()))).retryMax(8L)).doOnNext(v -> this.LOGGER.info(String.format("%s/%s removed from client record", bucketName, clientUuid))).then());
    }

    private Mono<Void> updateClientRecordCAS(String clientUuid, ReactiveCollection collection, SpanWrapper pspan, TransactionConfig config) {
        return this.beforeUpdateCAS(this).then(collection.mutateIn(CLIENT_RECORD_DOC_ID, Arrays.asList(MutateInSpec.upsert((String)"dummy", null).xattr()), (MutateInOptions)MutateInOptions.mutateInOptions().clientContext(OptionsWrapperUtil.createClientContext("ClientRecord::updateClientRecordCAS"))).then().onErrorResume(err -> {
            if (err instanceof DocumentNotFoundException) {
                return this.createClientRecord(clientUuid, config, collection, pspan).then();
            }
            return Mono.error((Throwable)err);
        })).retryWhen((Function)Retry.any().exponentialBackoff(Duration.of(100L, ChronoUnit.MILLIS), Duration.of(1000L, ChronoUnit.MILLIS)).doOnRetry(v -> this.LOGGER.info(String.format("%s retrying updating client record on error '%s'", clientUuid, v.exception()))).retryMax(8L));
    }

    public static ClientRecordDetails parseClientRecord(LookupInResult clientRecord, String clientUuid) {
        JsonObject records = (JsonObject)clientRecord.contentAs(0, JsonObject.class);
        JsonObject clients = records.getObject(FIELD_CLIENTS);
        ArrayList<String> expiredClientIds = new ArrayList<String>();
        ArrayList<String> activeClientIds = new ArrayList<String>();
        clients.getNames().forEach(otherClientId -> {
            boolean out;
            int expiresMsecs;
            long heartbeatMsecs;
            JsonObject cl = (JsonObject)clients.get(otherClientId);
            long casMillis = clientRecord.cas() / 1000000L;
            long expiredPeriod = casMillis - (heartbeatMsecs = ActiveTransactionRecord.parseMutationCAS(cl.getString(FIELD_HEARTBEAT)));
            boolean hasExpired = expiredPeriod >= (long)(expiresMsecs = cl.getInt(FIELD_EXPIRES).intValue());
            boolean bl = out = hasExpired && !otherClientId.equals(clientUuid);
            if (out) {
                expiredClientIds.add((String)otherClientId);
            } else {
                activeClientIds.add((String)otherClientId);
            }
        });
        if (!activeClientIds.contains(clientUuid)) {
            activeClientIds.add(clientUuid);
        }
        List sortedActiveClientIds = activeClientIds.stream().sorted().collect(Collectors.toList());
        int indexOfThisClient = sortedActiveClientIds.indexOf(clientUuid);
        int numExpiredClients = expiredClientIds.size();
        int numActiveClients = sortedActiveClientIds.size();
        int numExistingClients = numExpiredClients + numActiveClients;
        boolean alreadyContainsClient = clients.containsKey(clientUuid);
        boolean overrideEnabled = false;
        long overrideExpiresCas = 0L;
        JsonObject override = records.getObject(FIELD_OVERRIDE);
        if (override != null) {
            overrideEnabled = override.getBoolean(FIELD_OVERRIDE_ENABLED);
            overrideExpiresCas = override.getLong(FIELD_OVERRIDE_EXPIRES);
        }
        return new ClientRecordDetails(numActiveClients, indexOfThisClient, !alreadyContainsClient, expiredClientIds, numExistingClients, numExpiredClients, overrideEnabled, overrideExpiresCas, clientRecord.cas());
    }

    public Mono<ClientRecordDetails> getClientRecord(String bucketName) {
        return this.clusterData.getBucketDefaultCollection(bucketName).flatMap(coll -> coll.lookupIn(CLIENT_RECORD_DOC_ID, Arrays.asList(LookupInSpec.get((String)FIELD_RECORDS).xattr()), (LookupInOptions)LookupInOptions.lookupInOptions().clientContext(OptionsWrapperUtil.createClientContext("ClientRecord::getClientRecord")))).map(cr -> ClientRecord.parseClientRecord(cr, "not_client"));
    }

    public Mono<ClientRecordDetails> processClient(String clientUuid, ReactiveCollection collection, TransactionConfig config) {
        SpanWrapper pspan = SpanWrapper.create(config, "transaction_client_record_process").withTag("client_uuid", clientUuid).withTag("bucket_name", collection.bucketName()).withTag("collection_name", collection.name()).start();
        String bp = collection.bucketName() + "/" + collection.name() + "/" + clientUuid;
        return this.updateClientRecordCAS(clientUuid, collection, pspan, config).then(this.beforeGetRecord(this)).then(collection.lookupIn(CLIENT_RECORD_DOC_ID, Arrays.asList(LookupInSpec.get((String)FIELD_RECORDS).xattr()), (LookupInOptions)LookupInOptions.lookupInOptions().clientContext(OptionsWrapperUtil.createClientContext("ClientRecord::processClient")))).flatMap(clientRecord -> {
            ClientRecordDetails cr = ClientRecord.parseClientRecord(clientRecord, clientUuid);
            this.LOGGER.debug(String.format("%s found %d existing clients including this (%s active, %d expired), included this=%s, index of this=%d, override={enabled=%s,expires=%d,now=%d,active=%s}", bp, cr.numExistingClients(), cr.numActiveClients(), cr.numExpiredClients(), !cr.clientIsNew(), cr.indexOfThisClient(), cr.overrideEnabled(), cr.overrideExpires(), cr.casNow(), cr.overrideActive()));
            if (cr.overrideActive()) {
                return Mono.just((Object)cr);
            }
            ArrayList<Upsert> specs = new ArrayList<Upsert>();
            String field = "records.clients." + clientUuid + ".";
            specs.add(MutateInSpec.upsert((String)(field + FIELD_HEARTBEAT), (Object)MutateInMacro.CAS).createPath());
            specs.add(MutateInSpec.upsert((String)(field + FIELD_EXPIRES), (Object)(config.cleanupWindow().toMillis() + (long)SAFETY_MARGIN_EXPIRY_MSECS)).xattr().createPath());
            specs.add(MutateInSpec.upsert((String)(field + FIELD_NUM_ATRS), (Object)config.numAtrs()).xattr());
            cr.expiredClientIds().stream().limit(14L).forEach(expiredClientId -> {
                this.LOGGER.debug(String.format("%s removing expired client %s", bp, expiredClientId));
                specs.add((Upsert)MutateInSpec.remove((String)("records.clients." + expiredClientId)).xattr());
            });
            return this.beforeUpdateRecord(this).then(collection.mutateIn(CLIENT_RECORD_DOC_ID, specs, (MutateInOptions)MutateInOptions.mutateInOptions().clientContext(OptionsWrapperUtil.createClientContext("ClientRecord::processClient"))).thenReturn((Object)cr));
        }).onErrorResume(err -> {
            this.LOGGER.info(String.format("%s got error %s processing client record", bp, err));
            if (err instanceof DocumentNotFoundException) {
                return this.createClientRecord(clientUuid, config, collection, pspan);
            }
            return Mono.error((Throwable)err);
        });
    }

    private Mono<ClientRecordDetails> createClientRecord(String clientUuid, TransactionConfig config, ReactiveCollection collection, SpanWrapper pspan) {
        String bp = collection.bucketName() + "/" + collection.name() + "/" + clientUuid;
        return this.beforeCreateRecord(this).then(collection.mutateIn(CLIENT_RECORD_DOC_ID, Arrays.asList(MutateInSpec.insert((String)"records.clients", (Object)JsonObject.create()).xattr()), OptionsWrapperUtil.wrap(((MutateInOptions)MutateInOptions.mutateInOptions().clientContext(OptionsWrapperUtil.createClientContext("ClientRecord::createClientRecord"))).storeSemantics(StoreSemantics.INSERT), pspan, config))).doOnSubscribe(v -> this.LOGGER.debug(String.format("%s found client record does not exist, creating and retrying", bp))).onErrorResume(e -> {
            if (e instanceof CasMismatchException) {
                this.LOGGER.debug(String.format("%s found client record exists after retry, another client must have created it, continuing", bp));
                return Mono.empty();
            }
            return Mono.error((Throwable)e);
        }).then(this.processClient(clientUuid, collection, config));
    }

    protected Mono<Integer> beforeCreateRecord(ClientRecord self) {
        return Mono.just((Object)1);
    }

    protected Mono<Integer> beforeRemoveClient(ClientRecord self) {
        return Mono.just((Object)1);
    }

    protected Mono<Integer> beforeUpdateCAS(ClientRecord self) {
        return Mono.just((Object)1);
    }

    protected Mono<Integer> beforeGetRecord(ClientRecord self) {
        return Mono.just((Object)1);
    }

    protected Mono<Integer> beforeUpdateRecord(ClientRecord self) {
        return Mono.just((Object)1);
    }
}

