/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.io.netty.util.CharsetUtil;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.kv.CodecFlags;
import com.couchbase.client.java.ReactiveCollection;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.kv.LookupInResult;
import com.couchbase.client.java.kv.MutateInResult;
import com.couchbase.transactions.TransactionJsonDocumentStatus;
import com.couchbase.transactions.cleanup.ClusterData;
import com.couchbase.transactions.components.DocumentMetadata;
import com.couchbase.transactions.components.TransactionLinks;
import java.util.Objects;
import java.util.Optional;

public class TransactionGetResult {
    private final TransactionLinks links;
    private final Optional<DocumentMetadata> documentMetadata;
    private TransactionJsonDocumentStatus status;
    private byte[] content;
    private long cas;
    private final String id;
    private final ReactiveCollection collection;
    private final Transcoder transcoder;

    private TransactionGetResult(String id, byte[] content, long cas, ReactiveCollection collection, TransactionLinks links, TransactionJsonDocumentStatus status, Optional<DocumentMetadata> documentMetadata, Transcoder transcoder) {
        Objects.requireNonNull(id);
        Objects.requireNonNull(content);
        Objects.requireNonNull(collection);
        Objects.requireNonNull(status);
        Objects.requireNonNull(documentMetadata);
        this.id = id;
        this.content = content;
        this.cas = cas;
        this.collection = collection;
        this.links = links;
        this.status = status;
        this.documentMetadata = documentMetadata;
        this.transcoder = transcoder;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TransactionGetResult{");
        sb.append("id=").append(RedactableArgument.redactUser((Object)this.id));
        sb.append(",cas=").append(this.cas);
        sb.append(",status=").append((Object)this.status);
        sb.append(",bucket=").append(this.collection.bucketName());
        sb.append(",coll=").append(this.collection.name());
        sb.append(",links=").append(this.links);
        sb.append('}');
        return sb.toString();
    }

    @Stability.Internal
    public Optional<DocumentMetadata> documentMetadata() {
        return this.documentMetadata;
    }

    @Stability.Internal
    public TransactionLinks links() {
        return this.links;
    }

    public String id() {
        return this.id;
    }

    public long cas() {
        return this.cas;
    }

    public JsonObject contentAsObject() {
        return this.contentAs(JsonObject.class);
    }

    public <T> T contentAs(Class<T> target) {
        return (T)this.transcoder.decode(target, this.content, CodecFlags.JSON_COMPAT_FLAGS);
    }

    TransactionGetResult cas(long cas) {
        this.cas = cas;
        return this;
    }

    public TransactionJsonDocumentStatus status() {
        return this.status;
    }

    @Stability.Internal
    void serialize(JsonObject out) {
        out.put("cas", this.cas);
        out.put("id", this.id);
        out.put("collection", this.collection.name());
        out.put("bucket", this.collection.bucketName());
        out.put("scope", this.collection.scopeName());
    }

    @Stability.Internal
    static TransactionGetResult createFrom(JsonObject obj, ClusterData cd) {
        TransactionGetResult out = new TransactionGetResult(obj.getString("id"), new byte[0], obj.getLong("cas"), (ReactiveCollection)cd.getBucketDefaultCollection(obj.getString("bucket")).block(), null, TransactionJsonDocumentStatus.NORMAL, Optional.empty(), cd.cluster().environment().transcoder());
        return out;
    }

    @Stability.Internal
    public TransactionGetResult status(TransactionJsonDocumentStatus status) {
        this.status = status;
        return this;
    }

    @Stability.Internal
    static TransactionGetResult createFromInsert(ReactiveCollection collection, String id, byte[] content, String transactionId, String attemptId, String atrId, String atrBucketName, String atrScopeName, String atrCollectionName, MutateInResult updatedDoc, Transcoder transcoder) {
        TransactionLinks links = new TransactionLinks(Optional.of(new String(content, CharsetUtil.UTF_8)), Optional.of(atrId), Optional.of(atrBucketName), Optional.of(atrScopeName), Optional.of(atrCollectionName), Optional.of(transactionId), Optional.of(attemptId), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of("insert"));
        TransactionGetResult out = new TransactionGetResult(id, content, updatedDoc.cas(), collection, links, TransactionJsonDocumentStatus.NORMAL, Optional.empty(), transcoder);
        return out;
    }

    @Stability.Internal
    public static TransactionGetResult createFrom(TransactionGetResult doc, byte[] content, TransactionJsonDocumentStatus status) {
        TransactionLinks links = new TransactionLinks(doc.links.stagedContent(), doc.links.atrId(), doc.links.atrBucketName(), doc.links.atrScopeName(), doc.links.atrCollectionName(), doc.links.stagedTransactionId(), doc.links.stagedAttemptId(), doc.links.casPreTxn(), doc.links.revidPreTxn(), doc.links.exptimePreTxn(), doc.links.op());
        TransactionGetResult out = new TransactionGetResult(doc.id, content, doc.cas, doc.collection, links, status, doc.documentMetadata, doc.transcoder);
        return out;
    }

    @Stability.Internal
    public static TransactionGetResult createFrom(ReactiveCollection collection, String id, LookupInResult doc, TransactionJsonDocumentStatus status, Transcoder transcoder) {
        JsonObject restore;
        Optional<String> atrId = Optional.empty();
        Optional<String> transactionId = Optional.empty();
        Optional<String> attemptId = Optional.empty();
        Optional<String> stagedContent = Optional.empty();
        Optional<String> atrBucketName = Optional.empty();
        Optional<String> atrScopeName = Optional.empty();
        Optional<String> atrCollectionName = Optional.empty();
        Optional<String> casPreTxn = Optional.empty();
        Optional<String> revidPreTxn = Optional.empty();
        Optional<Long> exptimePreTxn = Optional.empty();
        Optional<String> casFromDocument = Optional.empty();
        Optional<String> revidFromDocument = Optional.empty();
        Optional<Long> exptimeFromDocument = Optional.empty();
        Optional<String> op = Optional.empty();
        if (doc.exists(0)) {
            atrId = Optional.of(doc.contentAs(0, String.class));
        }
        if (doc.exists(1)) {
            transactionId = Optional.of(doc.contentAs(1, String.class));
        }
        if (doc.exists(2)) {
            attemptId = Optional.of(doc.contentAs(2, String.class));
        }
        if (doc.exists(3)) {
            byte[] raw = (byte[])doc.contentAs(3, byte[].class);
            String str = new String(raw, CharsetUtil.UTF_8);
            stagedContent = str.length() > 0 && str.charAt(0) == '\"' && str.equals("\"<<REMOVE>>\"") ? Optional.of("<<REMOVE>>") : Optional.of(str);
        }
        if (doc.exists(4)) {
            atrBucketName = Optional.of(doc.contentAs(4, String.class));
        }
        if (doc.exists(5)) {
            String name = (String)doc.contentAs(5, String.class);
            String[] splits = name.split("\\.");
            atrScopeName = Optional.of(splits[0]);
            atrCollectionName = Optional.of(splits[1]);
        }
        if (doc.exists(6)) {
            restore = (JsonObject)doc.contentAs(6, JsonObject.class);
            casPreTxn = Optional.of(restore.getString("CAS"));
            revidPreTxn = Optional.of(restore.getString("revid"));
            exptimePreTxn = Optional.of(restore.getLong("exptime"));
        }
        if (doc.exists(7)) {
            op = Optional.of(doc.contentAs(7, String.class));
        }
        if (doc.exists(8)) {
            restore = (JsonObject)doc.contentAs(8, JsonObject.class);
            casFromDocument = Optional.ofNullable(restore.getString("CAS"));
            revidFromDocument = Optional.ofNullable(restore.getString("revid"));
            exptimeFromDocument = Optional.ofNullable(restore.getLong("exptime"));
        }
        byte[] content = (byte[])doc.contentAs(9, byte[].class);
        TransactionLinks links = new TransactionLinks(stagedContent, atrId, atrBucketName, atrScopeName, atrCollectionName, transactionId, attemptId, casPreTxn, revidPreTxn, exptimePreTxn, op);
        DocumentMetadata md = new DocumentMetadata(casFromDocument, revidFromDocument, exptimeFromDocument);
        TransactionGetResult out = new TransactionGetResult(id, content, doc.cas(), collection, links, status, Optional.of(md), transcoder);
        return out;
    }

    public ReactiveCollection collection() {
        return this.collection;
    }
}

