/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.flasckAssembler;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.flasck.jvm.assembly.FlasckAssembler;
import org.flasck.jvm.assembly.VisitingPackageInfo;
import org.flasck.jvm.assembly.WaitAMo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.common.UOWHost;
import org.ziniki.flasckAssembler.sources.AssemblerSourceProvider;
import org.ziniki.server.tda.ProvideHostInfo;
import org.ziniki.servlet.tda.NotReadyException;
import org.ziniki.servlet.tda.ParameterSource;
import org.ziniki.servlet.tda.RequestPathParameters;
import org.ziniki.servlet.tda.RequestProcessor;
import org.ziniki.servlet.tda.Responder;
import org.ziniki.servlet.tda.ResponseReadyContinuation;
import org.ziniki.tdastore.TxManager;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.ziwsh.intf.Param;
import org.zinutils.exceptions.NotImplementedException;
import org.zinutils.exceptions.WrappedException;

public class ZinikiAssembler
extends FlasckAssembler
implements RequestProcessor,
ProvideHostInfo,
RequestPathParameters,
ResponseReadyContinuation,
VisitingPackageInfo {
    private static final Logger logger = LoggerFactory.getLogger((String)"main");
    private final TxManager txmanager;
    private final AssemblerSourceProvider provider;
    private final String zinikiUri;
    private final String ziwshUri;
    private String host;
    private String app;
    private Responder responder;

    public ZinikiAssembler(@Param(value="txmanager") TxManager txmanager, @Param(value="provider") AssemblerSourceProvider provider, @Param(value="zinikiUri") String zinikiUri, @Param(value="ziwshUri") String ziwshUri) {
        super(false);
        this.txmanager = txmanager;
        this.provider = provider;
        this.zinikiUri = zinikiUri;
        this.ziwshUri = ziwshUri;
    }

    public void provideHost(String name, int port) {
        this.host = name;
    }

    public void hasSegment(String segment) {
        throw new NotImplementedException();
    }

    public void stringValue(String name, String value, ParameterSource source) {
        if ("app".equals(name)) {
            this.app = value;
        }
    }

    public void integerValue(String name, int value, ParameterSource source) {
        throw new NotImplementedException();
    }

    public void doubleValue(String name, double value, ParameterSource source) {
        throw new NotImplementedException();
    }

    public void process(Responder r) throws Exception {
        logger.info("Requested assembly " + this.app);
        UnitOfWork uow = this.txmanager.newUnit();
        uow.trait(UOWHost.class, (Object)new UOWHost(this.host.replace("ziniki.", "")));
        this.responder = r;
        r.setTimeout(5, TimeUnit.SECONDS);
        this.provider.source(uow, this.app, source -> {
            logger.info("app returned source of " + source);
            if (source == null) {
                logger.info("app not found, sending 404");
                r.setStatus(404);
                r.done();
                return;
            }
            try {
                this.assemble(source);
            }
            catch (Exception ex) {
                logger.error("error rendering", (Throwable)ex);
            }
        });
        uow.block();
    }

    public void done() {
        this.responder.done();
    }

    public boolean responseReady() {
        return this.traverser.activate().continueOrDone();
    }

    protected WaitAMo writeHTML(String html) {
        if (html == null) {
            return WaitAMo.CONTINUE;
        }
        try {
            return this.responder.write(html, (ResponseReadyContinuation)this) ? WaitAMo.CONTINUE : WaitAMo.WAIT;
        }
        catch (IOException | NotReadyException ex) {
            throw WrappedException.wrap((Throwable)ex);
        }
    }

    protected void provideServerAddress(StringBuilder sb) {
        sb.append("const zinikiLogin = '" + this.zinikiUri + "/login'\n");
        sb.append("const zinikiServer = '" + this.ziwshUri + "'\n");
        sb.append("env.broker.connectToServer(null);\n");
    }

    protected void handleSecurityModule(StringBuilder buffer) {
        buffer.append("window.appl.securityModule = new ZinikiSecurityModule();\n");
    }

    public void streamError(Throwable err) {
        throw new NotImplementedException();
    }
}

