/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.paas.range;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.ziniki.tdastore.ZiidRangeConsumer;
import org.ziniki.tdastore.ZiidRangeProvider;

public class SequenceNo
implements ZiidRangeConsumer {
    private String prefix = "";
    private final AtomicLong seqNo = new AtomicLong(0L);
    private final AtomicLong last = new AtomicLong(0L);
    private final ZiidRangeProvider provider;
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();

    public SequenceNo(ZiidRangeProvider provider) {
        this.provider = provider;
    }

    public String next(String scheme, String type) {
        long unique = this.seqNo.getAndIncrement();
        if (unique >= this.last.get()) {
            this.lock.lock();
            if (this.last.get() != -1L) {
                this.last.set(-1L);
                this.provider.provideRange((ZiidRangeConsumer)this, scheme, type);
            }
            if (unique > this.last.get()) {
                while (true) {
                    try {
                        this.condition.await();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
            this.lock.unlock();
            unique = this.seqNo.getAndIncrement();
        }
        return this.prefix + Long.toHexString(unique).toUpperCase();
    }

    public void range(String prefix, long from, long range) {
        this.lock.lock();
        this.prefix = prefix;
        this.seqNo.set(from);
        this.last.set(from + range);
        this.condition.signal();
        this.lock.unlock();
    }
}

