/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.cbtxstore.gls;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.ziniki.cbtxstore.gls.GLSRelation;
import org.ziniki.tdastore.TDAStorage;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.zinutils.exceptions.InvalidUsageException;
import org.zinutils.exceptions.NotImplementedException;

public class SlotBindings {
    private final TDAStorage storage;
    private final UnitOfWork uow;
    private final SlotBindings parent;
    private Relation relation;
    private final Map<String, Object> slots = new TreeMap<String, Object>();
    private final Map<Relation, SlotBindings> children = new HashMap<Relation, SlotBindings>();
    private final Map<String, Pending> pending = new TreeMap<String, Pending>();

    public SlotBindings(TDAStorage storage, UnitOfWork uow) {
        this.storage = storage;
        this.uow = uow;
        this.parent = null;
        this.relation = null;
        this.slots.put(TDAStorage.class.getName(), storage);
        this.slots.put(UnitOfWork.class.getName(), uow);
    }

    public SlotBindings(SlotBindings parent) {
        this.storage = parent.storage;
        this.uow = parent.uow;
        this.parent = parent;
    }

    public void relation(GLSRelation ret) {
        this.relation = ret;
        this.parent.children.put(this.relation, this);
        this.slots.put(Relation.class.getName(), this.relation);
    }

    public synchronized <T> void bind(String slot, T object) {
        this.slots.put(slot, object);
        if (this.pending.containsKey(slot)) {
            this.pending.get(slot).bindPending(slot, object);
        }
    }

    public synchronized void collate(String slot, List<String> keys) {
        TreeMap<String, Object> ret = new TreeMap<String, Object>();
        for (String s : keys) {
            if (this.slots.containsKey(s)) {
                ret.put(s, this.slots.get(s));
                continue;
            }
            this.pending.put(s, new Pending(slot, ret, keys.size()));
        }
        if (ret.size() == keys.size()) {
            this.bind(slot, ret);
        }
    }

    public void walk(Object value) {
        if (value == null) {
            throw new InvalidUsageException("cannot walk null value");
        }
        this.walkInterfaces(value.getClass(), intf -> this.bind(intf.getName(), value));
    }

    public synchronized boolean has(String slot) {
        return this.slots.containsKey(slot) || this.parent != null && this.parent.has(slot);
    }

    public synchronized Object bound(String slot) {
        if (this.slots.containsKey(slot)) {
            return this.slots.get(slot);
        }
        if (this.parent != null) {
            return this.parent.bound(slot);
        }
        throw new RuntimeException("Nothing bound in " + slot);
    }

    private void walkInterfaces(Class<? extends Object> cls, Consumer<Class<?>> consumer) {
        if (cls == null || cls == Object.class) {
            return;
        }
        consumer.accept(cls);
        for (Class<?> intf : cls.getInterfaces()) {
            consumer.accept(intf);
            this.walkInterfaces(intf, consumer);
        }
        this.walkInterfaces(cls.getSuperclass(), consumer);
    }

    public SlotBindings cloneMe(SlotBindings newParent) {
        SlotBindings ret = this.parent == null ? new SlotBindings(this.storage, this.uow) : new SlotBindings(newParent);
        ret.slots.putAll(this.slots);
        for (SlotBindings b : new ArrayList<SlotBindings>(this.children.values())) {
            b.cloneMe(ret);
        }
        return ret;
    }

    public SlotBindings child(GLSRelation r) {
        if (!this.children.containsKey(r)) {
            throw new NotImplementedException();
        }
        return this.children.get(r);
    }

    public Set<String> keys() {
        return this.slots.keySet();
    }

    public String toString() {
        return this.slots.toString();
    }

    public class Pending {
        private final String storeAs;
        private final Map<String, Object> map;
        private final int size;

        public Pending(String slot, Map<String, Object> map, int size) {
            this.storeAs = slot;
            this.map = map;
            this.size = size;
        }

        public void bindPending(String key, Object object) {
            this.map.put(key, object);
            if (this.map.size() == this.size) {
                SlotBindings.this.bind(this.storeAs, this.map);
            }
        }
    }
}

