/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.cbtxstore.gls;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import org.ziniki.cbtxstore.gls.Logic;
import org.ziniki.tdastore.gls.GLSException;
import org.ziniki.tdastore.gls.GoingToBlock;
import org.ziniki.tdastore.gls.RelationHandler;
import org.ziniki.tdastore.gls.Slot;

public class LogicAnalyzer {
    public static Logic analyzeMethod(RelationHandler handler, String method, boolean finalLogic) throws GLSException {
        Class<?> hc = handler.getClass();
        return LogicAnalyzer.analyzeMethod(hc, handler, method, finalLogic);
    }

    private static Logic analyzeMethod(Class<? extends RelationHandler> hc, RelationHandler handler, String method, boolean finalLogic) throws GLSException {
        Method[] declaredMethods;
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method m : declaredMethods = hc.getDeclaredMethods()) {
            if (!m.getName().equals(method)) continue;
            methods.add(m);
        }
        if (methods.size() == 0) {
            Class<? extends RelationHandler> parent = hc.getSuperclass();
            if (RelationHandler.class.isAssignableFrom(parent)) {
                return LogicAnalyzer.analyzeMethod(parent, handler, method, finalLogic);
            }
            throw new GLSException("There is no declared method called " + method + " in the logic handler " + hc);
        }
        if (methods.size() > 1) {
            throw new GLSException("There are multiple declared methods called " + method + " in the logic handler " + hc);
        }
        ArrayList<String> args = new ArrayList<String>();
        Method m = (Method)methods.get(0);
        for (Parameter a : m.getParameters()) {
            Slot slotAnn = a.getAnnotation(Slot.class);
            if (slotAnn == null) {
                args.add(a.getType().getName());
                continue;
            }
            args.add(slotAnn.value());
        }
        return new Logic(handler, m, args, finalLogic, m.getAnnotation(GoingToBlock.class));
    }
}

