/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.cbtxstore.gls;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.cbtxstore.gls.GLRelationAction;
import org.ziniki.cbtxstore.gls.GLSRelation;
import org.ziniki.cbtxstore.gls.GLUnitOfWork;
import org.ziniki.cbtxstore.gls.InvocationStatus;
import org.ziniki.cbtxstore.gls.SlotBindings;
import org.ziniki.tdastore.TDAStorage;
import org.ziniki.tdastore.gls.GoingToBlock;
import org.ziniki.tdastore.gls.RelationHandler;
import org.ziniki.tdastore.support.ThreadAwareUOW;
import org.ziniki.tdastore.support.UOWExecutor;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.WrappedException;

public class Logic
implements GLRelationAction {
    public final Logger logger = LoggerFactory.getLogger((String)"GLS");
    private final RelationHandler handler;
    private final Method method;
    private final List<String> args;
    private final boolean finalLogic;
    private final GoingToBlock willBlock;

    public Logic(RelationHandler handler, Method method, List<String> args, boolean finalLogic, GoingToBlock willBlock) {
        this.handler = handler;
        this.method = method;
        this.args = args;
        this.finalLogic = finalLogic;
        this.willBlock = willBlock;
    }

    @Override
    public InvocationStatus invoke(TDAStorage storage, UOWExecutor exec, final GLUnitOfWork uow, GLSRelation couchbaseRelation, SlotBindings bindings) {
        this.logger.debug("logic.invoke called for " + this.method.getName() + " in " + couchbaseRelation);
        if (!this.isReady(bindings)) {
            return InvocationStatus.IGNORED;
        }
        final Object[] ia = new Object[this.args.size()];
        for (int i = 0; i < this.args.size(); ++i) {
            ia[i] = bindings.bound(this.args.get(i));
        }
        exec.execute((ThreadAwareUOW)uow, this.willBlock != null, new Runnable(){

            @Override
            public void run() {
                try {
                    Logic.this.logger.debug("Invoking " + Logic.this.method.getName());
                    Logic.this.method.invoke((Object)Logic.this.handler, ia);
                    Logic.this.logger.debug("Sucessfully finished " + Logic.this.method.getName());
                }
                catch (IllegalArgumentException e) {
                    if ("argument type mismatch".equals(e.getMessage())) {
                        Logic.this.logger.error("argument type mismatch in calling " + Logic.this.method + " with");
                        for (int i = 0; i < ia.length; ++i) {
                            Logic.this.logger.error(" #" + i + " = " + ia[i] + " {" + (String)(ia[i] == null ? "null" : ia[i].getClass() + "}"));
                        }
                    }
                    throw new CantHappenException("logic called with wrong arguments ... see log");
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    Logic.this.logger.info("failed to call " + Logic.this.method.getName(), (Throwable)e);
                    throw WrappedException.wrap((Throwable)e);
                }
                finally {
                    if (!Logic.this.finalLogic) {
                        Logic.this.logger.debug("Done logic method " + Logic.this.method.getName());
                        uow.opDone(Logic.this);
                    }
                }
            }

            public String toString() {
                return "Logic[" + Logic.this.method.getName() + "]";
            }
        });
        this.logger.debug("have passed " + this.method.getName() + " in " + couchbaseRelation + " to executor");
        return InvocationStatus.FIRED;
    }

    @Override
    public boolean isReady(SlotBindings bindings) {
        for (String s : this.args) {
            if (bindings.has(s)) continue;
            this.logger.debug("Not invoking " + this.method.getName() + " without " + s);
            return false;
        }
        return true;
    }

    public void addPending(Set<String> pending, List<String> backgroundVars, SlotBindings bindings) {
        HashSet<String> tmp = new HashSet<String>();
        for (String s : this.args) {
            if (bindings.has(s)) continue;
            if (backgroundVars.contains(s)) {
                return;
            }
            tmp.add(s);
        }
        pending.addAll(tmp);
    }

    public String toString() {
        return "Logic[" + this.method.getName() + "]";
    }
}

