/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.cbtxstore.gls;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.flasck.jvm.container.FLEnvironment;
import org.flasck.jvm.fl.FLCommonEvalContext;
import org.ziniki.cbtxstore.gls.FinalLogicSet;
import org.ziniki.cbtxstore.gls.GLRelationAction;
import org.ziniki.cbtxstore.gls.GLSRelation;
import org.ziniki.cbtxstore.gls.RelationExecutor;
import org.ziniki.cbtxstore.gls.RelationFailedException;
import org.ziniki.cbtxstore.gls.SetRelationAction;
import org.ziniki.cbtxstore.gls.TxError;
import org.ziniki.tdastore.TDAStorage;
import org.ziniki.tdastore.gls.GLSException;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.RelationAction;
import org.ziniki.tdastore.gls.RelationHandler;
import org.ziniki.tdastore.gls.SetterRunner;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.tdastore.lowlevel.ExistingRecord;
import org.ziniki.tdastore.support.InvokeSet;
import org.ziniki.tdastore.support.ThreadAwareTxManager;
import org.ziniki.tdastore.support.ThreadAwareUOW;
import org.ziniki.tdastore.support.UOWExecutor;
import org.zinutils.exceptions.InvalidUsageException;
import org.zinutils.exceptions.WrappedException;

public abstract class GLUnitOfWork
extends FLCommonEvalContext
implements ThreadAwareUOW {
    private final ThreadAwareTxManager txmgr;
    private final String id;
    private final TDAStorage storage;
    protected final UOWExecutor uowexec;
    private final FinalLogicSet endLogic;
    private final Map<String, ExistingRecord> retrs = new TreeMap<String, ExistingRecord>();
    private final List<GLSRelation> originals = new ArrayList<GLSRelation>();
    private boolean needRetry = false;
    private RelationFailedException fatalError;
    private boolean doneReads = false;
    private boolean hasCompleted = false;
    private boolean started = false;
    private Map<Relation, RelationExecutor> relexecs = new HashMap<Relation, RelationExecutor>();
    private SetterRunner setterRunner;
    private final Executor exec;
    private CompletableFuture<Void> txCompleted;
    private AtomicInteger manualLock = new AtomicInteger();
    private UnitOfWork previous = null;
    private final Map<Class<?>, Object> traits = new HashMap();
    private Date startAt;
    private Date completeBy;

    public GLUnitOfWork(FLEnvironment env, String id, ThreadAwareTxManager txmgr, TDAStorage storage, Executor exec, UOWExecutor uowexec, CompletableFuture<Void> txCompleted) {
        super(env);
        this.txmgr = txmgr;
        if (txmgr.currentUOWId() != null) {
            this.previous = txmgr.currentUOW();
            this.logger.info("Setting previous of " + id + " to " + this.previous.id());
            this.traits.putAll(((GLUnitOfWork)this.previous).traits);
        }
        this.id = id;
        this.storage = storage;
        this.exec = exec;
        this.uowexec = uowexec;
        this.txCompleted = txCompleted;
        this.endLogic = new FinalLogicSet(null);
    }

    public String id() {
        return this.id;
    }

    public ThreadAwareTxManager getManager() {
        return this.txmgr;
    }

    public void setWaitTime(int timeout, TimeUnit unit) {
        long from;
        long to;
        if (this.startAt == null) {
            this.startAt = new Date();
        }
        if ((to = (from = this.startAt.getTime()) + TimeUnit.MILLISECONDS.convert(timeout, unit)) - from > 60000L) {
            throw new InvalidUsageException("maximum UOW wait time is 60s");
        }
        this.completeBy = new Date(to);
        this.logger.info("Adjusting completeBy for " + this + " to " + this.completeBy);
    }

    public void whenCommitted(RelationHandler handler, String method) throws GLSException {
        this.endLogic.whenCommitted(handler, method);
    }

    public void whenRolledBack(RelationHandler handler, String method) throws GLSException {
        this.endLogic.whenRolledBack(handler, method);
    }

    public void atEnd(RelationHandler handler, String method) throws GLSException {
        this.endLogic.atEnd(handler, method);
    }

    public synchronized Relation relation(RelationHandler handler) {
        GLSRelation ret = new GLSRelation((UnitOfWork)this, handler, this.originals.size());
        if (!this.started) {
            this.originals.add(ret);
        } else {
            this.logger.debug("relation " + ret + " created while tx in progress; will need to call makeReady");
        }
        return ret;
    }

    public synchronized void makeReady(Relation r) {
        if (!this.started) {
            this.logger.info("MakeReady[" + r + "] called, but since UOW has not yet started, it should already have been added to originals on create");
            return;
        }
        GLSRelation cr = (GLSRelation)r;
        this.relexecs.put(cr, cr.makeReady(this.storage, this.exec, this.uowexec, (UnitOfWork)this));
        this.logger.debug("Make " + r + " ready; now have " + this.relexecs);
        this.playAll(null);
    }

    public void enact() {
        if (this.started) {
            throw new InvalidUsageException("cannot enact UOW multiple times");
        }
        this.starttx();
    }

    public synchronized void starttx() {
        this.started = true;
        this.relexecs.clear();
        for (GLSRelation r : this.originals) {
            this.relexecs.put(r, r.makeReady(this.storage, this.exec, this.uowexec, (UnitOfWork)this));
        }
        this.playAll(null);
    }

    public void manualLock() {
        this.manualLock.getAndIncrement();
    }

    public synchronized void manualRelease() {
        if (this.manualLock.decrementAndGet() == 0) {
            this.playAll(null);
        }
    }

    synchronized void playAll(GLRelationAction action) {
        boolean allDone = this.manualLock.get() == 0;
        this.logger.debug("initially allDone = " + allDone);
        try {
            for (RelationExecutor re : this.relexecs.values()) {
                this.logger.debug("after " + re + ", allDone = " + (allDone &= re.playGL(action)));
            }
        }
        catch (GLSException ex) {
            this.fatalError(ex);
        }
        this.logger.debug("In playAll, allDone = " + allDone + " and doneReads = " + this.doneReads);
        if (allDone && !this.doneReads) {
            this.gldone();
        }
    }

    public boolean has(String id) {
        return this.retrs.containsKey(id);
    }

    public <T> ExistingRecord getCB(String id) {
        ExistingRecord retr = this.retrs.get(id);
        if (retr == null) {
            throw new NullPointerException("Doc " + id + " was apparently not retrieved");
        }
        return retr;
    }

    public <T> void remember(String id, ExistingRecord retr) {
        this.logger.info("Remembering " + id + " in the UOW");
        this.retrs.put(id, retr);
    }

    public void duplicateRetry(String id) {
        this.needRetry = true;
    }

    public void changedRetry() {
        this.needRetry = true;
    }

    public void duplicateFailed(String id) {
        if (this.fatalError == null) {
            this.fatalError = new RelationFailedException();
        }
        this.fatalError.add(new RuntimeException("attempt to create duplicate " + id));
    }

    public void fatalError(Throwable ex) {
        if (this.fatalError == null) {
            this.fatalError = new RelationFailedException();
        }
        this.fatalError.add(ex);
    }

    public synchronized void gldone() {
        this.logger.debug("gldone called with doneReads = " + this.doneReads);
        if (this.doneReads) {
            throw new RuntimeException("You should not call setters in a UOW more than once");
        }
        this.doneReads = true;
        ArrayList<InvokeSet> allSets = new ArrayList<InvokeSet>();
        for (RelationExecutor exec : this.relexecs.values()) {
            exec.gather(allSets);
        }
        this.setterRunner = this.txmgr.runSetActions(this.storage, this.uowexec, (UnitOfWork)this, allSets);
    }

    public synchronized void txdone() {
        if (this.hasCompleted) {
            throw new RuntimeException("You should not complete a UOW more than once");
        }
        this.logger.info("UOW " + this.id + " completing with " + this.relexecs + " and txcompleted = " + this.txCompleted);
        if (this.fatalError == null && this.needRetry) {
            this.reset();
            this.starttx();
            return;
        }
        this.hasCompleted = true;
        if (this.txCompleted != null) {
            this.txCompleted.complete(null);
        }
        this.logger.info("UOW " + this.id + " completed; txCompleted = " + this.txCompleted);
        if (this.fatalError != null) {
            for (RelationExecutor r : this.relexecs.values()) {
                r.performFinalActions(this.uowexec, this, this.fatalError);
            }
            this.endLogic.performActions(this.uowexec, this, null, this.fatalError);
        } else {
            for (RelationExecutor r : this.relexecs.values()) {
                r.performFinalActions(this.uowexec, this, null);
            }
            this.endLogic.performActions(this.uowexec, this, null, null);
        }
    }

    private void reset() {
        this.fatalError = null;
        this.needRetry = false;
        this.doneReads = false;
    }

    public void block() {
        if (this.started) {
            throw new RuntimeException("Cannot block uow once enacted");
        }
        CompletableFuture<TxError> waitFor = new CompletableFuture<TxError>();
        try {
            this.logger.info("blocking for UOW " + this);
            this.atEnd(new UnblockHandler(waitFor), "unblock");
            this.enact();
            this.doWaiting(waitFor);
        }
        catch (GLSException ex) {
            this.logger.error("Failed to block", (Throwable)ex);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            this.logger.error("timed out", (Throwable)e);
            for (Map.Entry<Relation, RelationExecutor> re : this.relexecs.entrySet()) {
                this.logger.error("  died when re for " + re.getKey() + " had " + re.getValue().outstanding());
            }
            throw WrappedException.wrap((Throwable)e);
        }
        finally {
            this.logger.info("reverting to UOW " + this.previous);
            this.txmgr.currentThreadUOW(this.previous);
        }
    }

    protected void waitForEnd() {
        CompletableFuture<TxError> waitFor = new CompletableFuture<TxError>();
        try {
            this.atEnd(new UnblockHandler(waitFor), "unblock");
            this.logger.info("blocking for UOW " + this);
            this.doWaiting(waitFor);
        }
        catch (GLSException ex) {
            this.logger.error("Failed to block", (Throwable)ex);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            this.logger.error("timed out", (Throwable)e);
            throw WrappedException.wrap((Throwable)e);
        }
    }

    private void doWaiting(CompletableFuture<TxError> waitFor) throws InterruptedException, ExecutionException, TimeoutException {
        this.strategyHelper();
        if (this.startAt == null) {
            this.startAt = new Date();
        }
        if (this.completeBy == null) {
            this.completeBy = new Date(this.startAt.getTime() + 5000L);
        }
        this.logger.info("waiting for UOW " + this + " with " + waitFor + " until " + this.completeBy);
        while (true) {
            long waitMS;
            if ((waitMS = this.completeBy.getTime() - new Date().getTime()) < 0L) {
                waitMS = 1L;
            }
            try {
                TxError err = waitFor.get(waitMS, TimeUnit.MILLISECONDS);
                if (err != null) {
                    this.logger.error("block returned with error " + err);
                } else {
                    this.logger.info("block returned without error");
                }
                return;
            }
            catch (TimeoutException ex) {
                if (new Date().compareTo(this.completeBy) == -1) continue;
                throw ex;
            }
            break;
        }
    }

    protected void strategyHelper() {
    }

    public synchronized void opDone(RelationAction ra) {
        if (ra instanceof GLRelationAction) {
            this.logger.debug(ra + " has completed; playing all");
            GLRelationAction action = (GLRelationAction)ra;
            this.playAll(action);
        } else {
            this.logger.debug(ra + " has completed; waiting for sets to complete");
            SetRelationAction action = (SetRelationAction)ra;
            this.setterRunner.waitForSets((RelationAction)action);
        }
    }

    public synchronized Object read(Relation r, String slot) {
        RelationExecutor re = this.relexecs.get(r);
        return re.bound(slot);
    }

    public boolean hasCompleted() {
        return this.hasCompleted;
    }

    public boolean hasDoneGL() {
        return this.doneReads;
    }

    public void waitForResult() {
        if (!this.hasCompleted()) {
            this.waitForEnd();
        }
    }

    public boolean hadError() {
        return this.fatalError != null;
    }

    public <T> void trait(Class<T> clz, T value) {
        this.traits.put(clz, value);
    }

    public <T> T trait(Class<T> clz) {
        return clz.cast(this.traits.get(clz));
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this.id + "]";
    }

    public class UnblockHandler
    implements RelationHandler {
        private CompletableFuture<TxError> waitFor;

        public UnblockHandler(CompletableFuture<TxError> waitFor) {
            this.waitFor = waitFor;
        }

        public void unblock(TxError error) {
            this.waitFor.complete(error);
            GLUnitOfWork.this.logger.info("Completed blocking waitFor with " + error);
        }
    }
}

