/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.cbtxstore.gls;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.cbtxstore.gls.DoCreate;
import org.ziniki.cbtxstore.gls.DoDelete;
import org.ziniki.cbtxstore.gls.DoGet;
import org.ziniki.cbtxstore.gls.DoGetList;
import org.ziniki.cbtxstore.gls.DoLink;
import org.ziniki.cbtxstore.gls.DoLoad;
import org.ziniki.cbtxstore.gls.DoObtainFrom;
import org.ziniki.cbtxstore.gls.DoRetrieveLinks;
import org.ziniki.cbtxstore.gls.DoSubscribe;
import org.ziniki.cbtxstore.gls.DoTouch;
import org.ziniki.cbtxstore.gls.DoUpdate;
import org.ziniki.cbtxstore.gls.DoUpsert;
import org.ziniki.cbtxstore.gls.FinalLogicSet;
import org.ziniki.cbtxstore.gls.GLRelationAction;
import org.ziniki.cbtxstore.gls.GLUnitOfWork;
import org.ziniki.cbtxstore.gls.LogicAnalyzer;
import org.ziniki.cbtxstore.gls.RelationExecutor;
import org.ziniki.cbtxstore.gls.RememberMap;
import org.ziniki.cbtxstore.gls.SetRelationAction;
import org.ziniki.cbtxstore.gls.SlotBindings;
import org.ziniki.cbtxstore.gls.TxError;
import org.ziniki.paas.interfaces.EntityLink;
import org.ziniki.tdastore.NotifySubscriber;
import org.ziniki.tdastore.StorageOptions;
import org.ziniki.tdastore.TDAStorage;
import org.ziniki.tdastore.gls.GLSException;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.RelationAction;
import org.ziniki.tdastore.gls.RelationHandler;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.tdastore.support.UOWExecutor;
import org.ziniki.ziwsh.intf.IdempotentHandler;
import org.zinutils.exceptions.InvalidUsageException;

public class GLSRelation
implements Relation {
    public final Logger logger = LoggerFactory.getLogger((String)"GLSRelation");
    private final UnitOfWork uow;
    private final RelationHandler handler;
    private final List<GLRelationAction> gls = new ArrayList<GLRelationAction>();
    private final List<SetRelationAction> set = new ArrayList<SetRelationAction>();
    private final FinalLogicSet endLogic;
    private RelationExecutor exec = null;
    List<String> backgroundVars = new ArrayList<String>();
    private final int pos;

    public GLSRelation(UnitOfWork uow, RelationHandler handler, int pos) {
        this.uow = uow;
        this.handler = handler;
        this.pos = pos;
        this.endLogic = new FinalLogicSet(handler);
    }

    public UnitOfWork uow() {
        return this.uow;
    }

    public RelationExecutor executor() {
        if (this.exec == null) {
            throw new InvalidUsageException("cannot ask for executor before it is created");
        }
        return this.exec;
    }

    public void makeReady() {
        this.uow.makeReady((Relation)this);
    }

    public void whenCommitted(String method) throws GLSException {
        this.endLogic.whenCommitted(method);
    }

    public void whenRolledBack(String method) throws GLSException {
        this.endLogic.whenRolledBack(method);
    }

    public void atEnd(String method) throws GLSException {
        this.endLogic.atEnd(method);
    }

    public void performActions(UOWExecutor ue, GLUnitOfWork uow, TxError error, SlotBindings bindings) {
        this.endLogic.performActions(ue, uow, bindings, error);
    }

    public void addAction(RelationAction act) {
        if (this.exec != null) {
            this.exec.add(act);
        } else if (act instanceof GLRelationAction) {
            this.gls.add((GLRelationAction)act);
        } else {
            this.set.add((SetRelationAction)act);
        }
    }

    public void background(String backgroundVar) {
        this.backgroundVars.add(backgroundVar);
    }

    public void map(String slot, List<String> keys) {
        this.addAction(new RememberMap(slot, keys));
    }

    public void get(String slot, String id) {
        this.addAction(new DoGet(slot, id, null));
    }

    public void get(String slot, String id, Function<?, ?> filter) {
        this.addAction(new DoGet(slot, id, filter));
    }

    public void getList(String slot, List<String> ids) {
        this.addAction(new DoGetList(slot, ids));
    }

    public void load(Object value) {
        this.addAction(new DoLoad(null, value));
    }

    public void load(String slot, Object value) {
        this.addAction(new DoLoad(slot, value));
    }

    public void logic(String method) throws GLSException {
        this.addAction(LogicAnalyzer.analyzeMethod(this.handler, method, false));
    }

    public void logic(RelationHandler other, String method) throws GLSException {
        this.addAction(LogicAnalyzer.analyzeMethod(other, method, false));
    }

    public void obtainFrom(String intoSlot, Relation fromRelation, String fromSlot) {
        this.addAction(new DoObtainFrom(intoSlot, fromRelation, fromSlot));
    }

    public void create(String id, Object value) {
        this.addAction(new DoCreate(this.uow, id, value, null, false));
    }

    public void create(String id, Object value, StorageOptions options) {
        this.addAction(new DoCreate(this.uow, id, value, options, false));
    }

    public void createOrRetry(String id, Object value) {
        this.addAction(new DoCreate(this.uow, id, value, null, true));
    }

    public void createOrRetry(String id, Object value, StorageOptions options) {
        this.addAction(new DoCreate(this.uow, id, value, options, true));
    }

    public void link(EntityLink link) {
        this.addAction(new DoLink(link));
    }

    public void links(String slot, String table, String hash) {
        this.addAction(new DoRetrieveLinks(slot, table, hash));
    }

    public void upsert(String id, Object obj) {
        this.addAction(new DoUpsert(id, obj));
    }

    public void update(String id, Object obj) {
        this.addAction(new DoUpdate(id, obj));
    }

    public void touch(String id, StorageOptions expiry) {
        this.addAction(new DoTouch(id, expiry));
    }

    public void delete(String id) {
        this.addAction(new DoDelete(id));
    }

    public void subscribe(String id, IdempotentHandler handler) {
        this.addAction(new DoSubscribe(id, handler));
    }

    public RelationExecutor makeReady(TDAStorage storage, Executor ex, UOWExecutor ue, UnitOfWork uow) {
        this.exec = new RelationExecutor(storage, ex, ue, uow, this, this.gls, this.set, this.endLogic);
        return this.exec;
    }

    public void sendNotifications(String key, NotifySubscriber notifySubscriber) throws GLSException {
        if (this.exec == null || !this.uow.hasCompleted()) {
            throw new GLSException("cannot send notifications until unit of work is complete");
        }
        this.exec.sendNotifications(key, notifySubscriber);
    }

    public void fatalError(Throwable ex) {
        this.exec.fatalError(ex);
    }

    public <T> T obtain(Class<T> cls, String slot) {
        if (this.exec == null) {
            throw new InvalidUsageException("can only call obtain when the relation has completed");
        }
        return cls.cast(this.exec.bound(slot));
    }

    public RelationHandler handler() {
        return this.handler;
    }

    public String toString() {
        return this.uow.toString() + "-" + this.pos;
    }
}

