/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.cbtxstore.gls;

import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.cbtxstore.gls.GLRelationAction;
import org.ziniki.cbtxstore.gls.GLSRelation;
import org.ziniki.cbtxstore.gls.GLUnitOfWork;
import org.ziniki.cbtxstore.gls.InvocationStatus;
import org.ziniki.cbtxstore.gls.SlotBindings;
import org.ziniki.paas.interfaces.EntityLink;
import org.ziniki.tdastore.TDAStorage;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.tdastore.lowlevel.TDALinkProvider;
import org.ziniki.tdastore.support.UOWExecutor;

public class DoRetrieveLinks
implements GLRelationAction {
    public static final Logger logger = LoggerFactory.getLogger((String)"GLS");
    private final String slot;
    private final String table;
    private final String hash;

    public DoRetrieveLinks(String slot, String table, String hash) {
        this.slot = slot;
        this.table = table;
        this.hash = hash;
    }

    @Override
    public boolean isReady(SlotBindings bindings) {
        return true;
    }

    @Override
    public InvocationStatus invoke(TDAStorage storage, UOWExecutor exec, final GLUnitOfWork uow, GLSRelation couchbaseRelation, final SlotBindings bindings) {
        logger.info("Requesting links in " + this.table + " with " + this.hash);
        final ArrayList result = new ArrayList();
        storage.links((UnitOfWork)uow, this.table, this.hash, new TDALinkProvider(){

            public void next(EntityLink link) {
                result.add(link);
            }

            public void complete() {
                logger.info("Binding links " + DoRetrieveLinks.this.slot + " with " + result);
                bindings.bind(DoRetrieveLinks.this.slot, result);
                uow.opDone(DoRetrieveLinks.this);
            }
        });
        return InvocationStatus.FIRED;
    }
}

