/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.cbtxstore.gls;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.cbtxstore.gls.GLRelationAction;
import org.ziniki.cbtxstore.gls.GLSRelation;
import org.ziniki.cbtxstore.gls.GLUnitOfWork;
import org.ziniki.cbtxstore.gls.InvocationStatus;
import org.ziniki.cbtxstore.gls.SlotBindings;
import org.ziniki.tdastore.TDAStorage;
import org.ziniki.tdastore.support.UOWExecutor;
import org.zinutils.exceptions.InvalidUsageException;

public class DoLoad
implements GLRelationAction {
    public final Logger logger = LoggerFactory.getLogger((String)"GLS");
    private final String slot;
    private final Object value;

    public DoLoad(String slot, Object value) {
        if (slot == null && value == null) {
            throw new InvalidUsageException("cannot walk null value");
        }
        this.slot = slot;
        this.value = value;
    }

    @Override
    public boolean isReady(SlotBindings bindings) {
        return true;
    }

    @Override
    public InvocationStatus invoke(TDAStorage storage, UOWExecutor exec, GLUnitOfWork uow, GLSRelation couchbaseRelation, SlotBindings bindings) {
        if (this.slot != null) {
            bindings.bind(this.slot, this.value);
        } else {
            bindings.walk(this.value);
        }
        return InvocationStatus.COMPLETED;
    }

    public String toString() {
        if (this.slot != null) {
            return "DoLoad[" + this.slot + " <- " + this.value + "]";
        }
        return "DoWalk[" + this.value + "]";
    }
}

