/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.cbtxstore.gls;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.cbtxstore.gls.GLSRelation;
import org.ziniki.cbtxstore.gls.GLUnitOfWork;
import org.ziniki.cbtxstore.gls.LocallyCreatedRecord;
import org.ziniki.cbtxstore.gls.SetRelationAction;
import org.ziniki.cbtxstore.gls.SlotBindings;
import org.ziniki.tdastore.StorageOptions;
import org.ziniki.tdastore.TDAStorage;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.tdastore.lowlevel.ExistingRecord;
import org.ziniki.tdastore.lowlevel.TDACreateHandler;
import org.ziniki.tdastore.support.UOWExecutor;
import org.ziniki.ziwsh.intf.ProvideIDOnCreate;

public class DoCreate
implements SetRelationAction {
    public final Logger logger = LoggerFactory.getLogger((String)"GLS");
    private final String id;
    private Object value;
    private final StorageOptions options;
    private final boolean allowRetry;
    private boolean dontBother;

    public DoCreate(UnitOfWork uow, String id, Object value, StorageOptions options, boolean allowRetry) {
        this.id = id;
        this.value = value;
        this.options = options;
        this.allowRetry = allowRetry;
        if (value instanceof ProvideIDOnCreate) {
            ((ProvideIDOnCreate)value).provideID(id);
        }
        uow.remember(id, (ExistingRecord)new LocallyCreatedRecord(this));
    }

    public void updateWithValue(Object value) {
        this.value = value;
    }

    public Object value() {
        return this.value;
    }

    public void willBeDeleted() {
        this.dontBother = true;
    }

    @Override
    public boolean forgetMe() {
        return this.dontBother;
    }

    @Override
    public boolean updateLocalCreate(GLUnitOfWork uow) {
        return false;
    }

    @Override
    public void invoke(TDAStorage storage, UOWExecutor exec, final GLUnitOfWork uow, GLSRelation couchbaseRelation, SlotBindings bindings) {
        this.logger.info("Creating " + this.id);
        storage.create((UnitOfWork)uow, this.id, this.value, this.options, new TDACreateHandler(){

            public void success() {
                uow.opDone(DoCreate.this);
            }

            public void error(Throwable ex) {
                uow.fatalError(ex);
                uow.opDone(DoCreate.this);
            }

            public void alreadyExists() {
                if (DoCreate.this.allowRetry) {
                    uow.duplicateRetry(DoCreate.this.id);
                } else {
                    uow.duplicateFailed(DoCreate.this.id);
                }
                uow.opDone(DoCreate.this);
            }
        });
    }

    public String toString() {
        return "Create[" + this.id + "]";
    }
}

