/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricDataRequest;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricDataResponse;
import software.amazon.awssdk.services.cloudwatch.model.MessageData;
import software.amazon.awssdk.services.cloudwatch.model.MetricDataResult;

public class GetMetricDataIterable
implements SdkIterable<GetMetricDataResponse> {
    private final CloudWatchClient client;
    private final GetMetricDataRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetMetricDataIterable(CloudWatchClient client, GetMetricDataRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetMetricDataResponseFetcher();
    }

    public Iterator<GetMetricDataResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MetricDataResult> metricDataResults() {
        Function<GetMetricDataResponse, Iterator> getIterator = response -> {
            if (response != null && response.metricDataResults() != null) {
                return response.metricDataResults().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    public final SdkIterable<MessageData> messages() {
        Function<GetMetricDataResponse, Iterator> getIterator = response -> {
            if (response != null && response.messages() != null) {
                return response.messages().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetMetricDataResponseFetcher
    implements SyncPageFetcher<GetMetricDataResponse> {
        private GetMetricDataResponseFetcher() {
        }

        public boolean hasNextPage(GetMetricDataResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetMetricDataResponse nextPage(GetMetricDataResponse previousPage) {
            if (previousPage == null) {
                return GetMetricDataIterable.this.client.getMetricData(GetMetricDataIterable.this.firstRequest);
            }
            return GetMetricDataIterable.this.client.getMetricData((GetMetricDataRequest)((Object)GetMetricDataIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

