/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.BatchFailuresCopier;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchResponse;
import software.amazon.awssdk.services.cloudwatch.model.PartialFailure;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisableInsightRulesResponse
extends CloudWatchResponse
implements ToCopyableBuilder<Builder, DisableInsightRulesResponse> {
    private static final SdkField<List<PartialFailure>> FAILURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DisableInsightRulesResponse.getter(DisableInsightRulesResponse::failures)).setter(DisableInsightRulesResponse.setter(Builder::failures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Failures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PartialFailure::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILURES_FIELD));
    private final List<PartialFailure> failures;

    private DisableInsightRulesResponse(BuilderImpl builder) {
        super(builder);
        this.failures = builder.failures;
    }

    public boolean hasFailures() {
        return this.failures != null && !(this.failures instanceof SdkAutoConstructList);
    }

    public List<PartialFailure> failures() {
        return this.failures;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.failures());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableInsightRulesResponse)) {
            return false;
        }
        DisableInsightRulesResponse other = (DisableInsightRulesResponse)((Object)obj);
        return Objects.equals(this.failures(), other.failures());
    }

    public String toString() {
        return ToString.builder((String)"DisableInsightRulesResponse").add("Failures", this.failures()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Failures": {
                return Optional.ofNullable(clazz.cast(this.failures()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisableInsightRulesResponse, T> g) {
        return obj -> g.apply((DisableInsightRulesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchResponse.BuilderImpl
    implements Builder {
        private List<PartialFailure> failures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisableInsightRulesResponse model) {
            super(model);
            this.failures(model.failures);
        }

        public final Collection<PartialFailure.Builder> getFailures() {
            return this.failures != null ? (Collection)this.failures.stream().map(PartialFailure::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failures(Collection<PartialFailure> failures) {
            this.failures = BatchFailuresCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(PartialFailure ... failures) {
            this.failures(Arrays.asList(failures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Consumer<PartialFailure.Builder> ... failures) {
            this.failures(Stream.of(failures).map(c -> (PartialFailure)((PartialFailure.Builder)PartialFailure.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFailures(Collection<PartialFailure.BuilderImpl> failures) {
            this.failures = BatchFailuresCopier.copyFromBuilder(failures);
        }

        @Override
        public DisableInsightRulesResponse build() {
            return new DisableInsightRulesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisableInsightRulesResponse> {
        public Builder failures(Collection<PartialFailure> var1);

        public Builder failures(PartialFailure ... var1);

        public Builder failures(Consumer<PartialFailure.Builder> ... var1);
    }
}

