/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.storage.memory;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.ziniki.server.tda.RequestMethod;
import org.ziniki.servlet.tda.NotReadyException;
import org.ziniki.servlet.tda.RequestProcessor;
import org.ziniki.servlet.tda.Responder;
import org.ziniki.servlet.tda.ResponseReadyContinuation;
import org.ziniki.storage.memory.IMContentStorage;
import org.ziniki.storage.memory.IMStorage;
import org.ziniki.ziwsh.intf.Param;
import org.zinutils.exceptions.NotImplementedException;

public class ZipContents
implements RequestProcessor,
RequestMethod {
    private final IMStorage authStorage;
    private final IMStorage zinikiStorage;
    private final IMContentStorage contentStore;
    private String method;

    public ZipContents(@Param(value="authStorage") IMStorage authStorage, @Param(value="zinikiStorage") IMStorage zinikiStorage, @Param(value="contentStore") IMContentStorage contentStore) {
        this.authStorage = authStorage;
        this.zinikiStorage = zinikiStorage;
        this.contentStore = contentStore;
    }

    public void requestMethod(String methodName) {
        this.method = methodName;
    }

    public void process(Responder r) throws Exception {
        if (!"GET".equals(this.method)) {
            r.setStatus(405);
            r.done();
            return;
        }
        r.setStatus(200);
        new Sender(r, this.authStorage.allKeys().iterator(), this.zinikiStorage.allKeys().iterator(), this.contentStore.allKeys().iterator(), this.contentStore.allKeys().iterator()).sendNext();
        r.done();
    }

    public class FeedbackOutputStream
    extends OutputStream
    implements ResponseReadyContinuation {
        private final Sender sender;
        private final Responder r;
        private final ByteArrayOutputStream backlog = new ByteArrayOutputStream();
        private final byte[] one = new byte[1];
        private boolean blocked = false;

        public FeedbackOutputStream(Sender sender, Responder r) {
            this.sender = sender;
            this.r = r;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.blocked) {
                this.backlog.write(b, off, len);
            } else {
                try {
                    boolean complete = this.r.write(b, off, len, (ResponseReadyContinuation)this);
                    if (!complete) {
                        this.blocked = true;
                        this.sender.blocked(true);
                    }
                }
                catch (NotReadyException e) {
                    throw new IOException(e);
                }
            }
        }

        @Override
        public void write(int b) throws IOException {
            this.one[0] = (byte)b;
            this.write(this.one, 0, 1);
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.r.done();
        }

        public boolean responseReady() throws IOException, NotReadyException {
            throw new NotImplementedException("unblocked is not handled yet");
        }

        public void streamError(Throwable err) {
        }
    }

    public class Sender {
        private final Iterator<String> auths;
        private final Iterator<String> zins;
        private final Iterator<String> cts;
        private final Iterator<String> cos;
        private final ZipOutputStream zs;
        private final AtomicBoolean blocked = new AtomicBoolean(false);

        public Sender(Responder r, Iterator<String> auths, Iterator<String> zins, Iterator<String> cts, Iterator<String> cos) {
            this.auths = auths;
            this.zins = zins;
            this.cts = cts;
            this.cos = cos;
            this.zs = new ZipOutputStream(new FeedbackOutputStream(this, r));
        }

        public void sendNext() throws IOException {
            String k;
            while (this.auths.hasNext()) {
                k = this.auths.next();
                this.zs.putNextEntry(new ZipEntry("auth/" + k));
                this.zs.write(ZipContents.this.authStorage.getJson(k).getBytes("UTF-8"));
                if (!this.blocked.get()) continue;
                return;
            }
            while (this.zins.hasNext()) {
                k = this.zins.next();
                this.zs.putNextEntry(new ZipEntry("zin/" + k));
                this.zs.write(ZipContents.this.zinikiStorage.getJson(k).getBytes("UTF-8"));
                if (!this.blocked.get()) continue;
                return;
            }
            while (this.cts.hasNext()) {
                k = this.cts.next();
                this.zs.putNextEntry(new ZipEntry("ct/" + k));
                this.zs.write(ZipContents.this.contentStore.get(k).contentType().getBytes("UTF-8"));
                if (!this.blocked.get()) continue;
                return;
            }
            while (this.cos.hasNext()) {
                k = this.cos.next();
                this.zs.putNextEntry(new ZipEntry("co/" + k));
                this.zs.write(ZipContents.this.contentStore.get(k).asByteArray());
                if (!this.blocked.get()) continue;
                return;
            }
            this.zs.close();
        }

        public void blocked(boolean v) {
            this.blocked.set(v);
        }
    }
}

