/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.storage.memory;

import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.flasck.flas.testrunner.JSJavaBridge;
import org.flasck.jvm.container.BoundVar;
import org.flasck.jvm.container.FLEnvironment;
import org.flasck.jvm.fl.AssertFailed;
import org.flasck.jvm.fl.FlasTestException;
import org.flasck.jvm.fl.NotFound;
import org.flasck.jvm.fl.TestHelper;
import org.ziniki.common.ZiIdURI;
import org.ziniki.core.concepts.Arena;
import org.ziniki.core.concepts.Bench;
import org.ziniki.core.fl.IdentityOnBench;
import org.ziniki.coreimpl.ServerEnvironment;
import org.ziniki.intf.ZiId;
import org.ziniki.paas.interfaces.EntityLink;
import org.ziniki.storage.memory.BidirectionalTransport;
import org.ziniki.storage.memory.ZinikiTestInstance;
import org.ziniki.storage.memory.ZinikiTestModuleChrome;
import org.ziniki.storage.memory.ZinikiTestModuleJS;
import org.ziniki.storage.memory.ZinikiTestModuleJVM;
import org.ziniki.storage.memory.ZinikiTesterJS;
import org.ziniki.ziwsh.intf.Beachhead;
import org.ziniki.ziwsh.intf.FieldsContainerWrapper;
import org.ziniki.ziwsh.intf.JsonSender;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.InvalidUsageException;
import org.zinutils.exceptions.WrappedException;
import org.zinutils.sync.LockingCounter;

public class ZinikiTestModule {
    private final ClassLoader loader;
    private final File rootdir;
    private final LockingCounter counter;
    private final JSJavaBridge bridge;
    private final Map<String, ZinikiTestInstance> zinikis = new TreeMap<String, ZinikiTestInstance>();
    private ServerEnvironment env;

    private ZinikiTestModule(ClassLoader loader, File rootdir, TestHelper helper, LockingCounter counter, JSJavaBridge bridge) {
        this.loader = loader;
        this.rootdir = rootdir;
        this.counter = counter;
        this.bridge = bridge;
    }

    public static ZinikiTestModuleJVM createJVM(FLEnvironment env, File rootdir) {
        TestHelper helper = (TestHelper)env;
        return new ZinikiTestModuleJVM(new ZinikiTestModule(env.getLoader(), rootdir, helper, helper.getTestCounter(), null));
    }

    public static ZinikiTesterJS createJS(JSJavaBridge bridge, ClassLoader loader, File rootdir) {
        return new ZinikiTestModuleJS(new ZinikiTestModule(loader, rootdir, null, bridge.getTestCounter(), bridge));
    }

    public static ZinikiTestModuleChrome createChrome(JSJavaBridge bridge, ClassLoader loader, File rootdir, ServerEnvironment env) {
        ZinikiTestModule me = new ZinikiTestModule(loader, rootdir, null, bridge.getTestCounter(), bridge);
        me.env = env;
        ZinikiTestModuleChrome ret = new ZinikiTestModuleChrome(me);
        return ret;
    }

    public boolean hasZiniki(String name) {
        return this.zinikis.containsKey(name);
    }

    public void data(String name, String datadir) {
        ZinikiTestInstance inst = this.getZiniki(name);
        inst.data(datadir);
    }

    public void user(String ziniki, String user) {
        try {
            ZinikiTestInstance inst = this.getZiniki(ziniki);
            inst.tokenForUser(user, "tok_" + user, "secret_" + user);
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Throwable)ex);
        }
    }

    public void dump(String ziniki) {
        try {
            ZinikiTestInstance inst = this.getZiniki(ziniki);
            inst.dumpDataStore();
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Throwable)ex);
        }
    }

    public BidirectionalTransport attach(String name, String user) {
        ZinikiTestInstance inst = this.getZiniki(name);
        BidirectionalTransport trans = inst.newConnection(user, this.counter);
        try {
            if (this.bridge != null) {
                this.bridge.transport((JsonSender)trans.toZiniki);
                trans.responder.bridge(this.bridge);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
        return trans;
    }

    public void hasBench(String ziniki, String arena, String bench) throws FlasTestException {
        ZinikiTestInstance inst = this.getZiniki(ziniki);
        Object entry = inst.obtain(arena);
        if (entry == null) {
            throw new InvalidUsageException("there is no arena " + arena);
        }
        if (!(entry instanceof Arena)) {
            throw new InvalidUsageException("entity " + arena + " is not an arena or domain");
        }
        Arena a = (Arena)entry;
        if (a.bench(bench) == null) {
            throw new NotFound(bench);
        }
    }

    public void hasEntityLink(String ziniki, String benchId, String entityId) throws FlasTestException {
        ZiIdURI uri;
        ZiIdURI arenaId;
        ZinikiTestInstance inst = this.getZiniki(ziniki);
        Object entry = inst.obtain(arenaId = (uri = ZiIdURI.fromString((String)benchId)).removeLast().makeType("arena"));
        if (entry == null) {
            throw new InvalidUsageException("there is no arena " + arenaId);
        }
        if (!(entry instanceof Arena)) {
            throw new InvalidUsageException("entity " + arenaId + " is not an arena or domain");
        }
        Arena a = (Arena)entry;
        String benchName = uri.lastSegment();
        Bench bench = a.bench(benchName);
        if (bench == null) {
            throw new NotFound("bench " + benchName + " in " + arenaId);
        }
        Object entity = inst.obtain(entityId);
        if (entity == null) {
            throw new InvalidUsageException("there is no entity " + entityId);
        }
        if (inst.getLink("EntityBench", entityId, benchId) == null) {
            throw new NotFound(entityId + " on " + benchId);
        }
    }

    public void connectBeachhead(BidirectionalTransport trans, Beachhead bh) {
        if (this.bridge == null) {
            trans.responder.beachhead(bh);
        }
    }

    public void obtainDataEntry(String ziniki, String ziid, String ty, BoundVar iv) throws FlasTestException {
        ZinikiTestInstance inst = this.getZiniki(ziniki);
        Object entry = inst.obtain(ziid);
        if (entry == null) {
            throw new NotFound(ziid.toString());
        }
        if (!(entry instanceof FieldsContainerWrapper)) {
            throw new CantHappenException("I think everything should be an FCW");
        }
        FieldsContainerWrapper fcw = (FieldsContainerWrapper)entry;
        if (!ty.equals(fcw.get("_type"))) {
            throw new AssertFailed((Object)ty, fcw.get("_type"));
        }
        TreeSet toDelete = new TreeSet();
        fcw.allPlus((x, y) -> {
            if (x.startsWith("_") && !x.equals("_id") && !x.equals("_type") && !x.equals("_clz")) {
                toDelete.add(x);
            }
        });
        for (String s : toDelete) {
            fcw.clear(s);
        }
        iv.bindActual(entry);
    }

    public void obtainPersona(String ziniki, String arena, String bench, String identity, String ty, BoundVar iv) throws FlasTestException {
        ZiIdURI aid;
        ZiIdURI bid;
        ZinikiTestInstance inst = this.getZiniki(ziniki);
        EntityLink link = inst.getLink("IdentityBench", identity, (bid = (aid = ZiIdURI.fromString((String)arena)).makeType("bench").append(bench)).toString());
        if (link == null) {
            throw new NotFound(identity + " on " + (ZiId)bid);
        }
        if (link instanceof IdentityOnBench) {
            try {
                IdentityOnBench iob = (IdentityOnBench)link;
                String pid = (String)iob.fields().get("persona");
                Object entry = inst.obtain(pid);
                if (entry == null) {
                    throw new NotFound("persona with id " + pid);
                }
                if (!(entry instanceof FieldsContainerWrapper)) {
                    throw new CantHappenException("I think everything should be an FCW");
                }
                FieldsContainerWrapper fcw = (FieldsContainerWrapper)entry;
                if (!ty.equals(fcw.get("_type"))) {
                    throw new AssertFailed((Object)ty, fcw.get("_type"));
                }
                TreeSet toDelete = new TreeSet();
                fcw.allPlus((x, y) -> {
                    if (x.startsWith("_") && !x.equals("_id") && !x.equals("_type") && !x.equals("_clz")) {
                        toDelete.add(x);
                    }
                });
                for (String s : toDelete) {
                    fcw.clear(s);
                }
                iv.bindActual((Object)link);
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Throwable)ex);
            }
        } else {
            throw new RuntimeException("expected an IdentityOnBench not " + link);
        }
    }

    public ZinikiTestInstance getZiniki(String name) {
        if (this.zinikis.containsKey(name)) {
            return this.zinikis.get(name);
        }
        ZinikiTestInstance inst = new ZinikiTestInstance(this.loader, this.rootdir, name, this.counter, this.env);
        this.zinikis.put(name, inst);
        return inst;
    }
}

