/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.storage.memory;

import java.io.File;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.codehaus.jettison.json.JSONArray;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.container.FLASBroker;
import org.flasck.jvm.container.FLEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.DataStore;
import org.ziniki.cbtxstore.gls.GLUnitOfWork;
import org.ziniki.common.UOWHost;
import org.ziniki.common.ZiIdURI;
import org.ziniki.common.ZiIdURLFactory;
import org.ziniki.core.ZinikiCore;
import org.ziniki.core.concepts.Identity;
import org.ziniki.coreimpl.ServerEnvironment;
import org.ziniki.coreimpl.ZinikiClassLoader;
import org.ziniki.coreimpl.ZinikiServer;
import org.ziniki.intf.ZiId;
import org.ziniki.intf.ZiIdFactory;
import org.ziniki.openid.JVMSecurityToken;
import org.ziniki.paas.interfaces.ContentStorage;
import org.ziniki.paas.interfaces.EntityLink;
import org.ziniki.services.datastore.ZinikiDataStore;
import org.ziniki.servlet.CompleteDomain;
import org.ziniki.storage.memory.BTResponder;
import org.ziniki.storage.memory.BidirectionalTransport;
import org.ziniki.storage.memory.CountingExecutor;
import org.ziniki.storage.memory.IMContentStorage;
import org.ziniki.storage.memory.IMStorage;
import org.ziniki.storage.memory.IMTxManager;
import org.ziniki.storage.memory.TestWebSocketFinder;
import org.ziniki.tdastore.TDAStorage;
import org.ziniki.tdastore.TxManager;
import org.ziniki.tdastore.ZiidRangeConsumer;
import org.ziniki.tdastore.ZiidRangeProvider;
import org.ziniki.tdastore.gls.GLSException;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.RelationHandler;
import org.ziniki.tdastore.gls.Slot;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.tdastore.support.ThreadAwareTxManager;
import org.ziniki.tdastore.support.ThreadAwareUOW;
import org.ziniki.tdastore.support.UOWExecutor;
import org.ziniki.ziniki.ziwsh.BrokerDelegate;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.EvalContextFactory;
import org.ziniki.ziwsh.intf.HandlerNameProvider;
import org.ziniki.ziwsh.intf.WSResponder;
import org.ziniki.ziwsh.intf.WebSocketFinder;
import org.ziniki.ziwsh.intf.ZiwshBroker;
import org.ziniki.ziwsh.jvm.UUIDHandlerNameProvider;
import org.zinutils.exceptions.WrappedException;
import org.zinutils.sync.LockingCounter;
import org.zinutils.utils.FileUtils;

public class ZinikiTestInstance
implements RelationHandler,
ZiidRangeProvider {
    private static final Logger logger = LoggerFactory.getLogger((String)"ZinikiTI");
    private final ClassLoader classLoader;
    private final File rootdir;
    private final String host;
    private final LockingCounter counter;
    private final ServerEnvironment env;
    private final ZiIdFactory ziidFactory;
    private final IMStorage storage;
    private final IMContentStorage contentStore;
    private final ThreadAwareTxManager txmgr;
    private final BrokerDelegate delegate;
    private final WebSocketFinder wsf;
    private final ZinikiServer server;

    public ZinikiTestInstance(ClassLoader loader, File rootdir, String name, LockingCounter counter, ServerEnvironment env) {
        this.classLoader = loader;
        this.rootdir = rootdir;
        this.host = name;
        this.counter = counter;
        this.env = env = this.createEnv(env);
        this.ziidFactory = new ZiIdURLFactory((ZiidRangeProvider)this);
        this.storage = new IMStorage(env);
        this.contentStore = new IMContentStorage("http://localhost:18084", new JSONArray());
        ZinikiClassLoader zcl = new ZinikiClassLoader(loader, (ContentStorage)this.contentStore);
        this.storage.provideLoader(zcl);
        this.contentStore.provideLoader(zcl);
        env.provideLoader(zcl);
        this.txmgr = new IMTxManager((FLEnvironment)env, this.storage, this.contentStore, env.getUOWExec(), name, 0);
        env.provideTxMgr((TxManager)this.txmgr);
        this.delegate = new BrokerDelegate(this.ziidFactory);
        if (env.getWebSocketFinder() == null) {
            this.wsf = new TestWebSocketFinder(env.getBroker(), loader);
            env.provideWebSocketFinder(this.wsf);
        } else {
            this.wsf = env.getWebSocketFinder();
        }
        this.storage.provideWebSocketFinder(this.wsf);
        this.server = new ZinikiServer(this.ziidFactory, true);
    }

    public IMStorage getStorage() {
        return this.storage;
    }

    private ServerEnvironment createEnv(ServerEnvironment possible) {
        ServerEnvironment ret = possible != null ? possible : new ServerEnvironment();
        if (ret.getBroker() == null) {
            ret.provideBroker((ZiwshBroker)new FLASBroker((EvalContextFactory)ret));
        }
        CountingExecutor exec = new CountingExecutor(this.counter, Executors.newFixedThreadPool(5));
        CountingExecutor blocking = new CountingExecutor(this.counter, Executors.newFixedThreadPool(1));
        UOWExecutor uowexec = new UOWExecutor((Executor)exec, (Executor)blocking);
        ret.provideUOWExec(uowexec);
        ret.provideNameProvider((HandlerNameProvider)new UUIDHandlerNameProvider());
        return ret;
    }

    public void data(String datadir) {
        this.storage.loadFrom(new File(this.rootdir, datadir));
        ZinikiDataStore ds = new ZinikiDataStore(this.env.getBroker(), (TDAStorage)this.storage, this.ziidFactory, this.classLoader, this.env.getNameProvider());
        CompleteDomain cd = new CompleteDomain((TxManager)this.txmgr, this.ziidFactory, (ZinikiCore)this.server, (DataStore)ds, 0, null);
        GLUnitOfWork uow = (GLUnitOfWork)this.txmgr.newUnit();
        uow.trait(UOWHost.class, (Object)new UOWHost(this.host));
        Relation r = uow.relation((RelationHandler)this);
        cd.createDomainOnDemand((UnitOfWork)uow, r, this.host, "owner-" + this.host);
        uow.block();
        this.storage.configureDomain(this.ziidFactory, (UnitOfWork)uow, this.host, FileUtils.combine((Object[])new Object[]{this.rootdir, datadir, this.host, "domain"}));
    }

    public void tokenForUser(String user, String token, String secret) throws GLSException {
        GLUnitOfWork uow = (GLUnitOfWork)this.txmgr.newUnit();
        uow.trait(UOWHost.class, (Object)new UOWHost(this.host));
        Relation r = uow.relation((RelationHandler)this);
        r.load("user", (Object)user);
        r.load("token", (Object)token);
        r.load("secret", (Object)secret);
        this.server.newIdentity((UnitOfWork)uow, r, "id", "persona");
        r.logic("bindSecurityToken");
        uow.block();
    }

    public void bindSecurityToken(UnitOfWork uow, @Slot(value="id") Identity identity, @Slot(value="user") String user, @Slot(value="token") String token, @Slot(value="secret") String secret) {
        GLUnitOfWork cx = (GLUnitOfWork)uow;
        JVMSecurityToken st = new JVMSecurityToken((FLEvalContext)cx, token, secret);
        ZiIdURI identityID = (ZiIdURI)identity.ziid();
        st.setIdentity((ZiId)identityID);
        this.storage.bindUserID(user, new File(identityID.uri().getPath()).getName());
        this.storage.shove(this.ziidFactory.simple("security", ((UOWHost)cx.trait(UOWHost.class)).host, "token", token), st);
    }

    public BidirectionalTransport newConnection(String user, LockingCounter counter) {
        String tok = "tok_" + user;
        BidirectionalTransport trans = new BidirectionalTransport(this, counter, tok);
        BTResponder wsr = trans.responder;
        UnitOfWork uow = this.txmgr.newUnit();
        uow.trait(UOWHost.class, (Object)new UOWHost(this.host));
        String secret = "secret_" + user;
        this.delegate.open(this.wsf, (EvalContext)uow, this.host, tok, secret, (WSResponder)wsr);
        uow.enact();
        uow.waitForResult();
        return trans;
    }

    public void message(WSResponder responder, String tok, String text) {
        this.counter.lock("ziniki " + tok + " " + text);
        GLUnitOfWork uow = (GLUnitOfWork)this.txmgr.newUnit();
        uow.trait(UOWHost.class, (Object)new UOWHost(this.host));
        this.env.getUOWExec().execute((ThreadAwareUOW)uow, false, () -> {
            try {
                Relation r = uow.relation((RelationHandler)this);
                r.load("responder", (Object)responder);
                r.load("tok", (Object)tok);
                r.load("message", (Object)text);
                r.logic("handleText");
                uow.enact();
                uow.waitForResult();
            }
            catch (GLSException ex) {
                logger.error("Error processing GLS", (Throwable)ex);
            }
            finally {
                this.counter.release("ziniki " + tok + " " + text);
            }
        });
    }

    public void handleText(UnitOfWork uow, Relation r, @Slot(value="responder") WSResponder responder, @Slot(value="tok") String tok, @Slot(value="message") String text) {
        try {
            logger.info("Received text " + text + " for token " + tok);
            this.delegate.handle(this.wsf, (EvalContext)uow, this.host, tok, responder, text);
        }
        catch (Exception ex) {
            logger.error("Error handling text", (Throwable)ex);
        }
    }

    public Object obtain(Object ziid) {
        try {
            return this.storage.probe(this.env.newContext(), ziid);
        }
        catch (Throwable t) {
            throw WrappedException.wrap((Throwable)t);
        }
    }

    public ZiwshBroker getBroker() {
        return this.env.getBroker();
    }

    public WebSocketFinder getWebSocketFinder() {
        return this.wsf;
    }

    public void provideRange(ZiidRangeConsumer consumer, String scheme, String type) {
        this.env.getUOWExec().getMain().execute(() -> consumer.range("test", 769L, 10000L));
    }

    public TxManager getTxManager() {
        return this.txmgr;
    }

    public BrokerDelegate getDelegate() {
        return this.delegate;
    }

    public ZiIdFactory getFactory() {
        return this.ziidFactory;
    }

    public EntityLink getLink(String table, String hash, String range) {
        return this.storage.obtainLinkMember((FLEvalContext)this.txmgr.newUnit(), table, hash, range);
    }

    public void dumpDataStore() {
        this.storage.dump();
    }
}

