/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.storage.memory;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.flasck.jvm.ziniki.ContentObject;
import org.ziniki.paas.interfaces.UploadContent;
import org.ziniki.storage.memory.IMContentStorage;
import org.zinutils.exceptions.InvalidUsageException;

public class IMUpload
implements UploadContent {
    private final IMContentStorage cs;
    private final String key;
    private final String contentType;
    private ContentObject co;

    public IMUpload(IMContentStorage cs, String key, String contentType) {
        this.cs = cs;
        this.key = key;
        this.contentType = contentType;
    }

    public ContentObject co() {
        if (this.co == null) {
            throw new InvalidUsageException("cannot ask for object before written");
        }
        return this.co;
    }

    public OutputStream writeTo() {
        return new UploadStream();
    }

    class UploadStream
    extends ByteArrayOutputStream {
        UploadStream() {
        }

        @Override
        public void close() throws IOException {
            super.close();
            IMUpload.this.co = IMUpload.this.cs.store(IMUpload.this.key, this.toByteArray(), IMUpload.this.contentType);
        }
    }
}

