/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.storage.memory;

import com.fasterxml.jackson.core.JsonParseException;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import org.flasck.jvm.FLEvalContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.coreimpl.ServerEnvironment;
import org.ziniki.coreimpl.ZinikiClassLoader;
import org.ziniki.intf.ZiId;
import org.ziniki.intf.ZiIdFactory;
import org.ziniki.paas.interfaces.EntityLink;
import org.ziniki.storage.memory.IMLoader;
import org.ziniki.storage.memory.IMRecord;
import org.ziniki.storage.memory.IMStorageOptions;
import org.ziniki.storage.memory.LinkThing;
import org.ziniki.tdastore.NotifySubscriber;
import org.ziniki.tdastore.StorageOptions;
import org.ziniki.tdastore.TDAStorage;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.tdastore.lowlevel.ExistingRecord;
import org.ziniki.tdastore.lowlevel.TDACreateHandler;
import org.ziniki.tdastore.lowlevel.TDADeleteHandler;
import org.ziniki.tdastore.lowlevel.TDALinkHandler;
import org.ziniki.tdastore.lowlevel.TDALinkProvider;
import org.ziniki.tdastore.lowlevel.TDARetrieveHandler;
import org.ziniki.tdastore.lowlevel.TDATouchHandler;
import org.ziniki.tdastore.lowlevel.TDAUpdateHandler;
import org.ziniki.tdastore.lowlevel.TDAUpsertHandler;
import org.ziniki.tdastore.support.CommonStorage;
import org.ziniki.tdastore.support.ThreadAwareUOW;
import org.ziniki.tdastore.support.UOWExecutor;
import org.ziniki.ziwsh.intf.DessicatableHandler;
import org.ziniki.ziwsh.intf.Dessication;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.HandlerNameProvider;
import org.ziniki.ziwsh.intf.IdempotentHandler;
import org.ziniki.ziwsh.intf.Param;
import org.ziniki.ziwsh.intf.ProvideIDOnCreate;
import org.ziniki.ziwsh.intf.WebSocketFinder;
import org.ziniki.ziwsh.intf.ZiwshBroker;
import org.ziniki.ziwsh.jvm.HandlerCreator;
import org.zinutils.collections.ListMap;
import org.zinutils.collections.MapMap;
import org.zinutils.collections.SetMap;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.InvalidUsageException;
import org.zinutils.exceptions.NotImplementedException;
import org.zinutils.exceptions.WrappedException;
import org.zinutils.utils.ZUJarEntry;
import org.zinutils.utils.ZUJarFile;

public class IMStorage
extends CommonStorage
implements TDAStorage {
    static final Logger logger = LoggerFactory.getLogger((String)"ZinikiTI");
    private final Executor exec;
    private final HandlerNameProvider nameProvider;
    private final Map<String, DictEntry> dict = new TreeMap<String, DictEntry>();
    private final Map<String, String> users = new TreeMap<String, String>();
    private final MapMap<String, String, File> mys = new MapMap();
    private final ListMap<String, LinkThing> links = new ListMap();
    private final SetMap<String, Dessication> subscriptions = new SetMap();
    final ZiwshBroker broker;
    private final UOWExecutor uowexec;
    private IMLoader imloader;
    private WebSocketFinder wsf;
    ClassLoader loader;
    private HandlerCreator creator;

    public IMStorage(ServerEnvironment env) {
        this("test", (ClassLoader)env.getLoader(), env.getBroker(), env.getWebSocketFinder(), env.getUOWExec(), env.getNameProvider());
    }

    public IMStorage(@Param(value="role") String role, @Param(value="broker") ZiwshBroker ziwshBroker, @Param(value="webSocketFinder") WebSocketFinder webSocketFinder, @Param(value="uowexec") UOWExecutor uowExecutor, @Param(value="handlerNameProvider") HandlerNameProvider nameProvider) {
        this(role, ziwshBroker.getClassLoader(), ziwshBroker, webSocketFinder, uowExecutor, nameProvider);
    }

    private IMStorage(String role, ClassLoader loader, ZiwshBroker ziwshBroker, WebSocketFinder webSocketFinder, UOWExecutor uowExecutor, HandlerNameProvider nameProvider) {
        File f;
        logger.info("loader = " + loader);
        this.broker = ziwshBroker;
        this.loader = loader;
        this.wsf = webSocketFinder;
        this.uowexec = uowExecutor;
        this.exec = uowExecutor.getMain();
        this.nameProvider = nameProvider;
        this.imloader = new IMLoader(this.broker, loader, this.dict, this.mys, this.links);
        String reload = System.getProperty("org.ziniki.memory.zip");
        if (reload != null && (f = new File(reload)).isFile()) {
            this.loadFromZip(f, role);
        }
    }

    public void provideLoader(ZinikiClassLoader zcl) {
        this.loader = zcl;
        this.imloader = new IMLoader(this.broker, this.loader, this.dict, this.mys, this.links);
        if (this.wsf != null) {
            this.creator = new HandlerCreator(this.wsf, this.broker.getDispatcher(), this.broker, this.loader, this.nameProvider);
        }
    }

    public void provideWebSocketFinder(WebSocketFinder wsf) {
        this.wsf = wsf;
        if (this.loader != null) {
            this.creator = new HandlerCreator(wsf, this.broker.getDispatcher(), this.broker, this.loader, this.nameProvider);
        }
    }

    public void loadFrom(File datadir) {
        if (!datadir.isDirectory()) {
            return;
        }
        this.imloader.loadFrom(datadir);
    }

    public void configureDomain(ZiIdFactory ziidFactory, UnitOfWork uow, String domain, File domainFile) {
        try {
            if (domainFile.exists()) {
                this.imloader.configureDomain(ziidFactory, uow, domain, domainFile);
            }
        }
        catch (Throwable t) {
            throw WrappedException.wrap((Throwable)t);
        }
    }

    public void bindUserID(String user, String id) {
        try {
            this.users.put(user, id);
            if (this.mys.contains((Object)user)) {
                for (String s : this.mys.key2Set((Object)user)) {
                    File f = (File)this.mys.get((Object)user, (Object)s);
                    String key = s + "/" + id;
                    String fc = this.imloader.readObject(f);
                    this.dict.put(key, new DictEntry(fc));
                }
            }
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Throwable)ex);
        }
    }

    private void loadFromZip(File f, String role) {
        logger.info("Loading IMStorage from " + f + " for role " + role);
        ZUJarFile jf = new ZUJarFile(f);
        for (ZUJarEntry p : jf) {
            if (!p.getName().startsWith(role + "/")) continue;
            String name = p.getName().substring(p.getName().indexOf(47) + 1);
            logger.info("  loading " + name);
            try {
                this.dict.put(name, new DictEntry(new String(p.getBytes(), "UTF-8")));
            }
            catch (UnsupportedEncodingException e) {
                logger.error("  failed to load " + name);
            }
        }
    }

    public void retrieve(UnitOfWork uow, String id, TDARetrieveHandler h) {
        if (id == null) {
            throw new CantHappenException("id is null in retrieve");
        }
        this.exec.execute(() -> {
            if (this.dict.containsKey(id)) {
                Object ret;
                DictEntry entry = this.dict.get(id);
                try {
                    ret = this.imloader.inflate((EvalContext)uow, entry.json);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.out);
                    h.error((Throwable)ex);
                    return;
                }
                if (ret instanceof ProvideIDOnCreate) {
                    ((ProvideIDOnCreate)ret).provideID(id);
                }
                h.found(new IMRecord<Object>(ret, entry.version));
            } else {
                h.notfound();
            }
        });
    }

    public void create(UnitOfWork uow, String id, Object obj, StorageOptions options, TDACreateHandler h) {
        this.exec.execute(() -> {
            Map<String, DictEntry> map = this.dict;
            synchronized (map) {
                if (this.dict.containsKey(id)) {
                    h.alreadyExists();
                } else {
                    if (obj instanceof ProvideIDOnCreate) {
                        ((ProvideIDOnCreate)obj).provideID(id);
                    }
                    try {
                        this.dict.put(id, new DictEntry(this.imloader.flatten(obj)));
                        logger.info("id = " + id + " obj = " + this.dict.get(id));
                    }
                    catch (Exception ex) {
                        h.error((Throwable)ex);
                        return;
                    }
                    h.success();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void update(UnitOfWork uow, String id, ExistingRecord cas, Object obj, TDAUpdateHandler h) {
        ThreadAwareUOW gu = (ThreadAwareUOW)uow;
        IMRecord rec = (IMRecord)cas;
        logger.info("Updating with current version expected to be " + rec.getVersion());
        Map<String, DictEntry> map = this.dict;
        synchronized (map) {
            if (!this.dict.containsKey(id)) {
                this.uowexec.execute(gu, false, () -> h.error((Throwable)new InvalidUsageException("there is no object " + id + " to update")));
                return;
            }
            DictEntry de = this.dict.get(id);
            if (de.version != rec.getVersion()) {
                logger.info("mismatched version; is now " + de.version);
                this.uowexec.execute(gu, false, () -> h.sinceChanged());
                return;
            }
            try {
                this.dict.put(id, new DictEntry(de.version, this.imloader.flatten(obj)));
                logger.info("updated " + id + " to " + this.dict.get(id));
                this.uowexec.execute(gu, false, () -> h.updated());
            }
            catch (Throwable t) {
                this.uowexec.execute(gu, false, () -> h.error(t));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(UnitOfWork uow, String id, TDADeleteHandler h) {
        ThreadAwareUOW gu = (ThreadAwareUOW)uow;
        Map<String, DictEntry> map = this.dict;
        synchronized (map) {
            if (!this.dict.containsKey(id)) {
                this.uowexec.execute(gu, false, () -> h.error((Throwable)new InvalidUsageException("there is no object " + id + " to delete")));
                return;
            }
            this.dict.remove(id);
            this.uowexec.execute(gu, false, () -> h.success());
        }
    }

    public void upsert(UnitOfWork uow, String id, Object obj, TDAUpsertHandler h) {
        logger.info("requested upsert of " + id);
        this.exec.execute(() -> {
            Map<String, DictEntry> map = this.dict;
            synchronized (map) {
                try {
                    long version = 0L;
                    if (this.dict.containsKey(id)) {
                        version = this.dict.get((Object)id).version;
                    }
                    this.dict.put(id, new DictEntry(version, this.imloader.flatten(obj)));
                    logger.info("id = " + id + " obj = " + this.dict.get(id));
                }
                catch (Exception ex) {
                    h.error((Throwable)ex);
                    return;
                }
                h.success();
            }
        });
    }

    public void touch(UnitOfWork uow, String id, StorageOptions options, TDATouchHandler h) {
        throw new NotImplementedException("touch " + id);
    }

    public StorageOptions storageOptions() {
        return new IMStorageOptions();
    }

    public void shove(ZiId simple, Object obj) {
        try {
            String id = simple.toString();
            this.dict.put(id, new DictEntry(this.imloader.flatten(obj)));
            logger.info("id = " + id + " obj = " + this.dict.get(id));
        }
        catch (Exception ex) {
            System.out.println("Failed");
            ex.printStackTrace(System.out);
        }
    }

    public String getJson(String key) {
        if (!this.dict.containsKey(key)) {
            return null;
        }
        return this.dict.get((Object)key).json;
    }

    public Object probe(EvalContext uow, Object ziid) throws JsonParseException, ClassNotFoundException, IOException {
        String id = ziid.toString();
        if (!this.dict.containsKey(id)) {
            logger.info("cannot find " + ziid + " in dict, keys are: " + this.dict.keySet());
            throw new InvalidUsageException("there is no entry " + ziid);
        }
        return this.imloader.inflate(uow, this.dict.get((Object)id).json);
    }

    public void link(UnitOfWork uow, EntityLink link, TDALinkHandler h) {
        logger.info("Want to create link on " + link.table());
        this.exec.execute(() -> {
            logger.info("Creating link on " + link.table());
            ListMap<String, LinkThing> listMap = this.links;
            synchronized (listMap) {
                try {
                    this.links.add((Object)link.table(), (Object)new LinkThing(link.table(), link.hash(), link.range(), this.imloader.flatten(link)));
                }
                catch (IOException | ClassNotFoundException e) {
                    logger.error("could not flatten link" + link, (Throwable)e);
                }
            }
            h.success();
        });
    }

    public void links(UnitOfWork uow, String table, String hash, TDALinkProvider h) {
        if (table == null) {
            throw new CantHappenException("table is null in links");
        }
        if (hash == null) {
            throw new CantHappenException("hash is null in links");
        }
        this.exec.execute(() -> {
            List list = new ArrayList();
            ListMap<String, LinkThing> listMap = this.links;
            synchronized (listMap) {
                if (this.links.contains((Object)table)) {
                    list = this.links.get((Object)table);
                }
            }
            for (LinkThing l : list) {
                if (!l.hash(hash)) continue;
                try {
                    h.next((EntityLink)this.imloader.inflate((EvalContext)uow, l.json));
                }
                catch (IOException | ClassNotFoundException e) {
                    logger.error("could not inflate link" + l.json, (Throwable)e);
                }
            }
            h.complete();
        });
    }

    public void subscribe(UnitOfWork uow, String id, IdempotentHandler ih) {
        Dessication dess = ((DessicatableHandler)ih)._dessication();
        if (dess == null) {
            logger.info("null dessication, so does not want to subscribe");
            return;
        }
        logger.info("want to subscribe to " + id + " with " + ih + " stored as " + dess);
        this.subscriptions.add((Object)id, (Object)dess);
        logger.info("subscriptions = " + this.subscriptions);
    }

    public void unsubscribe(UnitOfWork uow, String id, IdempotentHandler ih) {
        throw new NotImplementedException();
    }

    public void notifySubscribers(UnitOfWork uow, String id, NotifySubscriber ns) {
        logger.error("want to notify about " + id + " with current subscriptions " + this.subscriptions);
        if (!this.subscriptions.contains((Object)id)) {
            logger.debug("there is no key " + id);
            return;
        }
        Set subs = this.subscriptions.get((Object)id);
        logger.info("subs = " + subs);
        for (Dessication s : subs) {
            try {
                logger.info("need to notify " + s);
                ns.tellSubscriber(uow, id, this.creator.hydrate(s));
            }
            catch (Exception ex) {
                logger.error("Could not notify " + s, (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> allKeys() {
        Map<String, DictEntry> map = this.dict;
        synchronized (map) {
            return new TreeSet<String>(this.dict.keySet());
        }
    }

    public EntityLink obtainLinkMember(FLEvalContext cx, String table, String hash, String range) {
        if (!this.links.contains((Object)table)) {
            return null;
        }
        for (LinkThing lt : this.links.get((Object)table)) {
            if (!lt.matches(hash, range)) continue;
            try {
                return (EntityLink)this.imloader.inflate((EvalContext)cx, lt.json);
            }
            catch (IOException | ClassNotFoundException e) {
                logger.error("could not inflate link" + lt.json, (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump() {
        Map<String, DictEntry> map = this.dict;
        synchronized (map) {
            System.out.println("Entities");
            for (Map.Entry<String, DictEntry> e : this.dict.entrySet()) {
                System.out.println("  " + e.getKey() + " => " + e.getValue());
            }
            for (String l : this.links) {
                System.out.println("Links " + l);
                for (LinkThing le : this.links.get((Object)l)) {
                    System.out.println("  " + le);
                }
            }
            System.out.println("Subscriptions");
            for (String to : this.subscriptions) {
                System.out.println("  " + to);
                for (Dessication h : this.subscriptions.get((Object)to)) {
                    System.out.println("    " + h);
                }
            }
        }
    }

    public static class DictEntry {
        long version;
        String json;

        public DictEntry(String json) {
            this.version = 1L;
            this.json = json;
        }

        public DictEntry(long version, String json) {
            this.version = version + 1L;
            this.json = json;
        }

        public String toString() {
            return "Record[" + this.version + ":" + this.json + "]";
        }
    }
}

