/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.storage.memory;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.TreeMap;
import org.flasck.jvm.ziniki.ContentObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.paas.interfaces.PAASContext;
import org.ziniki.storage.memory.IMContentStorage;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.ObjectMarshalling;
import org.ziniki.ziwsh.intf.Wireable;

public class IMCSObject
implements ContentObject,
Wireable {
    public static final Logger logger = LoggerFactory.getLogger((String)"ZinikiTI");
    private final IMContentStorage cs;
    private final String key;
    private final String contentType;
    private final byte[] bs;

    public IMCSObject(IMContentStorage cs, String key, String contentType, byte[] bs) {
        this.cs = cs;
        this.key = key;
        this.contentType = contentType;
        this.bs = bs;
    }

    public String key() {
        return this.key;
    }

    public String url() {
        return this.cs.url(this.key).toString();
    }

    public String writeUrl() {
        return this.cs.writeUrl(this.key).toString();
    }

    public long length() {
        return this.bs.length;
    }

    public String asString() {
        try {
            return new String(this.bs, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            logger.error("No UTF-8", (Throwable)ex);
            return "";
        }
    }

    public byte[] asByteArray() {
        return this.bs;
    }

    public InputStream asStream() {
        return new ByteArrayInputStream(this.bs);
    }

    public Map<String, Object> fields() throws IOException {
        TreeMap<String, Object> ret = new TreeMap<String, Object>();
        ret.put("_wireable", "contentObject");
        ret.put("key", this.key);
        ret.put("publicGet", this.cs.publicUrl(this.key));
        ret.put("publicPut", this.cs.publicWriteTo(this.key));
        return ret;
    }

    public static IMCSObject fromWire(EvalContext cx, ObjectMarshalling om, Map<String, Object> args) {
        IMContentStorage cs = (IMContentStorage)((PAASContext)cx).getContentStore();
        return cs.get((String)args.get("key"));
    }

    public String contentType() {
        return this.contentType;
    }
}

