/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.storage.memory;

import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.server.tda.ProvideHostInfo;
import org.ziniki.server.tda.RequestMethod;
import org.ziniki.servlet.tda.ParameterSource;
import org.ziniki.servlet.tda.RequestProcessor;
import org.ziniki.servlet.tda.RequestQueryAndPostParameters;
import org.ziniki.servlet.tda.Responder;
import org.ziniki.storage.memory.IMStorage;
import org.ziniki.ziwsh.intf.Param;

public class GetSerializedObject
implements RequestProcessor,
RequestMethod,
ProvideHostInfo,
RequestQueryAndPostParameters {
    private static final Logger logger = LoggerFactory.getLogger((String)"ZinikiTI");
    private final IMStorage zinikiStorage;
    private String method;
    private String type;
    private String domain;
    private String path;

    public GetSerializedObject(@Param(value="zinikiStorage") IMStorage zinikiStorage) {
        this.zinikiStorage = zinikiStorage;
    }

    public void requestMethod(String methodName) {
        this.method = methodName;
    }

    public void provideHost(String name, int port) {
        this.domain = name.replaceFirst("ziniki.", "");
    }

    public void stringValue(String name, String value, ParameterSource source) {
        if ("type".equals(name)) {
            this.type = value;
        } else if ("path".equals(name)) {
            this.path = value;
        }
    }

    public void process(Responder r) throws Exception {
        if (!"GET".equals(this.method)) {
            r.setStatus(405);
            r.done();
            return;
        }
        URIBuilder uri = new URIBuilder();
        uri.setScheme(this.type);
        uri.setHost(this.domain);
        uri.setPath(this.path);
        logger.info("Retrieving " + uri);
        String json = this.zinikiStorage.getJson(uri.toString());
        if (json == null) {
            r.setStatus(404);
            r.write("no entry found for " + uri, null);
        } else {
            r.setStatus(200);
            r.write(json, null);
        }
        r.done();
    }
}

