/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.storage.memory;

import java.net.URLEncoder;
import org.codehaus.jettison.json.JSONObject;
import org.ziniki.common.UOWHost;
import org.ziniki.intf.ZiId;
import org.ziniki.intf.ZiIdFactory;
import org.ziniki.openid.GLSSecurityStore;
import org.ziniki.openid.JVMSecurityToken;
import org.ziniki.server.tda.ProvideHostInfo;
import org.ziniki.server.tda.RequestMethod;
import org.ziniki.servlet.tda.ParameterSource;
import org.ziniki.servlet.tda.RequestProcessor;
import org.ziniki.servlet.tda.RequestQueryAndPostParameters;
import org.ziniki.servlet.tda.Responder;
import org.ziniki.storage.memory.IMStorage;
import org.ziniki.tdastore.TxManager;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.ziwsh.intf.Param;

public class FakeLogin
implements RequestProcessor,
RequestMethod,
ProvideHostInfo,
RequestQueryAndPostParameters {
    private final ZiIdFactory factory;
    private final TxManager txmgr;
    private final IMStorage zinikiStorage;
    private final GLSSecurityStore store;
    private String method;
    private String cred;
    private String domain;

    public FakeLogin(@Param(value="factory") ZiIdFactory factory, @Param(value="txmgr") TxManager txmgr, @Param(value="zinikiStorage") IMStorage zinikiStorage, @Param(value="securityStore") GLSSecurityStore store) {
        this.factory = factory;
        this.txmgr = txmgr;
        this.zinikiStorage = zinikiStorage;
        this.store = store;
    }

    public void requestMethod(String methodName) {
        this.method = methodName;
    }

    public void provideHost(String name, int port) {
        this.domain = name.replaceFirst("ziniki.", "");
    }

    public void stringValue(String name, String value, ParameterSource source) {
        if ("cred".equals(name)) {
            this.cred = value;
        }
    }

    public void process(Responder r) throws Exception {
        boolean success;
        if (!"POST".equals(this.method)) {
            r.setStatus(405);
            r.done();
            return;
        }
        if (this.cred == null) {
            r.setStatus(400);
            r.write("must specify cred", null);
            r.done();
            return;
        }
        ZiId id = this.factory.simple("security", this.domain, "credential", URLEncoder.encode(this.cred, "UTF-8"));
        String json = this.zinikiStorage.getJson(id.toString());
        boolean bl = success = json != null;
        if (success) {
            UnitOfWork uow = this.txmgr.newUnit();
            uow.trait(UOWHost.class, (Object)new UOWHost(this.domain));
            Relation rel = uow.relation(null);
            this.store.generateNewToken(uow, rel);
            uow.block();
            JVMSecurityToken tok = (JVMSecurityToken)rel.obtain(JVMSecurityToken.class, "as_token");
            r.setStatus(200);
            JSONObject jo = new JSONObject();
            jo.put("token", (Object)tok.getToken());
            jo.put("secret", (Object)tok.getSecret());
            r.write(jo.toString(), null);
        } else {
            r.setStatus(401);
            r.write("there is no credential " + this.cred, null);
        }
        r.done();
    }
}

