/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.storage.memory;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.server.tda.RequestMethod;
import org.ziniki.servlet.tda.NotReadyException;
import org.ziniki.servlet.tda.RequestProcessor;
import org.ziniki.servlet.tda.Responder;
import org.ziniki.servlet.tda.ResponseReadyContinuation;
import org.ziniki.storage.memory.IMCSObject;
import org.ziniki.storage.memory.IMContentStorage;
import org.ziniki.storage.memory.IMStorage;
import org.ziniki.ziwsh.intf.Param;

public class DumpContents
implements RequestProcessor,
RequestMethod {
    private static final Logger logger = LoggerFactory.getLogger((String)"ZinikiTI");
    private final IMStorage authStorage;
    private final IMStorage zinikiStorage;
    private final IMContentStorage contentStore;
    private String method;

    public DumpContents(@Param(value="authStorage") IMStorage authStorage, @Param(value="zinikiStorage") IMStorage zinikiStorage, @Param(value="contentStore") IMContentStorage contentStore) {
        this.authStorage = authStorage;
        this.zinikiStorage = zinikiStorage;
        this.contentStore = contentStore;
    }

    public void requestMethod(String methodName) {
        this.method = methodName;
    }

    public void process(Responder r) throws Exception {
        if (!"GET".equals(this.method)) {
            r.setStatus(405);
            r.done();
            return;
        }
        Set<String> authKeys = this.authStorage.allKeys();
        logger.info("auth keys = " + authKeys);
        this.write(r, "auth", authKeys.iterator());
        Set<String> allKeys = this.zinikiStorage.allKeys();
        logger.info("zin keys = " + allKeys);
        this.write(r, "zin", allKeys.iterator());
        Set<String> allContentKeys = this.contentStore.allKeys();
        logger.info("content = " + allContentKeys);
        ArrayList<CallSite> ctinfo = new ArrayList<CallSite>();
        for (String s : allContentKeys) {
            IMCSObject co = this.contentStore.get(s);
            ctinfo.add((CallSite)((Object)(s + ": " + co.asByteArray().length)));
        }
        this.write(r, "content", ctinfo.iterator());
        r.setStatus(200);
        r.done();
    }

    private void write(final Responder r, final String source, final Iterator<String> it) throws IOException, NotReadyException {
        while (it.hasNext() && r.write(source + " " + it.next() + "\n", new ResponseReadyContinuation(){

            public boolean responseReady() throws IOException, NotReadyException {
                DumpContents.this.write(r, source, it);
                return true;
            }

            public void streamError(Throwable err) {
                r.done();
            }
        })) {
        }
    }
}

