/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.storage.memory;

import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.server.tda.RequestMethod;
import org.ziniki.servlet.tda.BodyChunkHandler;
import org.ziniki.servlet.tda.BodyFlowControl;
import org.ziniki.servlet.tda.NotReadyException;
import org.ziniki.servlet.tda.ParameterSource;
import org.ziniki.servlet.tda.RequestPathParameters;
import org.ziniki.servlet.tda.RequestProcessor;
import org.ziniki.servlet.tda.Responder;
import org.ziniki.storage.memory.IMCSObject;
import org.ziniki.storage.memory.IMContentStorage;
import org.ziniki.ziwsh.intf.Param;

public class DeliverContent
implements RequestProcessor,
RequestMethod,
RequestPathParameters,
BodyChunkHandler {
    public static final Logger logger = LoggerFactory.getLogger((String)"ZinikiTI");
    private final IMContentStorage contentStore;
    private String method;
    private String key;
    private Responder r;
    private OutputStream upload;
    private boolean writeOK;

    public DeliverContent(@Param(value="contentStore") IMContentStorage contentStore) {
        this.contentStore = contentStore;
    }

    public void requestMethod(String methodName) {
        this.method = methodName;
    }

    public void stringValue(String name, String value, ParameterSource source) {
        this.key = value;
        if (this.key.startsWith("/")) {
            this.key = this.key.substring(1);
        }
    }

    public void process(Responder r) throws Exception {
        logger.info("ContentStore " + this.method + " " + this.key);
        if ("GET".equals(this.method)) {
            this.deliver(r);
        } else if ("PUT".equals(this.method)) {
            this.upload(r);
        } else {
            logger.error("rejecting because not GET or PUT");
            r.setStatus(405);
            r.done();
            return;
        }
    }

    private void deliver(Responder r) throws IOException, NotReadyException {
        IMCSObject co = this.contentStore.get(this.key);
        if (co == null) {
            r.setStatus(404);
        } else {
            r.setStatus(200);
            r.setContentType(co.contentType());
            byte[] bs = co.asByteArray();
            r.write(bs, 0, bs.length, null);
        }
        r.done();
    }

    private void upload(Responder r) throws IOException {
        this.r = r;
        this.upload = this.contentStore.upload(this.key, "text/json").writeTo();
        this.writeOK = true;
    }

    public void hasSegment(String segment) {
    }

    public void integerValue(String name, int value, ParameterSource source) {
    }

    public void doubleValue(String name, double value, ParameterSource source) {
    }

    public void chunk(byte[] bs, int off, int len, BodyFlowControl flow) {
        if (this.upload != null && this.writeOK) {
            try {
                this.upload.write(bs, off, len);
            }
            catch (IOException ex) {
                this.writeOK = false;
            }
        }
    }

    public void bodyDone() {
        if (this.upload != null && this.r != null) {
            try {
                this.upload.close();
            }
            catch (IOException e) {
                this.writeOK = false;
            }
            this.r.setStatus(this.writeOK ? 200 : 500);
            this.r.done();
        }
    }
}

