/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.storage.memory;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.testrunner.JSJavaBridge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.ziwsh.intf.Beachhead;
import org.ziniki.ziwsh.intf.NamedJsonSender;
import org.ziniki.ziwsh.intf.WSResponder;
import org.zinutils.exceptions.NotImplementedException;

public class BTResponder
implements WSResponder,
NamedJsonSender {
    public final Logger jsonLogger = LoggerFactory.getLogger((String)"ZininiZiwsh");
    public final Logger logger = LoggerFactory.getLogger((String)"BTResponder");
    private Beachhead jb;
    private JSJavaBridge bridge;
    private String tok;
    private final List<String> queue = new ArrayList<String>();
    private WSResponder replyTo;

    public BTResponder(String tok) {
        this.tok = tok;
    }

    public void setReplyTo(WSResponder toZiniki) {
        this.replyTo = toZiniki;
    }

    public void setDessication(String token) {
        this.tok = token;
    }

    public String dessicated() {
        return this.tok;
    }

    public String name() {
        return this.tok;
    }

    public void send(String json) {
        this.jsonLogger.info("Z -> " + json);
        if (this.jb != null) {
            this.jb.dispatch(null, json, this.replyTo);
        } else if (this.bridge != null) {
            this.bridge.sendJson(json);
        } else {
            this.logger.info("there is no configured client to send " + json + " ... queuing");
            this.queue.add(json);
        }
    }

    public URI connectionName() {
        throw new NotImplementedException();
    }

    public void close(String reason) {
        throw new NotImplementedException();
    }

    public String toString() {
        return "BiTrans[" + this.tok + "]";
    }

    public void beachhead(Beachhead beachhead) {
        this.logger.info("attaching beachhead " + beachhead + " to " + this);
        this.jb = beachhead;
        for (String s : this.queue) {
            this.jb.dispatch(null, s, this.replyTo);
        }
    }

    public void bridge(JSJavaBridge bridge) {
        this.bridge = bridge;
        for (String s : this.queue) {
            this.bridge.sendJson(s);
        }
    }
}

