/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.awstxstore;

import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.awstxstore.DynamoCollector;
import org.ziniki.awstxstore.DynamoHelper;
import org.ziniki.awstxstore.DynamoMarshaller;
import org.ziniki.ziwsh.intf.FieldsContainerWrapper;
import org.ziniki.ziwsh.intf.FieldsMarshaller;
import org.zinutils.exceptions.CantHappenException;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class DynamoFieldsMarshaller
extends DynamoMarshaller
implements FieldsMarshaller {
    public static final Logger logger = LoggerFactory.getLogger((String)"awstxstore");
    private String cfield;
    private DynamoCollector parent;
    private Map<String, AttributeValue> values = new TreeMap<String, AttributeValue>();

    public DynamoFieldsMarshaller(DynamoCollector parent, Class<? extends FieldsContainerWrapper> clz) {
        this.parent = parent;
        DynamoHelper.put(this.values, "_clz", clz.getName());
    }

    public void field(String x) {
        this.cfield = x;
    }

    @Override
    public void collect(Object o) {
        if (this.cfield == null) {
            throw new CantHappenException("field collect called without field name");
        }
        if (o != null) {
            DynamoHelper.put(this.values, this.cfield, o);
        }
        this.cfield = null;
    }

    @Override
    public void complete() {
        if (this.parent != null) {
            this.parent.collect(DynamoHelper.attr(this.values));
        }
    }
}

