/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.awstxstore;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.awstxstore.DynamoHelper;
import org.ziniki.ziwsh.intf.CollectionState;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.FieldsMarshaller;
import org.ziniki.ziwsh.intf.MarshallingTraverser;
import org.ziniki.ziwsh.intf.ObjectMarshalling;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.NotImplementedException;
import org.zinutils.exceptions.WrappedException;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class DynamoExtractor {
    public static final Logger logger = LoggerFactory.getLogger((String)"awstxstore");
    private final ClassLoader classLoader;

    public DynamoExtractor(ClassLoader classLoader) {
        this.classLoader = classLoader;
        if (classLoader == null) {
            throw new CantHappenException("Must provide a valid classLoader");
        }
    }

    public void unmarshal(EvalContext cx, MarshallingTraverser ux, AttributeValue a) throws ClassNotFoundException {
        if (a.s() != null) {
            ux.string(a.s());
        } else if (a.bool() != null) {
            ux.bool(a.bool());
        } else if (a.n() != null) {
            ux.real(Double.valueOf(Double.parseDouble(a.n())));
        } else if (a.hasL()) {
            this.unmarshalList(cx, ux, a.l());
        } else if (a.hasM()) {
            this.unmarshalMap(cx, ux, a.m());
        } else {
            throw new NotImplementedException("unmarshal " + a);
        }
    }

    public void unmarshalMap(EvalContext cx, MarshallingTraverser ux, Map<String, AttributeValue> m) throws ClassNotFoundException {
        logger.debug("unmarshalMap, m = " + m);
        AttributeValue clzav = m.get("_clz");
        if (clzav == null) {
            MarshallingTraverser fm = ux.beginMap();
            ux.unpack(fm.collectingAs());
            for (Map.Entry<String, AttributeValue> e : m.entrySet()) {
                ux.string(e.getKey());
                this.unmarshal(cx, fm, e.getValue());
            }
            fm.complete();
        } else {
            String clzName = clzav.s();
            if (clzName.startsWith("_")) {
                this.handleSpecialClass(cx, ux, clzName, m);
                return;
            }
            Class<?> clz = Class.forName(clzName, false, this.classLoader);
            FieldsMarshaller fm = ux.beginFields(clz);
            ux.unpack(fm.collectingAs());
            for (Map.Entry<String, AttributeValue> e : m.entrySet()) {
                fm.field(e.getKey());
                this.unmarshal(cx, (MarshallingTraverser)fm, e.getValue());
            }
            fm.complete();
        }
    }

    private void unmarshalList(EvalContext cx, MarshallingTraverser ux, List<AttributeValue> l) throws ClassNotFoundException {
        MarshallingTraverser lm = ux.beginList();
        ux.unpack(lm.collectingAs());
        for (AttributeValue a : l) {
            this.unmarshal(cx, lm, a);
        }
    }

    private void handleSpecialClass(EvalContext cx, MarshallingTraverser ux, String clzName, Map<String, AttributeValue> m) throws ClassNotFoundException {
        switch (clzName) {
            case "_javaDate": {
                long d = Long.parseLong(m.get("unixtime").n()) * 1000L;
                ux.date(new Date(d));
                break;
            }
            case "_wireable": {
                try {
                    TreeMap<String, Object> fields = new TreeMap<String, Object>();
                    for (Map.Entry<String, AttributeValue> e : m.entrySet()) {
                        fields.put(e.getKey(), DynamoHelper.extract(e.getValue()));
                    }
                    OMWrapper omw = new OMWrapper(cx, ux);
                    ux.wireable((ObjectMarshalling)omw, cx.fromWire(this.classLoader, (ObjectMarshalling)omw, fields));
                    break;
                }
                catch (Exception ex) {
                    logger.error("error", (Throwable)ex);
                    throw WrappedException.wrap((Throwable)ex);
                }
            }
            default: {
                throw new NotImplementedException("There is no special case for " + clzName);
            }
        }
    }

    public class OMWrapper
    implements ObjectMarshalling {
        private final EvalContext cx;
        private final MarshallingTraverser ux;

        public OMWrapper(EvalContext cx, MarshallingTraverser ux) {
            this.cx = cx;
            this.ux = ux;
        }

        public CollectionState state() {
            return this.ux.state();
        }

        public void marshal(Object o) throws ClassNotFoundException {
            DynamoExtractor.this.unmarshal(this.cx, this.ux, (AttributeValue)o);
        }

        public void marshal(MarshallingTraverser ux, Object o) throws ClassNotFoundException {
            DynamoExtractor.this.unmarshal(this.cx, ux, (AttributeValue)o);
        }
    }
}

