/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.awstxstore;

import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.awstxstore.AWSCreatedObject;
import org.ziniki.awstxstore.AWSTxStorageOptions;
import org.ziniki.awstxstore.AWSUOW;
import org.ziniki.awstxstore.DynamoExtractor;
import org.ziniki.awstxstore.DynamoHelper;
import org.ziniki.awstxstore.DynamoRetrievedObject;
import org.ziniki.awstxstore.DynamoTopLevelMarshaller;
import org.ziniki.awstxstore.VersionHolder;
import org.ziniki.cbtxstore.gls.GLUnitOfWork;
import org.ziniki.paas.interfaces.EntityLink;
import org.ziniki.tdastore.NotifySubscriber;
import org.ziniki.tdastore.StorageOptions;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.tdastore.lowlevel.ExistingRecord;
import org.ziniki.tdastore.lowlevel.RetrievedObject;
import org.ziniki.tdastore.lowlevel.TDACreateHandler;
import org.ziniki.tdastore.lowlevel.TDADeleteHandler;
import org.ziniki.tdastore.lowlevel.TDALinkHandler;
import org.ziniki.tdastore.lowlevel.TDALinkProvider;
import org.ziniki.tdastore.lowlevel.TDARetrieveHandler;
import org.ziniki.tdastore.lowlevel.TDATouchHandler;
import org.ziniki.tdastore.lowlevel.TDAUpdateHandler;
import org.ziniki.tdastore.lowlevel.TDAUpsertHandler;
import org.ziniki.tdastore.support.CommonStorage;
import org.ziniki.tdastore.support.ThreadAwareUOW;
import org.ziniki.tdastore.support.UOWExecutor;
import org.ziniki.ziwsh.intf.CollectionState;
import org.ziniki.ziwsh.intf.DessicatableHandler;
import org.ziniki.ziwsh.intf.Dessication;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.HandlerNameProvider;
import org.ziniki.ziwsh.intf.IdempotentHandler;
import org.ziniki.ziwsh.intf.MarshallingTraverser;
import org.ziniki.ziwsh.intf.Param;
import org.ziniki.ziwsh.intf.ProvideIDOnCreate;
import org.ziniki.ziwsh.intf.WebSocketFinder;
import org.ziniki.ziwsh.intf.ZiwshBroker;
import org.ziniki.ziwsh.jvm.CollectingState;
import org.ziniki.ziwsh.jvm.DessicatedHandler;
import org.ziniki.ziwsh.jvm.HandlerCreator;
import org.ziniki.ziwsh.jvm.ListTraverser;
import org.ziniki.ziwsh.jvm.ObjectMarshaller;
import org.zinutils.exceptions.InvalidUsageException;
import org.zinutils.exceptions.NotImplementedException;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClientBuilder;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ConditionalCheckFailedException;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.PutItemResponse;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;

public class AWSTxStorage
extends CommonStorage {
    public static final Logger logger = LoggerFactory.getLogger((String)"awstxstore");
    private WebSocketFinder wsf;
    private final ZiwshBroker broker;
    private final UOWExecutor uowexec;
    private final HandlerNameProvider nameProvider;
    private final DynamoDbAsyncClient db;
    private final String entities;
    private final String subscriptions;
    private ClassLoader classLoader;
    private HandlerCreator creator;
    private final Map<String, TableDefn> tables = new TreeMap<String, TableDefn>();

    public AWSTxStorage(@Param(value="broker") ZiwshBroker ziwshBroker, @Param(value="uowexec") UOWExecutor uowexec, @Param(value="table") String tablePrefix, @Param(value="handlerNameProvider") HandlerNameProvider nameProvider) {
        this.broker = ziwshBroker;
        this.uowexec = uowexec;
        this.nameProvider = nameProvider;
        for (DynamoHelper.DynamoTableDefn d : DynamoHelper.dynamoTables) {
            this.tables.put(d.table, new TableDefn(tablePrefix + d.table, d));
        }
        this.entities = tablePrefix + "Entities";
        this.subscriptions = tablePrefix + "Subscriptions";
        DefaultCredentialsProvider credentialsProvider = DefaultCredentialsProvider.create();
        this.db = (DynamoDbAsyncClient)((DynamoDbAsyncClientBuilder)((DynamoDbAsyncClientBuilder)DynamoDbAsyncClient.builder().credentialsProvider((AwsCredentialsProvider)credentialsProvider)).region(Region.US_EAST_1)).build();
    }

    public void provideLoader(ClassLoader loader) {
        this.classLoader = loader;
        if (this.wsf != null) {
            this.creator = new HandlerCreator(this.wsf, this.broker.getDispatcher(), this.broker, loader, this.nameProvider);
        }
        logger.debug("have stored loader " + loader + " in " + this + " wsf = " + this.wsf + " creator = " + this.creator);
    }

    public void provideWebSocketFinder(WebSocketFinder finder) {
        this.wsf = finder;
        if (this.classLoader != null) {
            this.creator = new HandlerCreator(this.wsf, this.broker.getDispatcher(), this.broker, this.classLoader, this.nameProvider);
        }
        logger.debug("have stored wsf " + this.wsf + " in " + this + " loader = " + this.classLoader + " creator = " + this.creator);
    }

    public void retrieve(UnitOfWork uow, String id, TDARetrieveHandler h) {
        GLUnitOfWork gu = (GLUnitOfWork)uow;
        GetItemRequest request = DynamoHelper.key(this.entities, "key", id, new String[0]);
        CompletableFuture have = this.db.getItem(request);
        have.thenAccept(gr -> {
            Map ret = gr.item();
            if (ret == null || ret.isEmpty()) {
                logger.warn("request for " + id + " returned " + ret + " which counts as not found");
                this.uowexec.execute((ThreadAwareUOW)gu, false, () -> h.notfound());
            } else {
                DynamoRetrievedObject retr;
                try {
                    AttributeValue ttl = (AttributeValue)gr.item().get("_ttl");
                    long ctime = new Date().getTime() / 1000L;
                    if (ttl != null && Long.parseLong(ttl.n()) < ctime) {
                        logger.info("Expiring " + id + " because TTL is " + ttl.n() + " at " + ctime);
                        this.uowexec.execute((ThreadAwareUOW)gu, false, () -> h.notfound());
                        return;
                    }
                    AttributeValue vers = (AttributeValue)gr.item().get("_version");
                    long version = Long.parseLong(vers.n());
                    ListTraverser trav = new ListTraverser((EvalContext)uow, (CollectionState)new CollectingState());
                    DynamoExtractor extractor = new DynamoExtractor(this.classLoader);
                    extractor.unmarshalMap((EvalContext)uow, (MarshallingTraverser)trav, ret);
                    Object obj = trav.asList().get(0);
                    if (obj instanceof ProvideIDOnCreate) {
                        ((ProvideIDOnCreate)obj).provideID(id);
                    }
                    retr = new DynamoRetrievedObject(gu, this, id, obj, version);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.uowexec.execute((ThreadAwareUOW)gu, false, () -> h.error((Throwable)ex));
                    return;
                }
                this.uowexec.execute((ThreadAwareUOW)gu, false, () -> h.found((RetrievedObject)retr));
            }
        });
        have.exceptionally(ex -> {
            logger.error("error retrieving " + id, ex);
            this.uowexec.execute((ThreadAwareUOW)gu, false, () -> h.error(ex));
            return null;
        });
    }

    public void create(UnitOfWork uow, String id, Object obj, StorageOptions options, TDACreateHandler h) {
        GLUnitOfWork gu = (GLUnitOfWork)uow;
        try {
            logger.info("Attempting to create " + id);
            if (obj instanceof ProvideIDOnCreate) {
                ((ProvideIDOnCreate)obj).provideID(id);
            }
            TreeMap<String, String> names = new TreeMap<String, String>();
            names.put("#k", "_key");
            PutItemRequest.Builder builder = DynamoHelper.putThing(this.entities, id, 1L, obj, options).expressionAttributeNames(names).conditionExpression("attribute_not_exists(#k)");
            CompletableFuture done = this.db.putItem((PutItemRequest)builder.build());
            done.thenAccept(x -> this.uowexec.execute((ThreadAwareUOW)gu, false, () -> {
                logger.info("successfully created " + id);
                gu.remember(id, (ExistingRecord)new AWSCreatedObject((PutItemResponse)x));
                h.success();
            }));
            done.exceptionally(ex -> {
                if (ex.getCause() instanceof ConditionalCheckFailedException) {
                    this.uowexec.execute((ThreadAwareUOW)gu, false, () -> {
                        logger.info(id + " already existed");
                        h.alreadyExists();
                    });
                } else {
                    this.uowexec.execute((ThreadAwareUOW)gu, false, () -> {
                        logger.error("error creating " + id, ex);
                        h.error(ex);
                    });
                }
                return null;
            });
        }
        catch (Exception ex2) {
            logger.error("error creating object", (Throwable)ex2);
            this.uowexec.execute((ThreadAwareUOW)gu, false, () -> h.error((Throwable)ex2));
        }
    }

    public <T> void update(UnitOfWork uow, String id, ExistingRecord cas, Object obj, TDAUpdateHandler h) {
        GLUnitOfWork gu = (GLUnitOfWork)uow;
        try {
            VersionHolder vh = (VersionHolder)cas;
            TreeMap<String, String> names = new TreeMap<String, String>();
            names.put("#v", "_version");
            TreeMap<String, AttributeValue> cv = new TreeMap<String, AttributeValue>();
            logger.info("Updating with current version expected to be " + vh.getVersion());
            cv.put(":currentVersion", (AttributeValue)AttributeValue.builder().n(Long.toString(vh.getVersion())).build());
            PutItemRequest pir = (PutItemRequest)DynamoHelper.putThing(this.entities, id, vh.getVersion() + 1L, obj, null).expressionAttributeNames(names).conditionExpression("#v = :currentVersion").expressionAttributeValues(cv).build();
            CompletableFuture done = this.db.putItem(pir);
            done.thenAccept(upd -> this.uowexec.execute((ThreadAwareUOW)gu, false, () -> {
                logger.info("Updated " + id);
                h.updated();
            }));
            done.exceptionally(ex -> {
                if (ex.getCause() instanceof ConditionalCheckFailedException) {
                    this.uowexec.execute((ThreadAwareUOW)gu, false, () -> {
                        logger.error(id + " since changed");
                        h.sinceChanged();
                    });
                } else {
                    this.uowexec.execute((ThreadAwareUOW)gu, false, () -> {
                        logger.error("error updating " + id, ex);
                        h.error(ex);
                    });
                }
                return null;
            });
        }
        catch (Exception ex2) {
            this.uowexec.execute((ThreadAwareUOW)gu, false, () -> {
                logger.error("error updating object", (Throwable)ex2);
                h.error((Throwable)ex2);
            });
        }
    }

    public void delete(UnitOfWork uow, String id, TDADeleteHandler h) {
        GLUnitOfWork gu = (GLUnitOfWork)uow;
        CompletableFuture done = this.db.deleteItem(DynamoHelper.deleteThing(this.entities, "key", id, new String[0]));
        done.thenAccept(upd -> this.uowexec.execute((ThreadAwareUOW)gu, false, () -> {
            logger.info("Successfully deleted " + id);
            h.success();
        }));
        done.exceptionally(ex -> {
            this.uowexec.execute((ThreadAwareUOW)gu, false, () -> {
                logger.error("error deleting " + id, ex);
                h.error(ex);
            });
            return null;
        });
    }

    public void upsert(UnitOfWork uow, String id, Object obj, TDAUpsertHandler h) {
        GLUnitOfWork gu = (GLUnitOfWork)uow;
        try {
            if (obj instanceof ProvideIDOnCreate) {
                ((ProvideIDOnCreate)obj).provideID(id);
            }
            TreeMap<String, AttributeValue> key = new TreeMap<String, AttributeValue>();
            key.put("_key", (AttributeValue)AttributeValue.builder().s(id).build());
            TreeMap<String, String> names = new TreeMap<String, String>();
            names.put("#v", "_version");
            TreeMap<String, AttributeValue> values = new TreeMap<String, AttributeValue>();
            values.put(":zero", (AttributeValue)AttributeValue.builder().n("0").build());
            values.put(":one", (AttributeValue)AttributeValue.builder().n("1").build());
            StringBuilder sb = new StringBuilder("SET #v = if_not_exists(#v, :zero) + :one");
            DynamoTopLevelMarshaller dfm = new DynamoTopLevelMarshaller();
            ObjectMarshaller om = new ObjectMarshaller((MarshallingTraverser)dfm, true);
            om.marshal(obj);
            dfm.complete();
            dfm.makeUpsert(names, values, sb, key.keySet(), true);
            logger.info("Upserting " + id);
            logger.debug("  using " + sb.toString().replace(", ", ",\n  "));
            logger.debug("Names:");
            for (Map.Entry e : names.entrySet()) {
                logger.debug("  " + (String)e.getKey() + " <- " + (String)e.getValue());
            }
            logger.debug("Values:");
            for (Map.Entry e : values.entrySet()) {
                logger.debug("  " + (String)e.getKey() + " <- " + e.getValue());
            }
            UpdateItemRequest uir = (UpdateItemRequest)UpdateItemRequest.builder().tableName(this.entities).key(key).updateExpression(sb.toString()).expressionAttributeNames(names).expressionAttributeValues(values).build();
            CompletableFuture done = this.db.updateItem(uir);
            done.thenAccept(upd -> this.uowexec.execute((ThreadAwareUOW)gu, false, () -> {
                logger.info("Updated " + id);
                h.success();
            }));
            done.exceptionally(ex -> {
                this.uowexec.execute((ThreadAwareUOW)gu, false, () -> {
                    logger.error("error upserting " + id, ex);
                    h.error(ex);
                });
                return null;
            });
        }
        catch (Exception ex2) {
            logger.error("error upserting " + id, (Throwable)ex2);
            this.uowexec.execute((ThreadAwareUOW)gu, false, () -> h.error((Throwable)ex2));
        }
    }

    public void touch(UnitOfWork uow, String id, StorageOptions options, TDATouchHandler h) {
        GLUnitOfWork gu = (GLUnitOfWork)uow;
        try {
            TreeMap<String, AttributeValue> map = new TreeMap<String, AttributeValue>();
            map.put("_key", (AttributeValue)AttributeValue.builder().s(id).build());
            TreeMap<String, String> names = new TreeMap<String, String>();
            names.put("#ttl", "_ttl");
            TreeMap<String, AttributeValue> cv = new TreeMap<String, AttributeValue>();
            ((AWSTxStorageOptions)options).applyTo(cv, ":");
            UpdateItemRequest uir = (UpdateItemRequest)UpdateItemRequest.builder().tableName(this.entities).key(map).updateExpression("SET #ttl = :ttl").expressionAttributeNames(names).expressionAttributeValues(cv).build();
            CompletableFuture done = this.db.updateItem(uir);
            done.thenAccept(x -> {
                logger.info("successfully touched " + id);
                this.uowexec.execute((ThreadAwareUOW)gu, false, () -> h.touched());
            });
            done.exceptionally(ex -> {
                logger.error("error touching " + id, ex);
                return null;
            });
        }
        catch (Exception ex2) {
            logger.error("error touching object", (Throwable)ex2);
        }
    }

    public void link(UnitOfWork uow, EntityLink link, TDALinkHandler h) {
        GLUnitOfWork gu = (GLUnitOfWork)uow;
        TableDefn table = this.tables.get(link.table());
        if (table == null) {
            throw new InvalidUsageException("There is no link table " + link.table());
        }
        DynamoHelper.DynamoTableDefn dtd = table.table;
        TreeMap<String, AttributeValue> key = new TreeMap<String, AttributeValue>();
        try {
            key.put(dtd.key, (AttributeValue)AttributeValue.builder().s(link.hash()).build());
            key.put(dtd.range, (AttributeValue)AttributeValue.builder().s(link.range()).build());
            TreeMap<String, String> names = new TreeMap<String, String>();
            TreeMap<String, AttributeValue> values = new TreeMap<String, AttributeValue>();
            StringBuilder sb = new StringBuilder("SET ");
            DynamoTopLevelMarshaller dfm = new DynamoTopLevelMarshaller();
            ObjectMarshaller om = new ObjectMarshaller((MarshallingTraverser)dfm, true);
            om.marshal((Object)link);
            dfm.complete();
            dfm.makeUpsert(names, values, sb, key.keySet(), false);
            logger.info("Upserting link " + key);
            logger.debug("  using " + sb.toString().replace(", ", ",\n  "));
            logger.debug("Names:");
            for (Map.Entry e : names.entrySet()) {
                logger.debug("  " + (String)e.getKey() + " <- " + (String)e.getValue());
            }
            logger.debug("Values:");
            for (Map.Entry e : values.entrySet()) {
                logger.debug("  " + (String)e.getKey() + " <- " + e.getValue());
            }
            UpdateItemRequest uir = (UpdateItemRequest)UpdateItemRequest.builder().tableName(table.tableName).key(key).updateExpression(sb.toString()).expressionAttributeNames(names).expressionAttributeValues(values).build();
            CompletableFuture done = this.db.updateItem(uir);
            done.thenAccept(upd -> this.uowexec.execute((ThreadAwareUOW)gu, false, () -> {
                logger.info("Upserted link " + key);
                h.success();
            }));
            done.exceptionally(ex -> {
                this.uowexec.execute((ThreadAwareUOW)gu, false, () -> {
                    logger.error("error upserting link " + key, ex);
                    h.error(ex);
                });
                return null;
            });
        }
        catch (Exception ex2) {
            logger.error("error upserting " + key, (Throwable)ex2);
            this.uowexec.execute((ThreadAwareUOW)gu, false, () -> h.error((Throwable)ex2));
        }
    }

    public void links(UnitOfWork uow, String table, String hash, TDALinkProvider h) {
        throw new NotImplementedException();
    }

    public void subscribe(UnitOfWork uow, String id, IdempotentHandler ih) {
        Dessication dess = ((DessicatableHandler)ih)._dessication();
        if (dess == null) {
            logger.info("null dessication, so does not want to subscribe");
            return;
        }
        AWSUOW au = (AWSUOW)uow;
        au.manualLock();
        try {
            logger.info("Subscribing to " + id);
            TreeMap<String, AttributeValue> map = new TreeMap<String, AttributeValue>();
            DynamoHelper.put(map, "_watch", id);
            DynamoHelper.put(map, "_subscriber", dess.name());
            DynamoHelper.put(map, "_intf", dess.intf());
            DynamoHelper.put(map, "_impl", dess.impl());
            for (String s : dess.fields()) {
                DynamoHelper.put(map, s, dess.get(s));
            }
            CompletableFuture done = this.db.putItem((PutItemRequest)DynamoHelper.putItem(this.subscriptions, map).build());
            done.thenAccept(x -> {
                logger.info("accepted");
                au.manualRelease();
            });
            done.exceptionally(ex -> {
                ex.printStackTrace(System.out);
                au.fatalError((Throwable)ex);
                au.manualRelease();
                return null;
            });
        }
        catch (Exception ex2) {
            logger.error("error subscribing to " + id, (Throwable)ex2);
            au.fatalError(ex2);
            au.manualRelease();
        }
    }

    public void unsubscribe(UnitOfWork uow, String id, IdempotentHandler ih) {
        throw new NotImplementedException();
    }

    public void notifySubscribers(UnitOfWork uow, String id, NotifySubscriber ns) {
        AWSUOW au = (AWSUOW)uow;
        au.manualLock();
        logger.info("Want to notify subscribers " + ns + " about change to " + id + " using " + this.creator);
        TreeMap<String, String> names = new TreeMap<String, String>();
        names.put("#watch", "_watch");
        TreeMap<String, AttributeValue> map = new TreeMap<String, AttributeValue>();
        DynamoHelper.put(map, ":watch", id);
        QueryRequest req = (QueryRequest)QueryRequest.builder().tableName(this.subscriptions).keyConditionExpression("#watch = :watch").expressionAttributeNames(names).expressionAttributeValues(map).build();
        CompletableFuture done = this.db.query(req);
        try {
            done.thenAccept(r -> {
                logger.info("Notifying " + r.items().size() + " subscribers about change to " + id);
                for (Map i : r.items()) {
                    logger.info("  Notifying subscriber guid " + ((AttributeValue)i.get("_subscriber")).s());
                    try {
                        ns.tellSubscriber(uow, id, this.creator.hydrate(this.retrieveHander(i)));
                    }
                    catch (Throwable t) {
                        logger.error("failed to notify subscriber guid " + ((AttributeValue)i.get("_subscriber")).s(), t);
                    }
                }
                au.manualRelease();
            });
            done.exceptionally(ex -> {
                ex.printStackTrace(System.out);
                au.fatalError((Throwable)ex);
                au.manualRelease();
                return null;
            });
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
    }

    private Dessication retrieveHander(Map<String, AttributeValue> i) {
        DessicatedHandler ret = new DessicatedHandler(DynamoHelper.string(i, "_subscriber"), DynamoHelper.string(i, "_intf"), DynamoHelper.string(i, "_impl"));
        for (Map.Entry<String, AttributeValue> e : i.entrySet()) {
            if (e.getKey().equals("_watch") || e.getKey().equals("_subscriber") || e.getKey().equals("_intf") || e.getKey().equals("_impl")) continue;
            ret.put(e.getKey(), DynamoHelper.extract(e.getValue()));
        }
        return ret;
    }

    public StorageOptions storageOptions() {
        return new AWSTxStorageOptions();
    }

    public class TableDefn {
        public final String tableName;
        public final DynamoHelper.DynamoTableDefn table;

        public TableDefn(String name, DynamoHelper.DynamoTableDefn d) {
            this.tableName = name;
            this.table = d;
        }
    }
}

