/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.compiler.upload;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.codehaus.jettison.json.JSONObject;
import org.flasck.flas.Configuration;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.compiler.jsgen.packaging.JSEnvironment;
import org.flasck.flas.compiler.modules.CompilerComplete;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.container.FLASBroker;
import org.flasck.jvm.fl.ClientContext;
import org.flasck.jvm.fl.TrivialEnvironment;
import org.flasck.jvm.ziniki.ContentObject;
import org.flasck.jvm.ziniki.PackageSources;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.ContentProvider;
import org.ziniki.ContentStore;
import org.ziniki.FileProvider;
import org.ziniki.compiler.options.ZinikiOptions;
import org.ziniki.compiler.upload.HttpAnswer;
import org.ziniki.compiler.upload.HttpClientExecutor;
import org.ziniki.compiler.upload.HttpExecutor;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.EvalContextFactory;
import org.ziniki.ziwsh.intf.IdempotentHandler;
import org.zinutils.bytecode.ByteCodeEnvironment;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.InvalidUsageException;
import org.zinutils.exceptions.WrappedException;
import org.zinutils.inabox.grizzly.actors.GrizzlyBuilder;
import org.zinutils.utils.FileUtils;

public class Uploader
implements CompilerComplete,
AutoCloseable {
    public static String[] flascklive = new String[]{"ziwsh", "flas-runtime", "flas-container", "flas-live"};
    public static String[] flascktest = new String[]{"flas-unittest", "javalogger"};
    private static final Logger logger = LoggerFactory.getLogger((String)"Uploader");
    private org.ziniki.Uploader uploader;
    private FLEvalContext cx;
    private ContentStore contentstore;
    private HttpExecutor cli;
    private FLASBroker broker;

    public static void main(String[] argv) throws Exception {
        if (argv.length < 3) {
            throw new InvalidUsageException("Usage: Uploader [--flascklib ziniki-uri <dir>] | [--modulelib ziniki-uri <name> <dir>]");
        }
        switch (argv[0]) {
            case "--flascklib": {
                try (Uploader uploader = new Uploader();){
                    uploader.makeConnection(argv[1]);
                    uploader.uploadFlasckLib(new File(argv[2]), true);
                    uploader.cx.close();
                    break;
                }
            }
            case "--modulelib": {
                if (argv.length < 4) {
                    throw new InvalidUsageException("Usage: Uploader --modulelib ziniki-uri <name> <dir>");
                }
                try (Uploader uploader = new Uploader();){
                    uploader.makeConnection(argv[1]);
                    uploader.uploadModuleLib(argv[2], new File(argv[3]), true);
                    break;
                }
            }
            default: {
                throw new InvalidUsageException("Usage: Uploader [--builtins]");
            }
        }
        System.exit(0);
    }

    public void setHttpClient(HttpExecutor cli) {
        this.cli = cli;
    }

    public void complete(ErrorReporter errors, Configuration config, List<PackageSources> packages, ByteCodeEnvironment jvm, JSEnvironment jse) {
        ZinikiOptions opts = (ZinikiOptions)config.getOptionsModule(ZinikiOptions.class);
        if (opts == null) {
            return;
        }
        if (opts.ziniki != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("YYYYMMdd");
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            String version = sdf.format(new Date());
            try {
                try {
                    this.makeConnection(opts.ziniki);
                }
                catch (Exception ex) {
                    errors.message((InputPosition)null, ex.getMessage());
                    return;
                }
                ArrayList<ContentObject> cos = new ArrayList<ContentObject>();
                for (File wz : config.webs) {
                    this.storeWebZip(cos, wz);
                }
                for (PackageSources ps : packages) {
                    ArrayList<String> deps = new ArrayList<String>();
                    for (String s : jse.packages()) {
                        if (s.contains("._") || ps.getPackageName().equals(s)) continue;
                        deps.add(s);
                    }
                    ArrayList<String> modules = new ArrayList<String>();
                    for (File m : config.modules) {
                        modules.add(m.getName());
                    }
                    this.createPackage(ps.getPackageName(), version, modules, deps);
                    this.uploadWebZips(ps.getPackageName(), version, cos);
                    this.upload(ps.getPackageName(), version, "sources", ps.sources());
                    this.upload(ps.getPackageName(), version, "unitTests", ps.unitTests());
                    this.upload(ps.getPackageName(), version, "assemblies", ps.assemblies());
                    this.upload(ps.getPackageName(), version, "systemTests", ps.systemTests());
                    this.deploy(ps.getPackageName(), version);
                }
            }
            catch (Exception ex) {
                ex = WrappedException.unwrapAny((Exception)ex);
                if (ex instanceof ConnectException) {
                    errors.message((InputPosition)null, "Could not connect to Ziniki at " + opts.ziniki);
                }
                logger.info("error uploading to Ziniki", (Throwable)ex);
                errors.message((InputPosition)null, "Error uploading to Ziniki: " + ex.toString());
            }
        }
    }

    private void makeConnection(String zinikiUri) throws Exception {
        String[] ts = this.ensureOpenIdLogin();
        if (ts == null) {
            return;
        }
        logger.info("uploading to ziniki " + zinikiUri + " with " + ts[0]);
        URI wsuri = URI.create(zinikiUri.replace("http", "ws").replaceFirst("/*$", "") + "/wsapi/" + ts[0] + "/" + ts[1]);
        SSLEngineConfigurator tlsStore = GrizzlyBuilder.initializeSSLAsAVeryTrustingClient();
        FLASBroker broker = new FLASBroker((EvalContextFactory)new TrivialEnvironment(), this.getClass().getClassLoader());
        broker.connectBeachhead(wsuri, tlsStore);
        if (!broker.successfullyConnected()) {
            throw new RuntimeException("Ziniki refused connection");
        }
        logger.info("Ziniki accepted connection");
        this.init(broker);
    }

    private String[] ensureOpenIdLogin() {
        String home = System.getProperty("user.home");
        if (home == null) {
            logger.info("no home directory");
            return null;
        }
        File f = new File(home, ".zintok");
        try {
            String all = FileUtils.readFile((File)f);
            JSONObject json = new JSONObject(all);
            return new String[]{json.getString("token"), json.getString("secret")};
        }
        catch (Exception ex) {
            logger.error("could not read ~/.zintok: " + ex);
            return null;
        }
    }

    public void init(FLASBroker broker) {
        this.broker = broker;
        this.uploader = (org.ziniki.Uploader)broker.require(org.ziniki.Uploader.class);
        this.contentstore = (ContentStore)broker.require(ContentStore.class);
        this.cx = new ClientContext();
    }

    public void provideServices(FLEvalContext cx, ContentStore cs, org.ziniki.Uploader usvc) {
        this.cx = cx;
        this.contentstore = cs;
        this.uploader = usvc;
    }

    public void uploadFlasckLib(File dir, boolean andWait) throws ClientProtocolException, TimeoutException, IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("YYYYMMdd");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String version = sdf.format(new Date());
        ArrayList<ContentObject> livejs = new ArrayList<ContentObject>();
        this.uploadFiles(dir, "packages/js/runtime/" + version, livejs, flascklive, "text/javascript");
        ArrayList<ContentObject> testjs = new ArrayList<ContentObject>();
        this.uploadFiles(dir, "packages/js/runtime/test/" + version, testjs, flascktest, "text/javascript");
        LatchedHandler lih = new LatchedHandler();
        this.uploader.provideFlasckLib(this.cx, new Object[]{version, livejs, testjs, lih});
        if (andWait) {
            lih.waitFor(2500L, TimeUnit.MILLISECONDS);
        }
    }

    public void uploadModuleLib(String name, File dir, boolean andWait) throws ClientProtocolException, TimeoutException, IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("YYYYMMdd");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String version = sdf.format(new Date());
        String[] live = new String[]{};
        String[] test = new String[]{"zintest"};
        ArrayList<ContentObject> livejs = new ArrayList<ContentObject>();
        this.uploadFiles(dir, "packages/js/modules/" + name + "/" + version, livejs, live, "text/javascript");
        ArrayList<ContentObject> testjs = new ArrayList<ContentObject>();
        this.uploadFiles(dir, "packages/js/modules/" + name + "/test/" + version, testjs, test, "text/javascript");
        LatchedHandler lih = new LatchedHandler();
        this.uploader.provideModuleLib(this.cx, new Object[]{name, version, livejs, testjs, lih});
        if (andWait) {
            lih.waitFor(2500L, TimeUnit.MILLISECONDS);
        }
    }

    private void uploadFiles(File dir, String toExplicitPath, List<ContentObject> cos, String[] files, String ct) throws TimeoutException, ClientProtocolException, IOException {
        for (String s : files) {
            String path = null;
            if (toExplicitPath != null) {
                path = toExplicitPath + "/" + s + ".js";
            }
            this.uploadFile(cos, path, new File(dir, s + ".js"), ct);
        }
    }

    private void uploadFile(List<ContentObject> cos, String toExplicitPath, File file, String ct) throws TimeoutException, ClientProtocolException, IOException {
        LatchedContentProvider cp = new LatchedContentProvider();
        if (toExplicitPath == null) {
            this.contentstore.newObject(this.cx, new Object[]{file.getName(), ct, cp});
        } else {
            this.contentstore.objectPath(this.cx, new Object[]{toExplicitPath, ct, cp});
        }
        cp.waitFor(2500L, TimeUnit.MILLISECONDS);
        cos.add(cp.co);
        if (cp.co == null) {
            throw new CantHappenException("there was no CO returned");
        }
        String sendTo = cp.co.writeUrl();
        HttpPut put = new HttpPut(sendTo);
        put.setEntity((HttpEntity)new FileEntity(file));
        HttpAnswer resp = this.execute((HttpUriRequest)put);
        if (resp != null) {
            resp.writeTo(System.out);
            System.out.println();
        }
    }

    public void storeWebZip(List<ContentObject> cos, File wz) throws TimeoutException {
        LatchedContentProvider cp = new LatchedContentProvider();
        this.contentstore.newObject(this.cx, new Object[]{wz.getName(), "text/plain", cp});
        cp.waitFor(2500L, TimeUnit.MILLISECONDS);
        cos.add(cp.co);
        if (cp.co == null) {
            throw new CantHappenException("there was no CO returned");
        }
        String sendTo = cp.co.writeUrl();
        if (sendTo == null) {
            throw new CantHappenException("CO did not have a valid writeTo address " + cp.co);
        }
        logger.info("Uploading webzip to " + sendTo);
        HttpPut put = new HttpPut(sendTo);
        try {
            FileEntity is;
            if (wz.isDirectory()) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ZipOutputStream zos = new ZipOutputStream(baos);
                for (File f : FileUtils.findFilesUnderMatching((File)wz, (String)"*")) {
                    zos.putNextEntry(new ZipEntry(f.getPath()));
                    FileUtils.copyFileToStream((File)new File(wz, f.getPath()), (OutputStream)zos);
                }
                zos.close();
                is = new ByteArrayEntity(baos.toByteArray());
            } else if (wz.canRead()) {
                is = new FileEntity(wz);
            } else {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                ZipOutputStream zos = new ZipOutputStream(os);
                zos.close();
                is = new ByteArrayEntity(os.toByteArray());
            }
            put.setEntity((HttpEntity)is);
            HttpAnswer resp = this.execute((HttpUriRequest)put);
            if (resp == null) {
                throw new CantHappenException("null response received");
            }
            resp.assertSuccess();
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private HttpAnswer execute(HttpUriRequest put) throws ClientProtocolException, IOException {
        if (this.cli == null) {
            this.cli = new HttpClientExecutor();
        }
        return this.cli.exec(put);
    }

    public void createPackage(String pkg, String version, List<String> modules, List<String> deps) throws TimeoutException {
        LatchedHandler ih = new LatchedHandler();
        this.uploader.newPackage(this.cx, new Object[]{pkg, version, modules, deps, ih});
        ih.waitFor(15L, TimeUnit.SECONDS);
    }

    public void uploadWebZips(String pkg, String version, List<ContentObject> cos) throws TimeoutException {
        LatchedHandler ih = new LatchedHandler();
        this.uploader.webzips(this.cx, new Object[]{pkg, version, cos, ih});
        ih.waitFor(15L, TimeUnit.SECONDS);
    }

    private void upload(String packageName, String version, String kind, List<ContentObject> files) throws TimeoutException {
        for (ContentObject co : files) {
            this.uploadFile(packageName, version, kind, co);
        }
    }

    private void uploadFile(String packageName, String version, String kind, ContentObject co) throws TimeoutException {
        Uploaded fp = new Uploaded();
        this.uploader.provideFile(this.cx, new Object[]{packageName, version, kind, co.key(), fp});
        fp.waitFor(15L, TimeUnit.SECONDS);
        if (fp.uploadTo == null) {
            throw new CantHappenException("there was no CO returned");
        }
        String sendTo = fp.uploadTo.writeUrl();
        HttpPut put = new HttpPut(sendTo);
        try {
            put.setEntity((HttpEntity)new StringEntity(co.asString()));
            HttpAnswer resp = this.execute((HttpUriRequest)put);
            if (resp == null) {
                throw new CantHappenException("null response received");
            }
            resp.assertSuccess();
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void deploy(String pkg, String version) throws TimeoutException {
        LatchedHandler ih = new LatchedHandler();
        this.uploader.deploy(this.cx, new Object[]{pkg, version, ih});
        ih.waitFor(60L, TimeUnit.SECONDS);
    }

    @Override
    public void close() throws Exception {
        if (this.broker != null) {
            this.broker.close();
        }
    }

    public static final class Uploaded
    extends LatchedBase
    implements FileProvider {
        private ContentObject uploadTo;

        public void success(EvalContext cx) {
        }

        public Object uploadTo(FLEvalContext arg0, Object[] arg1) {
            this.uploadTo = (ContentObject)arg1[0];
            this.latch.countDown();
            return null;
        }
    }

    public static final class LatchedContentProvider
    extends LatchedBase
    implements ContentProvider {
        private ContentObject co;

        public void success(EvalContext cx) {
        }

        public Object provide(FLEvalContext arg0, Object[] arg1) {
            this.co = (ContentObject)arg1[0];
            this.latch.countDown();
            return null;
        }
    }

    public static final class LatchedHandler
    extends LatchedBase {
        public void success(EvalContext cx) {
            this.latch.countDown();
        }
    }

    public static abstract class LatchedBase
    implements IdempotentHandler {
        protected final CountDownLatch latch = new CountDownLatch(1);
        protected String error;

        public void failure(EvalContext cx, Object error) {
            this.error = (String)error;
            this.latch.countDown();
        }

        public Object name() {
            return null;
        }

        public void waitFor(long cnt, TimeUnit tu) throws TimeoutException {
            try {
                boolean done = this.latch.await(cnt, tu);
                if (!done) {
                    throw new TimeoutException();
                }
                if (this.error != null) {
                    throw new InvalidUsageException(this.error);
                }
            }
            catch (InterruptedException ex) {
                throw new TimeoutException();
            }
        }
    }
}

