/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.services.uploader;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.flasck.jvm.FLEvalContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.DataStore;
import org.ziniki.FileProvider;
import org.ziniki.Uploader;
import org.ziniki.common.UOWHost;
import org.ziniki.coreimpl.ZinikiClassLoader;
import org.ziniki.intf.ZiId;
import org.ziniki.intf.ZiIdFactory;
import org.ziniki.paas.interfaces.ContentStorage;
import org.ziniki.secondaries.PackageByName;
import org.ziniki.secondaries.PackageByNameVersion;
import org.ziniki.services.uploader.AttachWebZip;
import org.ziniki.services.uploader.CreateNewPackage;
import org.ziniki.services.uploader.DeployPackage;
import org.ziniki.services.uploader.ProvideFile;
import org.ziniki.tdastore.TDAStorage;
import org.ziniki.tdastore.TxManager;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.RelationHandler;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.ziwsh.intf.HandlerNameProvider;
import org.ziniki.ziwsh.intf.IdempotentHandler;
import org.ziniki.ziwsh.intf.Param;
import org.ziniki.ziwsh.intf.ZiwshBroker;
import org.ziniki.ziwsh.jvm.UUIDHandlerNameProvider;
import org.zinutils.exceptions.NotImplementedException;
import org.zinutils.exceptions.WrappedException;

public class ZinikiCodeUploader
implements Uploader {
    private static final Logger logger = LoggerFactory.getLogger((String)"Ziniki");
    private final DataStore ds;
    private final TDAStorage storage;
    private final ContentStorage cs;
    private final TxManager txmgr;
    private final ZiIdFactory factory;
    private final HandlerNameProvider handlerNameProvider;
    private final ClassLoader classLoader;

    public ZinikiCodeUploader(@Param(value="datastore") DataStore ds, @Param(value="storage") TDAStorage tdastorage, @Param(value="contentStore") ContentStorage cs, @Param(value="broker") ZiwshBroker broker, @Param(value="executor") Executor exec, @Param(value="txmanager") TxManager txmgr, @Param(value="factory") ZiIdFactory factory, @Param(value="handlerNameProvider") HandlerNameProvider handlerNameProvider) {
        this.ds = ds;
        this.storage = tdastorage;
        this.cs = cs;
        this.txmgr = txmgr;
        this.factory = factory;
        this.handlerNameProvider = handlerNameProvider;
        this.classLoader = broker.getClassLoader();
        broker.register(Uploader.class, (Object)this);
    }

    public Object name() {
        throw new NotImplementedException();
    }

    public Object newPackage(FLEvalContext cx, Object[] args) {
        UnitOfWork uow = (UnitOfWork)cx;
        String name = (String)args[0];
        String version = (String)args[1];
        List modules = (List)args[2];
        List dependencies = (List)args[3];
        IdempotentHandler ih = (IdempotentHandler)args[4];
        try {
            ZiId appArena = this.factory.simple("data", ((UOWHost)uow.trait(UOWHost.class)).host, "arena", "apps");
            CreateNewPackage cnp = new CreateNewPackage(this.factory, uow, this.ds, appArena, name, version, modules, dependencies, ih, this.handlerNameProvider);
            Relation r = uow.relation((RelationHandler)cnp);
            this.ds.secondaryKey(cx, new Object[]{appArena.toString(), PackageByName.class.getName(), Arrays.asList(name), cnp.packages(r)});
            r.background("codepkgvers");
            r.logic("resolveDependencies");
            r.whenCommitted("reply");
            r.makeReady();
            return null;
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Throwable)ex);
        }
    }

    public Object webzips(FLEvalContext cx, Object[] args) {
        UnitOfWork uow = (UnitOfWork)cx;
        String pkg = (String)args[0];
        String version = (String)args[1];
        List cos = (List)args[2];
        IdempotentHandler ih = (IdempotentHandler)args[3];
        try {
            ZiId appArena = this.factory.simple("data", ((UOWHost)uow.trait(UOWHost.class)).host, "arena", "apps");
            AttachWebZip awz = new AttachWebZip(this.cs, this.factory, uow, this.ds, appArena, pkg, version, cos, ih);
            Relation r = uow.relation((RelationHandler)awz);
            this.ds.secondaryKey(cx, new Object[]{appArena.toString(), PackageByNameVersion.class.getName(), Arrays.asList(pkg, version), awz.doWork(r)});
            r.whenCommitted("reply");
            r.whenRolledBack("error");
            r.makeReady();
            return null;
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Throwable)ex);
        }
    }

    public Object provideFile(FLEvalContext cx, Object[] args) {
        UnitOfWork uow = (UnitOfWork)cx;
        String pkg = (String)args[0];
        String version = (String)args[1];
        String kind = (String)args[2];
        String fileName = (String)args[3];
        FileProvider fp = (FileProvider)args[4];
        try {
            ZiId appArena = this.factory.simple("data", ((UOWHost)uow.trait(UOWHost.class)).host, "arena", "apps");
            ProvideFile pf = new ProvideFile(this.cs, this.factory, uow, this.ds, appArena, pkg, version, kind, fileName, fp);
            Relation r = uow.relation((RelationHandler)pf);
            this.ds.secondaryKey(cx, new Object[]{appArena.toString(), PackageByNameVersion.class.getName(), Arrays.asList(pkg, version), pf.handleCode(r)});
            r.whenCommitted("reply");
            r.whenRolledBack("error");
            r.makeReady();
            return null;
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Throwable)ex);
        }
    }

    public Object deploy(FLEvalContext cx, Object[] args) {
        UnitOfWork uow = (UnitOfWork)cx;
        uow.setWaitTime(30, TimeUnit.SECONDS);
        String pkg = (String)args[0];
        String version = (String)args[1];
        IdempotentHandler ih = (IdempotentHandler)args[2];
        try {
            logger.info("retrieving pkg " + pkg + ":" + version);
            ZiId appArena = this.factory.simple("data", ((UOWHost)uow.trait(UOWHost.class)).host, "arena", "apps");
            DeployPackage awz = new DeployPackage(this.storage, this.txmgr, this.cs, this.factory, uow, this.ds, appArena, pkg, version, ih, (ZinikiClassLoader)this.classLoader);
            Relation r = uow.relation((RelationHandler)awz);
            this.ds.secondaryKey(cx, new Object[]{appArena.toString(), PackageByName.class.getName(), Arrays.asList(pkg), awz.rememberPackage(r)});
            this.ds.secondaryKey(cx, new Object[]{appArena.toString(), PackageByNameVersion.class.getName(), Arrays.asList(pkg, version), awz.compileIt(r)});
            r.background("codepkg");
            r.background("codepkgvers");
            r.background("modules");
            r.background("dependencies");
            r.logic("invokeCompiler");
            r.whenCommitted("reply");
            r.whenRolledBack("error");
            r.makeReady();
            return null;
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Throwable)ex);
        }
    }

    public Object provideFlasckLib(FLEvalContext cx, Object[] args) {
        UnitOfWork uow = (UnitOfWork)cx;
        String name = "flascklib";
        String version = (String)args[0];
        List livejs = (List)args[1];
        List testjs = (List)args[2];
        IdempotentHandler ih = (IdempotentHandler)args[3];
        try {
            ZiId appArena = this.factory.simple("data", ((UOWHost)uow.trait(UOWHost.class)).host, "arena", "apps");
            CreateNewPackage cnp = new CreateNewPackage(this.factory, uow, this.ds, appArena, name, version, null, null, ih, (HandlerNameProvider)new UUIDHandlerNameProvider());
            Relation r = uow.relation((RelationHandler)cnp);
            this.ds.secondaryKey(cx, new Object[]{appArena.toString(), PackageByName.class.getName(), Arrays.asList(name), cnp.packages(r)});
            r.load("livejs", (Object)livejs);
            r.load("testjs", (Object)testjs);
            r.background("codepkgvers");
            r.logic("attachJsToCPV");
            r.whenCommitted("reply");
            r.makeReady();
            return null;
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Throwable)ex);
        }
    }

    public Object provideModuleLib(FLEvalContext cx, Object[] args) {
        UnitOfWork uow = (UnitOfWork)cx;
        String name = (String)args[0];
        String version = (String)args[1];
        List livejs = (List)args[2];
        List testjs = (List)args[3];
        IdempotentHandler ih = (IdempotentHandler)args[4];
        try {
            ZiId appArena = this.factory.simple("data", ((UOWHost)uow.trait(UOWHost.class)).host, "arena", "apps");
            CreateNewPackage cnp = new CreateNewPackage(this.factory, uow, this.ds, appArena, name, version, null, null, ih, (HandlerNameProvider)new UUIDHandlerNameProvider());
            Relation r = uow.relation((RelationHandler)cnp);
            this.ds.secondaryKey(cx, new Object[]{appArena.toString(), PackageByName.class.getName(), Arrays.asList(name), cnp.packages(r)});
            r.load("livejs", (Object)livejs);
            r.load("testjs", (Object)testjs);
            r.background("codepkgvers");
            r.logic("attachJsToCPV");
            r.whenCommitted("reply");
            r.makeReady();
            return null;
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Throwable)ex);
        }
    }
}

