/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.services.uploader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.flasck.flas.compiler.jsgen.packaging.JSUploader;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.assembly.ApplicationAssembly;
import org.flasck.jvm.ziniki.ContentObject;
import org.ziniki.CodePackage;
import org.ziniki.CodePackageVersion;
import org.ziniki.cbtxstore.gls.GLUnitOfWork;
import org.ziniki.common.UOWHost;
import org.ziniki.coreimpl.ZinikiClassLoader;
import org.ziniki.intf.ZiIdFactory;
import org.ziniki.paas.interfaces.ContentStorage;
import org.ziniki.paas.interfaces.UploadContent;
import org.ziniki.services.uploader.BuildApplicationAssembly;
import org.ziniki.tdastore.TDAStorage;
import org.ziniki.tdastore.TxManager;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.RelationHandler;
import org.zinutils.bytecode.ByteCodeCreator;
import org.zinutils.bytecode.ByteCodeEnvironment;
import org.zinutils.utils.FileUtils;

public class StoreAssembly
extends BuildApplicationAssembly
implements RelationHandler,
JSUploader {
    private final ZiIdFactory factory;
    private final GLUnitOfWork uow;
    private final Relation r;
    private final ContentStorage cs;
    private final String version;
    private final CodePackage codepkg;
    private final CodePackageVersion codepkgvers;
    private final ZinikiClassLoader classLoader;
    private boolean wantBlock;

    public StoreAssembly(FLEvalContext cx, TDAStorage storage, TxManager txmgr, ZiIdFactory factory, ContentStorage cs, ZinikiClassLoader classLoader, String version, CodePackage codepkg, CodePackageVersion codepkgvers) {
        super(cx);
        this.factory = factory;
        this.cs = cs;
        this.classLoader = classLoader;
        this.version = version;
        this.codepkg = codepkg;
        this.codepkgvers = codepkgvers;
        this.uow = (GLUnitOfWork)cx;
        this.r = this.uow.relation((RelationHandler)this);
        this.wantBlock = false;
    }

    @Override
    protected ContentObject get(String key) {
        return this.cs.get(key);
    }

    @Override
    public ContentObject uploadJs(File f) {
        if (f.getName().contains("._")) {
            return null;
        }
        ContentObject co = this.cs.upload("packages/js/" + FileUtils.dropExtension((String)f.getName()) + "/" + this.version + "/" + f.getName(), f, "text/javascript; encoding=utf-8");
        ArrayList<ContentObject> livejs = (ArrayList<ContentObject>)this.codepkgvers._field_livejs((FLEvalContext)this.uow, null);
        if (livejs == null) {
            livejs = new ArrayList<ContentObject>();
            this.codepkgvers.set("livejs", livejs);
        }
        livejs.add(co);
        return co;
    }

    public ContentObject uploadFlim(File f) {
        ContentObject co = this.cs.upload("packages/flim/" + FileUtils.dropExtension((String)f.getName()) + "/" + this.version + "/" + f.getName(), f, "text/flim");
        ArrayList<ContentObject> flims = (ArrayList<ContentObject>)this.codepkgvers._field_flim((FLEvalContext)this.uow, null);
        if (flims == null) {
            flims = new ArrayList<ContentObject>();
            this.codepkgvers.set("flim", flims);
        }
        flims.add(co);
        return co;
    }

    @Override
    public ContentObject uploadResource(String type, String name, InputStream is, long length, boolean close, String ctype) throws IOException {
        return this.cs.upload("packages/" + type + "/" + this.aname + "/" + this.version + "/" + name, is, ctype, length, false);
    }

    public void uploadJar(ByteCodeEnvironment bce, String pkgName) {
        String pfx = pkgName;
        if (pkgName.equals("root.package")) {
            pfx = "org.flasck.jvm.builtin";
        }
        try {
            ZipOutputStream zos = null;
            UploadContent upload = null;
            for (ByteCodeCreator c : bce.all()) {
                String clname = c.getCreatedName();
                logger.info("upload " + pkgName + " with bce has class " + clname);
                if (!clname.startsWith(pfx) || clname.contains("_st_") || clname.contains("_ut_")) continue;
                if (zos == null) {
                    upload = this.cs.upload("packages/jar/" + pkgName + "/" + this.version + "/" + pkgName + ".jar", "application/jar");
                    zos = new ZipOutputStream(upload.writeTo());
                }
                logger.info("uploading " + clname + " to " + pkgName);
                zos.putNextEntry(new ZipEntry(FileUtils.convertDottedToPath((String)clname).getPath() + ".class"));
                zos.write(c.generate());
            }
            if (zos != null) {
                zos.close();
                this.classLoader.addPackage(upload.co());
            }
        }
        catch (IOException ex) {
            logger.error("could not upload jar for " + pkgName, (Throwable)ex);
        }
    }

    @Override
    protected void save(ApplicationAssembly assembly) {
        this.codepkg.set("latestVersion", this.codepkgvers.get("version"));
        this.r.update(this.codepkg.id(), (Object)this.codepkg);
        this.codepkgvers.set("deployed", (Object)true);
        this.r.update(this.codepkgvers.id(), (Object)this.codepkgvers);
        String id = this.factory.simple("assembler", ((UOWHost)this.uow.trait(UOWHost.class)).host, "assembly", this.aname).toString();
        this.r.upsert(id, (Object)assembly);
        this.r.makeReady();
    }

    @Override
    public void traversalDone() throws Exception {
        if (this.wantBlock) {
            this.uow.block();
        }
    }
}

