/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.services.uploader;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.Configuration;
import org.flasck.flas.Main;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.errors.ErrorResult;
import org.flasck.flas.repository.AssemblyVisitor;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.ziniki.PackageSources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.CodePackage;
import org.ziniki.CodePackageVersion;
import org.ziniki.DataHandler;
import org.ziniki.DataStore;
import org.ziniki.cbtxstore.gls.TxError;
import org.ziniki.core.concepts.EntityReference;
import org.ziniki.coreimpl.ZinikiClassLoader;
import org.ziniki.intf.ZiId;
import org.ziniki.intf.ZiIdFactory;
import org.ziniki.paas.interfaces.ContentStorage;
import org.ziniki.services.uploader.COPackageSources;
import org.ziniki.services.uploader.StoreAssembly;
import org.ziniki.tdastore.TDAStorage;
import org.ziniki.tdastore.TxManager;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.RelationHandler;
import org.ziniki.tdastore.gls.Slot;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.ziwsh.intf.DessicatableHandler;
import org.ziniki.ziwsh.intf.Dessication;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.IdempotentHandler;

public class DeployPackage
implements RelationHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"Ziniki");
    private TDAStorage storage;
    private TxManager txmgr;
    private ContentStorage cs;
    private ZiIdFactory factory;
    private final UnitOfWork uow;
    private String packageName;
    private String version;
    private IdempotentHandler ih;
    private FLEvalContext cx;
    private ZinikiClassLoader classLoader;
    private final ErrorResult errors;
    private final Configuration config;

    public DeployPackage(TDAStorage storage, TxManager txmgr, ContentStorage cs, ZiIdFactory factory, UnitOfWork uow, DataStore ds, ZiId appArena, String packageName, String version, IdempotentHandler ih, ZinikiClassLoader classLoader) {
        this.storage = storage;
        this.txmgr = txmgr;
        this.cs = cs;
        this.factory = factory;
        this.uow = uow;
        this.packageName = packageName;
        this.version = version;
        this.ih = ih;
        this.classLoader = classLoader;
        this.cx = (FLEvalContext)uow;
        this.errors = new ErrorResult();
        this.config = new Configuration((ErrorReporter)this.errors, new String[0]);
    }

    public Object rememberPackage(Relation r) {
        return new RememberPackage(r, this.packageName);
    }

    public DataHandler compileIt(Relation r) {
        return new CompileIt(r, this.packageName, this.version);
    }

    public void invokeCompiler(Relation r, @Slot(value="codepkg") CodePackage codepkg, @Slot(value="codepkgvers") CodePackageVersion codepkgvers, @Slot(value="flascklib") CodePackageVersion flascklib, @Slot(value="modules") List<CodePackageVersion> modules, @Slot(value="dependencies") List<CodePackageVersion> dependencies) throws IOException {
        logger.info("flascklib = " + flascklib + " modules = " + modules + " dependencies = " + dependencies);
        if (flascklib != null) {
            this.config.flascklibCPV = new COPackageSources(flascklib);
        }
        this.config.dependencies = new ArrayList();
        if (dependencies != null) {
            for (CodePackageVersion cpv : dependencies) {
                this.config.dependencies.add(new COPackageSources(cpv));
            }
        }
        this.config.moduleCOs = new ArrayList();
        if (modules != null) {
            for (CodePackageVersion cpv : modules) {
                this.config.moduleCOs.add(new COPackageSources(cpv));
            }
        }
        this.config.writeJS = Files.createTempDirectory("zinikijs", new FileAttribute[0]).toFile();
        this.config.writeJVM = Files.createTempDirectory("zinikijs", new FileAttribute[0]).toFile();
        this.config.jstestdir = Files.createTempDirectory("testhtml", new FileAttribute[0]).toFile().getPath();
        StoreAssembly storer = new StoreAssembly(this.cx, this.storage, this.txmgr, this.factory, this.cs, this.classLoader, this.version, codepkg, codepkgvers);
        try {
            logger.info("compiling " + codepkgvers.id());
            Main.uploader((ErrorResult)this.errors, (Configuration)this.config, (PackageSources)new COPackageSources(codepkgvers), (AssemblyVisitor)storer);
            logger.info("returning " + (this.errors.hasErrors() ? "failure" : "success"));
            if (this.errors.hasErrors()) {
                this.uow.fatalError((Throwable)new RuntimeException(this.errors.singleString()));
            }
        }
        catch (Throwable ex) {
            logger.error("error in deploy call to compiler", ex);
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            this.ih.failure((EvalContext)this.cx, (Object)sw.toString());
        }
    }

    public void reply(Relation r) {
        this.ih.success((EvalContext)this.cx);
    }

    public void error(TxError error) {
        String msg = "unknown error";
        if (error != null) {
            msg = error.toString();
        }
        this.ih.failure((EvalContext)this.cx, (Object)msg);
    }

    public static final class RememberPackage
    implements DataHandler,
    DessicatableHandler {
        private final Relation r;
        private final String packageName;

        public RememberPackage(Relation r, String packageName) {
            this.r = r;
            this.packageName = packageName;
        }

        public String _handlerID() {
            return null;
        }

        public Dessication _dessication() {
            return null;
        }

        public void success(EvalContext cx) {
        }

        public void failure(EvalContext cx, Object error) {
            ((UnitOfWork)cx).fatalError((Throwable)new RuntimeException((String)error));
        }

        public Object missing(FLEvalContext cx, Object[] arg1) {
            ((UnitOfWork)cx).fatalError((Throwable)new RuntimeException("There is no package " + this.packageName));
            return null;
        }

        public Object value(FLEvalContext cx, Object[] args) {
            try {
                CodePackage cp = (CodePackage)args[0];
                this.r.load("codepkg", (Object)cp);
            }
            catch (Throwable t) {
                ((UnitOfWork)cx).fatalError(t);
            }
            return null;
        }

        public Object name() {
            return null;
        }
    }

    public static final class CompileIt
    implements DataHandler,
    DessicatableHandler {
        private final Relation r;
        private final String packageName;
        private final String version;

        public CompileIt(Relation r, String packageName, String version) {
            this.r = r;
            this.packageName = packageName;
            this.version = version;
        }

        public String _handlerID() {
            return null;
        }

        public Dessication _dessication() {
            return null;
        }

        public void success(EvalContext cx) {
        }

        public void failure(EvalContext cx, Object error) {
            ((UnitOfWork)cx).fatalError((Throwable)new RuntimeException((String)error));
        }

        public Object missing(FLEvalContext cx, Object[] arg1) {
            ((UnitOfWork)cx).fatalError((Throwable)new RuntimeException("There is no package " + this.packageName + ":" + this.version));
            return null;
        }

        public Object value(FLEvalContext cx, Object[] args) {
            try {
                CodePackageVersion cpv = (CodePackageVersion)args[0];
                this.r.load("codepkgvers", (Object)cpv);
                if (cpv._field_flascklib(cx, null) != null) {
                    EntityReference er = (EntityReference)cpv._field_flascklib(cx, null);
                    this.r.get("flascklib", er.refersTo().toString());
                } else {
                    this.r.load("flascklib", null);
                }
                List deps = (List)cpv._field_dependencies(cx, null);
                if (deps != null && !deps.isEmpty()) {
                    ArrayList<String> dlist = new ArrayList<String>();
                    for (EntityReference er : deps) {
                        dlist.add(er.refersTo().toString());
                    }
                    this.r.getList("dependencies", dlist);
                } else {
                    this.r.load("dependencies", null);
                }
                List modules = (List)cpv._field_modules(cx, null);
                if (modules != null && !modules.isEmpty()) {
                    ArrayList<String> dlist = new ArrayList<String>();
                    for (EntityReference er : modules) {
                        dlist.add(er.refersTo().toString());
                    }
                    this.r.getList("modules", dlist);
                } else {
                    this.r.load("modules", null);
                }
            }
            catch (Throwable t) {
                ((UnitOfWork)cx).fatalError(t);
            }
            return null;
        }

        public Object name() {
            return null;
        }
    }
}

